---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-Cookie取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Request.pas` 105-110行目（Cookie メソッド）
- E-02: `src/Horse.Request.pas` 222-236行目（InitializeCookie メソッド）
- E-03: `src/Horse.Request.pas` 222-223行目（定数 KEY=0, VALUE=1）
- E-04: `src/Horse.Request.pas` 230行目（THorseCoreParam.Create + Required(False)）
- E-05: `src/Horse.Request.pas` 231行目（CookieFields ループ）
- E-06: `src/Horse.Request.pas` 233行目（Split(['='])）
- E-07: `src/Horse.Request.pas` 234行目（AddOrSetValue）
- E-08: `src/Horse.Core.Param.pas` 66-76行目（ContainsKey、大文字小文字非区別）
- E-09: `src/Horse.Core.Param.pas` 179-189行目（GetItem）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` 14行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseRequest.CookieメソッドでCookieを取得 | E-01, E-10 | ○ |
| C-02 | 遅延初期化パターンを使用 | E-01 | ○ |
| C-03 | InitializeCookieでCookie解析を実行 | E-01, E-02 | ○ |
| C-04 | Required(False)で必須検証を無効化 | E-04 | ○ |
| C-05 | CookieFieldsをループ処理 | E-05 | ○ |
| C-06 | "="でSplitしてKey/Valueを取得 | E-06 | ○ |
| C-07 | 配列[0]がKey、配列[1]がValue | E-03, E-06 | ○ |
| C-08 | AddOrSetValueでDictionaryに格納 | E-07 | ○ |
| C-09 | 同名Cookieは後の値で上書き（AddOrSetValue） | E-07 | ○ |
| C-10 | キー比較は大文字小文字を区別しない | E-08 | ○ |
| C-11 | 存在しないCookieを取得すると空文字列を返す | E-09 | ○ |
| C-12 | THorseList.Create で空のDictionaryを生成 | E-04 | ○ |
| C-13 | DelphiとFree Pascal両対応 | E-01, E-02 | ○ |
| C-14 | O(n)の計算量でCookie解析 | E-05 (ループ処理) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Cookie解析のロジックはシンプルで、すべてソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] InitializeCookieでの"="分割ロジックが正確に記述されているか確認
- [ ] 定数KEY=0, VALUE=1が正しく使用されていることを確認
- [ ] AddOrSetValueによる上書き動作が意図した仕様であるか確認
