---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-ContentFields取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Request.pas` 98-103行目（ContentFields メソッド）
- E-02: `src/Horse.Request.pas` 169-220行目（InitializeContentFields メソッド）
- E-03: `src/Horse.Request.pas` 93-96行目（CanLoadContentFields メソッド）
- E-04: `src/Horse.Request.pas` 261-276行目（IsFormURLEncoded メソッド）
- E-05: `src/Horse.Request.pas` 278-293行目（IsMultipartForm メソッド）
- E-06: `src/Horse.Request.pas` 179行目（THorseCoreParam.Create + Required(False)）
- E-07: `src/Horse.Request.pas` 183-184行目（Files ループ + AddStream）
- E-08: `src/Horse.Request.pas` 186-219行目（ContentFields ループ）
- E-09: `src/Horse.Request.pas` 214-215行目（空キーチェック + AddOrSetValue）
- E-10: `src/Horse.Core.Param.pas` 128-135行目（AddStream メソッド）
- E-11: `src/Horse.Core.Param.pas` 191-207行目（NewField メソッド、ストリーム判定）
- E-12: `src/Horse.Core.Param.Field.pas` 264-275行目（AsStream メソッド）
- E-13: `src/Horse.Core.Param.Field.pas` 424-439行目（SaveToFile メソッド）
- E-14: `src/Horse.Commons.pas` 89-92行目（TMimeTypes定義）
- E-15: `docs/code-to-docs/機能一覧/機能一覧.csv` 15行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseRequest.ContentFieldsメソッドでフォームデータを取得 | E-01, E-15 | ○ |
| C-02 | 遅延初期化パターンを使用 | E-01 | ○ |
| C-03 | InitializeContentFieldsでフォームデータを解析 | E-01, E-02 | ○ |
| C-04 | Required(False)で必須検証を無効化 | E-06 | ○ |
| C-05 | CanLoadContentFieldsでContent-Typeを確認 | E-03 | ○ |
| C-06 | IsMultipartFormでmultipart/form-dataを判定 | E-05 | ○ |
| C-07 | IsFormURLEncodedでapplication/x-www-form-urlencodedを判定 | E-04 | ○ |
| C-08 | 対応していないContent-Typeは空のパラメータを返す | E-02 (180-181行目) | ○ |
| C-09 | Filesをループしてアップロードファイルを処理 | E-07 | ○ |
| C-10 | AddStreamでファイルストリームを格納 | E-07, E-10 | ○ |
| C-11 | ContentFieldsをループしてテキストフィールドを処理 | E-08 | ○ |
| C-12 | Delphiバージョンによりマルチパート解析方法が異なる | E-08 (188-206行目) | ○ |
| C-13 | 空キーはDictionaryに追加しない | E-09 | ○ |
| C-14 | AddOrSetValueで上書き動作 | E-09 | ○ |
| C-15 | ファイルはテキストフィールドより先に処理 | E-02 (183-186行目) | ○ |
| C-16 | Field(key).AsStreamでストリーム取得 | E-12 | ○ |
| C-17 | NewFieldでFFilesにキーがあればストリーム用Fieldを生成 | E-11 | ○ |
| C-18 | SaveToFileでファイル保存可能 | E-13 | ○ |
| C-19 | StrLICompで大文字小文字非区別の前方一致比較 | E-04, E-05 | ○ |
| C-20 | TMimeTypesで標準MIMEタイプを定義 | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての実装パスがソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] Content-Type判定のStrLIComp前方一致が正しく動作することを確認
- [ ] Delphiバージョン依存の分岐（CompilerVersion <= 31.0）が正しいか確認
- [ ] ファイルアップロードのストリーム処理が意図通りか確認
