---
generated_at: 2026-01-22 18:45:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-最大接続数設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Horse.Provider.Console.pas` 21行目（FMaxConnectionsクラス変数定義）
- E-02: `src/Horse.Provider.Console.pas` 52行目（MaxConnectionsプロパティ宣言）
- E-03: `src/Horse.Provider.Console.pas` 148-151行目（GetMaxConnections実装）
- E-04: `src/Horse.Provider.Console.pas` 314-317行目（SetMaxConnections実装）
- E-05: `src/Horse.Provider.Console.pas` 189-193行目（InternalListenでのMaxConnections適用）
- E-06: `src/Horse.Provider.VCL.pas` 53行目（VCL版MaxConnectionsプロパティ）
- E-07: `src/Horse.Provider.VCL.pas` 182-186行目（VCL版InternalListenでの適用）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` 30行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MaxConnectionsプロパティはTHorseProviderクラスに実装されている | E-02 | ○ |
| C-02 | FMaxConnectionsクラス変数に最大接続数が格納される | E-01, E-04 | ○ |
| C-03 | MaxConnectionsプロパティはread/writeの両方が定義されている | E-02 | ○ |
| C-04 | GetMaxConnectionsはFMaxConnectionsの値を返す | E-03 | ○ |
| C-05 | SetMaxConnectionsはFMaxConnectionsに値を代入する | E-04 | ○ |
| C-06 | FMaxConnections > 0の場合のみ設定が適用される | E-05 | ○ |
| C-07 | WebRequestHandler.MaxConnectionsに値が設定される | E-05 | ○ |
| C-08 | GetDefaultHTTPWebBroker.MaxConnectionsに値が設定される | E-05 | ○ |
| C-09 | VCLプロバイダーでもMaxConnectionsプロパティが実装されている | E-06 | ○ |
| C-10 | VCL版でもInternalListenで同様の適用が行われる | E-07 | ○ |
| C-11 | 機能一覧でTHorseProvider.MaxConnectionsとして定義されている | E-08 | ○ |
| C-12 | クラスプロパティとして実装されている（class property） | E-02 | ○ |
| C-13 | staticメソッドとしてGetter/Setterが実装されている | E-03, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に対してソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認できている

## 6) レビュアーチェックリスト（最小）
- [x] MaxConnectionsプロパティの存在と実装を確認
- [x] GetMaxConnections/SetMaxConnectionsの実装を確認
- [x] InternalListenでの条件付き適用を確認
- [x] WebRequestHandlerとHTTPWebBrokerの両方への設定を確認
- [x] Console版とVCL版での実装を確認
