---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-SSL/TLS設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **DEF_SSLVERSION, DEF_SSLVERSIONSの具体的な値**：定数定義の確認が必要
  2. **OpenSSLライブラリ要件**：実行環境依存の情報
  3. **証明書形式の詳細仕様**：外部仕様依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Provider.IOHandleSSL.Contract.pas` - IHorseProviderIOHandleSSLインターフェース定義
- E-02: `src/Horse.Provider.IOHandleSSL.pas` - THorseProviderIOHandleSSL実装
- E-03: `samples/delphi/vcl-ssl/src/Main.Form.pas` - SSL設定使用例
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseProviderIOHandleSSLクラスでSSL設定を管理 | E-02 (14-46行目) | ○ |
| C-02 | IHorseProviderIOHandleSSLインターフェースが定義されている | E-01 (13-33行目) | ○ |
| C-03 | KeyFileプロパティで秘密鍵ファイルパスを設定可能 | E-01 (21-22行目), E-02 (101-110行目) | ○ |
| C-04 | CertFileプロパティで公開鍵証明書パスを設定可能 | E-01 (17-18行目), E-02 (61-81行目) | ○ |
| C-05 | RootCertFileプロパティでルート証明書パスを設定可能 | E-01 (19-20行目), E-02 (139-148行目) | ○ |
| C-06 | DHParamsFileプロパティでDHパラメータファイルを設定可能 | E-01 (27-28行目), E-02 (90-99行目) | ○ |
| C-07 | CipherListプロパティで暗号スイートを設定可能 | E-01 (29-30行目), E-02 (67-76行目) | ○ |
| C-08 | Methodプロパティで単一SSLバージョンを設定可能 | E-01 (23-24行目), E-02 (112-121行目) | ○ |
| C-09 | SSLVersionsプロパティで複数SSLバージョンを設定可能 | E-01 (25-26行目), E-02 (150-159行目) | ○ |
| C-10 | OnGetPasswordプロパティでパスワードコールバックを設定可能 | E-01 (31-32行目), E-02 (128-137行目) | ○ |
| C-11 | Activeプロパティでssl有効/無効を制御可能 | E-01 (15-16行目), E-02 (50-59行目) | ○ |
| C-12 | コンストラクタでActive=True, Method=DEF_SSLVERSION等のデフォルト値設定 | E-02 (83-88行目) | ○ |
| C-13 | Newファクトリメソッドでインスタンス生成 | E-02 (123-126行目) | ○ |
| C-14 | フルーエントインターフェースパターンでメソッドチェーン可能 | E-02 (各メソッドでResult := Selfを返却) | ○ |
| C-15 | VCL-SSLサンプルでTHorse.IOHandleSSLが使用されている | E-03 (89-94行目) | ○ |
| C-16 | 画面機能マッピングでVCL-SSLメインフォームと本機能が関連付け | E-04 (10行目) | ○ |
| C-17 | 機能一覧でNo.31がSSL/TLS設定として定義 | E-05 (32行目) | ○ |
| C-18 | DEF_SSLVERSION, DEF_SSLVERSIONSの具体的な定数値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DEF_SSLVERSION, DEF_SSLVERSIONSの定数定義がIdSSLOpenSSL内で定義されており、Horseリポジトリ内では確認できない
  - 候補：IdSSLOpenSSL.pas / Indy公式ドキュメント / DEF_SSLVERSION = sslvTLSv1など

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義とクラス実装は完全に一致
- 0: 低リスク - サンプルコードで使用例が確認できる
- 1: 中リスク - OpenSSLライブラリのバージョン依存性については外部仕様参照が必要

## 6) レビュアーチェックリスト（最小）
- [ ] THorseProviderIOHandleSSLの各プロパティが正しく動作するか確認
- [ ] IdSSLOpenSSLのDEF_SSLVERSION, DEF_SSLVERSIONSの具体的値を確認
- [ ] OpenSSLライブラリの配置要件が実際の動作環境と一致するか確認
- [ ] VCL-SSLサンプルを実行してSSL通信が正常に行われることを確認
