---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-ルートグループ化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.Group.Contract.pas` - IHorseCoreGroup<T>インターフェース定義
- E-02: `src/Horse.Core.Group.pas` - THorseCoreGroup<T>実装
- E-03: `src/Horse.Core.Route.Contract.pas` - IHorseCoreRoute<T>インターフェース定義
- E-04: `src/Horse.Core.pas` - THorseCore コアクラス
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseCoreGroup<T>クラスでルートグループを管理 | E-02 (15-75行目) | ○ |
| C-02 | IHorseCoreGroup<T>インターフェースが定義されている | E-01 (15-70行目) | ○ |
| C-03 | Prefixメソッドで共通URLプレフィックスを設定可能 | E-01 (17行目), E-02 (219-223行目) | ○ |
| C-04 | コンストラクタでTHorseCore.GetInstanceをFHorseCoreに格納 | E-02 (214-217行目) | ○ |
| C-05 | NormalizePathでプレフィックス+パスを正規化 | E-02 (321-324行目) | ○ |
| C-06 | EndメソッドでFHorseCoreをT型にキャストして返却 | E-02 (88-91行目) | ○ |
| C-07 | Get/Post/Put等のHTTPメソッドでルート登録可能 | E-01 (31-68行目), E-02 (93-103行目等) | ○ |
| C-08 | Useメソッドでミドルウェア登録可能 | E-01 (21-24行目), E-02 (236-240行目) | ○ |
| C-09 | RouteメソッドでIHorseCoreRouteを取得可能 | E-01 (18行目), E-02 (225-228行目) | ○ |
| C-10 | AddCallback/AddCallbacksでコールバック追加可能 | E-01 (19-20行目), E-02 (173-186行目) | ○ |
| C-11 | フルーエントインターフェースでメソッドチェーン可能 | E-02 (各メソッドでResult := Selfを返却) | ○ |
| C-12 | THorseCore.GroupメソッドでグループインスタンスFを生成 | E-04 (200-203行目, 239-242行目) | ○ |
| C-13 | 各メソッドはTHorseCore(FHorseCore).XXXを呼び出す | E-02 (95-96行目等) | ○ |
| C-14 | Prefixの正規化は '/' + APrefix.Trim(['/']) | E-02 (222行目) | ○ |
| C-15 | ジェネリクス<T: class>で親クラス型を指定可能 | E-01 (15行目), E-02 (15行目) | ○ |
| C-16 | 機能一覧でNo.32がルートグループ化として定義 | E-05 (33行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対してソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義とクラス実装は完全に一致
- 0: 低リスク - ジェネリクスの型パラメータは正しく使用されている
- 0: 低リスク - フルーエントインターフェースパターンが一貫して実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] THorseCoreGroup<T>の各メソッドがインターフェース定義と一致しているか確認
- [ ] NormalizePathのロジックがパスを正しく正規化しているか確認
- [ ] Endメソッドが正しく親オブジェクトを返却しているか確認
- [ ] グループ内でのミドルウェア登録が期待通りに動作するか確認
