---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-パスパラメータ対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.RouterTree.pas` - THorseRouterTree実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseRouterTreeにFPartフィールドが存在 | E-01 (34行目) | ○ |
| C-02 | THorseRouterTreeにFTagフィールドが存在 | E-01 (35行目) | ○ |
| C-03 | THorseRouterTreeにFIsParamsKeyフィールドが存在 | E-01 (36行目) | ○ |
| C-04 | THorseRouterTreeにFRegexedKeysフィールドが存在 | E-01 (40行目) | ○ |
| C-05 | FIsParamsKey := FPart.StartsWith(':')でパスパラメータを検出 | E-01 (284行目) | ○ |
| C-06 | FTag := FPart.Substring(1, Length(FPart) - 1)でパラメータ名を抽出 | E-01 (285行目) | ○ |
| C-07 | パスパラメータルートはFRegexedKeysに追加される | E-01 (312-313行目) | ○ |
| C-08 | CallNextPathで完全一致チェック後、FRegexedKeysを探索 | E-01 (94行目, 102-113行目) | ○ |
| C-09 | HasNextでFIsParamsKeyを考慮したマッチングが行われる | E-01 (248行目) | ○ |
| C-10 | ExecuteInternalでSetTag(FTag)が呼び出される | E-01 (184行目) | ○ |
| C-11 | ExecuteInternalでSetIsParamsKey(FIsParamsKey)が呼び出される | E-01 (185行目) | ○ |
| C-12 | RegisterInternalでパスセグメントがDequeueされる | E-01 (282行目) | ○ |
| C-13 | FIsInitializedフラグで初回のみ初期化処理が行われる | E-01 (280-291行目) | ○ |
| C-14 | 機能一覧でNo.35がパスパラメータ対応として定義 | E-02 (36行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対してソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パスパラメータ検出ロジックは単純で明確
- 0: 低リスク - FRegexedKeysによるルート探索は一貫して実装されている
- 1: 中リスク - TNextCallerでのパラメータ値格納処理は別ファイルで確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] FPart.StartsWith(':')の判定が正しく動作するか確認
- [ ] FTag抽出のSubstring処理が正しいか確認
- [ ] FRegexedKeysの探索順序が期待通りか確認
- [ ] HasNextでのFIsParamsKeyによるマッチングが正しく動作するか確認
- [ ] TNextCallerでのパラメータ値格納処理を確認
