---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-正規表現ルーティング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.RouterTree.pas` - THorseRouterTree実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseRouterTreeにFRouterRegexフィールドが存在 | E-01 (37行目) | ○ |
| C-02 | THorseRouterTreeにFIsRouterRegexフィールドが存在 | E-01 (38行目) | ○ |
| C-03 | FIsRouterRegex := FPart.StartsWith('(') and FPart.EndsWith(')')で正規表現を検出 | E-01 (287行目) | ○ |
| C-04 | FRouterRegex := FPartで正規表現パターンを保存 | E-01 (288行目) | ○ |
| C-05 | 正規表現ルートはFRegexedKeysに追加される | E-01 (312-313行目) | ○ |
| C-06 | HasNextでFIsRouterRegexがTrueの場合にTRegEx.IsMatchが実行される | E-01 (251-256行目) | ○ |
| C-07 | マッチングパターンはFormat('^%s$', [FRouterRegex])形式 | E-01 (254行目) | ○ |
| C-08 | 正規表現マッチングは{$IFNDEF FPC}で囲まれている（Delphi専用） | E-01 (251行目) | ○ |
| C-09 | CallNextPathでFRegexedKeysが探索される | E-01 (102-113行目) | ○ |
| C-10 | FIsRouterRegexのデフォルト値はFalse | E-01 (126行目, Create内) | ○ |
| C-11 | FRegexedKeysはCreate時に初期化される | E-01 (123行目) | ○ |
| C-12 | 機能一覧でNo.36が正規表現ルーティングとして定義 | E-02 (37行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対してソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 正規表現検出ロジックは単純で明確
- 1: 中リスク - FPC環境では正規表現マッチングが直接サポートされていない（{$IFNDEF FPC}）
- 1: 中リスク - 複雑な正規表現パターンによるReDoS攻撃の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] FPart.StartsWith('(') and FPart.EndsWith(')')の判定が正しく動作するか確認
- [ ] FRouterRegexに保存されるパターンが正しいか確認
- [ ] TRegEx.IsMatchでの完全一致パターン生成が正しいか確認
- [ ] FPC環境での動作を確認（正規表現マッチングが使用されない場合の代替処理）
- [ ] 複雑な正規表現パターンに対するパフォーマンスを確認
