---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-フィールド型変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.Param.Field.pas` - THorseCoreParamField実装
- E-02: `src/Horse.Core.Param.pas` - THorseCoreParam実装
- E-03: `src/Horse.Core.Param.Config.pas` - THorseCoreParamConfig実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseCoreParamFieldクラスにFContainsフィールドが存在 | E-01 (25行目) | ○ |
| C-02 | THorseCoreParamFieldクラスにFRequiredフィールドが存在 | E-01 (27行目) | ○ |
| C-03 | THorseCoreParamFieldクラスにFDateFormatフィールドが存在 | E-01 (29行目) | ○ |
| C-04 | THorseCoreParamFieldクラスにFTrueValueフィールドが存在 | E-01 (32行目) | ○ |
| C-05 | THorseCoreParamFieldクラスにFValueフィールドが存在 | E-01 (33行目) | ○ |
| C-06 | Createコンストラクタでパラメータ辞書を検索（大文字小文字区別なし） | E-01 (322-329行目) | ○ |
| C-07 | AsStringメソッドでFContainsチェックとRequiredチェックを実行 | E-01 (277-284行目) | ○ |
| C-08 | AsIntegerメソッドでStrToIntを使用して変換 | E-01 (176-189行目) | ○ |
| C-09 | AsFloatメソッドで小数点セパレータを正規化してStrToFloat | E-01 (144-159行目, 153行目) | ○ |
| C-10 | AsBooleanメソッドでLowerCase比較によりFTrueValueと一致判定 | E-01 (88-96行目) | ○ |
| C-11 | AsDateメソッドでGetFormatSettingsを使用 | E-01 (103-119行目, 113行目) | ○ |
| C-12 | AsISO8601DateTimeメソッドでISO8601ToDate関数を使用 | E-01 (191-201行目, 199行目) | ○ |
| C-13 | AsListメソッドでSplit([','])によるカンマ区切り分割 | E-01 (203-220行目, 211行目) | ○ |
| C-14 | AsStreamメソッドでFStreamを返却 | E-01 (264-275行目) | ○ |
| C-15 | RequiredメソッドでFRequiredを設定 | E-01 (400-410行目) | ○ |
| C-16 | DateFormatメソッドでFDateFormatを設定 | E-01 (343-347行目) | ○ |
| C-17 | 変換失敗時にEHorseException（BadRequest）を発生 | E-01 (391-398行目) | ○ |
| C-18 | 機能一覧でNo.37がフィールド型変換として定義 | E-04 (38行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対してソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 各型変換メソッドは標準的な実装
- 0: 低リスク - エラー処理が一貫して実装されている
- 0: 低リスク - フルーエントインターフェースが一貫して使用されている

## 6) レビュアーチェックリスト（最小）
- [ ] AsIntegerの変換失敗時に正しいエラーメッセージが返されるか確認
- [ ] AsDateのDateFormat設定が正しく適用されるか確認
- [ ] AsBooleanのTrueValue設定が正しく適用されるか確認
- [ ] AsListのカンマ区切り処理が正しく動作するか確認
- [ ] Required設定時のエラーメッセージが適切か確認
