---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-必須パラメータ検証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.Param.pas` - THorseCoreParam実装
- E-02: `src/Horse.Core.Param.Field.pas` - THorseCoreParamField実装
- E-03: `src/Horse.Core.Param.Config.pas` - THorseCoreParamConfig実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseCoreParamにFRequiredフィールドが存在 | E-01 (31行目) | ○ |
| C-02 | THorseCoreParam.RequiredメソッドでFRequiredを設定 | E-01 (209-213行目) | ○ |
| C-03 | FieldメソッドでFRequiredが継承される | E-01 (113行目) | ○ |
| C-04 | THorseCoreParamFieldにFRequiredフィールドが存在 | E-02 (27行目) | ○ |
| C-05 | THorseCoreParamField.Required(AValue)メソッドが存在 | E-02 (400-404行目) | ○ |
| C-06 | THorseCoreParamField.Required()メソッド（引数なし）が存在 | E-02 (406-410行目) | ○ |
| C-07 | AsStringメソッドでFContainsとFRequiredのチェックが行われる | E-02 (277-284行目) | ○ |
| C-08 | FRequiredがTrueかつFContainsがFalseの場合にRaiseHorseExceptionが呼ばれる | E-02 (283行目) | ○ |
| C-09 | RequiredMessageメソッドでカスタムメッセージを設定可能 | E-02 (412-416行目) | ○ |
| C-10 | デフォルトのFRequiredMessageは "The %s param is required." | E-03 (55行目) | ○ |
| C-11 | Required()（引数なし）はFRequired := Trueを設定 | E-02 (409行目) | ○ |
| C-12 | 機能一覧でNo.38が必須パラメータ検証として定義 | E-04 (39行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対してソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Required設定と継承ロジックは明確
- 0: 低リスク - エラー処理が一貫して実装されている
- 0: 低リスク - デフォルトメッセージがグローバル設定から取得される

## 6) レビュアーチェックリスト（最小）
- [ ] THorseCoreParam.RequiredからFieldへの継承が正しく動作するか確認
- [ ] Required(True)とRequired()が同じ動作をするか確認
- [ ] AsString以外の型変換メソッドでも必須チェックが行われるか確認
- [ ] RequiredMessageのカスタマイズが正しく適用されるか確認
- [ ] エラーメッセージのフォーマット（%s置換）が正しいか確認
