---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-日付フォーマット設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.Param.Config.pas` - THorseCoreParamConfig実装
- E-02: `src/Horse.Core.Param.Field.pas` - THorseCoreParamField実装
- E-03: `src/Horse.Core.Param.pas` - THorseCoreParam実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseCoreParamConfigにFDateFormatフィールドが存在 | E-01 (15行目) | ○ |
| C-02 | FDateFormatのデフォルト値は'yyyy-MM-dd' | E-01 (52行目) | ○ |
| C-03 | THorseCoreParamConfig.DateFormat(AValue)セッターが存在 | E-01 (60-64行目) | ○ |
| C-04 | THorseCoreParamConfig.DateFormatゲッターが存在 | E-01 (66-69行目) | ○ |
| C-05 | THorseCoreParamFieldにFDateFormatフィールドが存在 | E-02 (29行目) | ○ |
| C-06 | THorseCoreParamField.DateFormatメソッドが存在 | E-02 (343-347行目) | ○ |
| C-07 | Field取得時にグローバス設定が継承される | E-03 (114行目) | ○ |
| C-08 | GetFormatSettingsでTFormatSettingsが生成される | E-02 (349-360行目) | ○ |
| C-09 | FDateFormatに'-'が含まれる場合DateSeparatorを'-'に設定 | E-02 (356-357行目) | ○ |
| C-10 | ShortDateFormatにFDateFormatを設定 | E-02 (358行目) | ○ |
| C-11 | AsDateでGetFormatSettingsが使用される | E-02 (113行目) | ○ |
| C-12 | AsDateでStrToDateにCopy(LStrParam, 1, Length(FDateFormat))を渡す | E-02 (114行目) | ○ |
| C-13 | 機能一覧でNo.39が日付フォーマット設定として定義 | E-04 (40行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対してソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - グローバル設定と継承ロジックは明確
- 0: 低リスク - フォーマット設定がパース処理で一貫して使用されている
- 1: 中リスク - DateSeparatorの自動検出が'-'のみ対応（'/'等は考慮されていない可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトの'yyyy-MM-dd'フォーマットが正しく動作するか確認
- [ ] グローバル設定からFieldへの継承が正しく動作するか確認
- [ ] フィールド単位でのオーバーライドが正しく動作するか確認
- [ ] DateSeparatorの自動検出（'-'以外のセパレータ）の動作を確認
- [ ] AsDateでのパース長制限（Copy）が期待通り動作するか確認
