---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-カスタム例外

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Exception.pas` - EHorseException クラス実装
- E-02: `src/Horse.Commons.pas` - THTTPStatus, TMessageType 定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EHorseException クラスが Exception を継承 | E-01 (21行目) | ○ |
| C-02 | FError, FStatus, FType, FTitle, FCode, FHint, FUnit, FDetail フィールドが存在 | E-01 (23-30行目) | ○ |
| C-03 | Create コンストラクタで FStatus := THTTPStatus.InternalServerError | E-01 (63-68行目, 66行目) | ○ |
| C-04 | Create コンストラクタで FCode := 0 | E-01 (63-68行目, 67行目) | ○ |
| C-05 | New クラスメソッドが EHorseException.Create を呼び出し | E-01 (70-73行目) | ○ |
| C-06 | Error(AValue) メソッドが FError と Self.Message を同時設定 | E-01 (124-129行目, 127行目) | ○ |
| C-07 | Status(AValue) メソッドが FStatus を設定しフルーエント返却 | E-01 (136-140行目) | ○ |
| C-08 | ToJSONObject で FType != Default の場合のみ type を出力 | E-01 (180-181行目) | ○ |
| C-09 | ToJSONObject で FTitle が空でない場合のみ title を出力 | E-01 (183-184行目) | ○ |
| C-10 | ToJSONObject で FCode != 0 の場合のみ code を出力 | E-01 (186-187行目) | ○ |
| C-11 | ToJSONObject で error は常に出力 | E-01 (189行目) | ○ |
| C-12 | ToJSONObject で FHint, FUnit, FDetail は空でない場合のみ出力 | E-01 (191-198行目) | ○ |
| C-13 | ToJSON メソッドが ToJSONObject を呼び出し文字列変換 | E-01 (164-174行目) | ○ |
| C-14 | THTTPStatus 列挙型に BadRequest=400, InternalServerError=500 等が定義 | E-02 (24-87行目, 46行目, 76行目) | ○ |
| C-15 | TMessageType 列挙型に Default, Error, Warning, Information が定義 | E-02 (108行目) | ○ |
| C-16 | 機能一覧で No.40 がカスタム例外として定義 | E-03 (41行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に対してソースコードからの根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - EHorseException クラス構造は明確
- 0: 低リスク - フルーエントインターフェースが一貫して実装されている
- 0: 低リスク - JSON出力の条件分岐が明確
- 1: 中リスク - Error 設定時の Self.Message 同期がドキュメント化されていない可能性

## 6) レビュアーチェックリスト（最小）
- [ ] EHorseException.New と EHorseException.Create が同じ動作をするか確認
- [ ] Error 設定時に Self.Message も正しく設定されるか確認
- [ ] ToJSONObject の条件付き出力が期待通り動作するか確認
- [ ] THTTPStatus.InternalServerError がデフォルトとして適切か確認
- [ ] JSON出力で error フィールドが必ず含まれるか確認
