---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：41-例外JSON変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Horse.Exception.pas` - 21-52行目（EHorseExceptionクラス宣言）
- E-02: `src/Horse.Exception.pas` - 63-68行目（コンストラクタ）
- E-03: `src/Horse.Exception.pas` - 164-174行目（ToJSONメソッド）
- E-04: `src/Horse.Exception.pas` - 176-199行目（ToJSONObjectメソッド）
- E-05: `src/Horse.Commons.pas` - 24-87行目（THTTPStatus列挙型）
- E-06: `src/Horse.Commons.pas` - 108行目（TMessageType列挙型）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 42行目（機能定義）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 35-43行目（関連画面）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EHorseExceptionクラスはExceptionを継承している | E-01 (21行目: `EHorseException = class(Exception)`) | ○ |
| C-02 | ToJSONメソッドはJSON文字列を返却する | E-03 (164行目: `function EHorseException.ToJSON: string`) | ○ |
| C-03 | ToJSONObjectメソッドはTJSONObjectを返却する | E-04 (176行目: `function EHorseException.ToJSONObject: TJsonObject`) | ○ |
| C-04 | FTypeフィールドはTMessageType型である | E-01 (25行目: `FType: TMessageType`) | ○ |
| C-05 | FStatusのデフォルト値はInternalServerError | E-02 (66行目: `FStatus := THTTPStatus.InternalServerError`) | ○ |
| C-06 | FCodeのデフォルト値は0 | E-02 (67行目: `FCode := 0`) | ○ |
| C-07 | type要素はDefaultでない場合のみ出力 | E-04 (180行目: `if FType <> TMessageType.Default then`) | ○ |
| C-08 | title要素は空でない場合のみ出力 | E-04 (183行目: `if not FTitle.Trim.IsEmpty then`) | ○ |
| C-09 | code要素は0でない場合のみ出力 | E-04 (186行目: `if FCode <> 0 then`) | ○ |
| C-10 | error要素は常に出力される | E-04 (189行目: 条件なしで`AddPair('error', FError)`) | ○ |
| C-11 | hint要素は空でない場合のみ出力 | E-04 (191行目: `if not FHint.Trim.IsEmpty then`) | ○ |
| C-12 | unit要素は空でない場合のみ出力 | E-04 (194行目: `if not FUnit.Trim.IsEmpty then`) | ○ |
| C-13 | detail要素は空でない場合のみ出力 | E-04 (197行目: `if not FDetail.Trim.IsEmpty then`) | ○ |
| C-14 | FPCではAsJSONメソッドを使用 | E-03 (170行目: `{$IF DEFINED(FPC)}LJSON.AsJSON`) | ○ |
| C-15 | Delphi 27.0以降ではToJSONメソッドを使用 | E-03 (170行目: `{$IF CompilerVersion > 27.0}LJSON.ToJSON`) | ○ |
| C-16 | FPCではAddメソッドを使用 | E-04 (181行目: `Result.{$IF DEFINED(FPC)}Add`) | ○ |
| C-17 | DelphiではAddPairメソッドを使用 | E-04 (181行目: `{$ELSE}AddPair{$ENDIF}`) | ○ |
| C-18 | ToJSONObject/ToJSONはvirtual宣言されている | E-01 (49-50行目: `function ToJSON: string; virtual;`) | ○ |

## 4) 不足情報（Unknown / Missing）

- 不足情報なし。すべての主張に対してソースコード根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [x] EHorseExceptionクラスの構造がドキュメント記載と一致するか確認
- [x] ToJSON/ToJSONObjectメソッドの処理フローが正確か確認
- [x] 条件付きフィールド出力のロジックが正しいか確認
- [x] FPC/Delphiのクロスプラットフォーム対応が正確に記載されているか確認
