---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-割り込み例外

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Horse.Exception.Interrupted.pas` - 17-20行目（クラス宣言）
- E-02: `src/Horse.Exception.Interrupted.pas` - 24-27行目（パラメータなしコンストラクタ）
- E-03: `src/Horse.Exception.Interrupted.pas` - 29-32行目（メッセージ付きコンストラクタ）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 43行目（機能定義）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 35-43行目（関連画面）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EHorseCallbackInterruptedクラスはExceptionを継承している | E-01 (17行目: `EHorseCallbackInterrupted = class(Exception)`) | ○ |
| C-02 | パラメータなしのコンストラクタが存在する | E-01 (18行目: `constructor Create; reintroduce; overload;`) | ○ |
| C-03 | メッセージ付きのコンストラクタが存在する | E-01 (19行目: `constructor Create(const AMessage: string); reintroduce; overload;`) | ○ |
| C-04 | パラメータなしコンストラクタは空文字で初期化する | E-02 (26行目: `inherited Create(EmptyStr)`) | ○ |
| C-05 | メッセージ付きコンストラクタはAMessageで初期化する | E-03 (31行目: `inherited Create(AMessage)`) | ○ |
| C-06 | FPC環境で動作する | E-01 (3-5行目: `{$IF DEFINED(FPC)} {$MODE DELPHI}{$H+} {$ENDIF}`) | ○ |
| C-07 | SysUtilsユニットを使用する | E-01 (10-14行目: uses句のFPC/Delphi分岐) | ○ |
| C-08 | Webモジュールで使用される | E-05 (35-43行目: 画面機能マッピング) | ○ |
| C-09 | コールバックチェーンを中断する目的で使用される | E-04 (43行目: "コールバックチェーンを中断する例外を発生させる") | ○ |
| C-10 | reintroduce修飾子でコンストラクタを再定義している | E-01 (18-19行目: `reintroduce`) | ○ |

## 4) 不足情報（Unknown / Missing）

- 不足情報なし。すべての主張に対してソースコード根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認可能
- WebModuleでの例外ハンドリング詳細はHorse.WebModule.pasを別途確認推奨

## 6) レビュアーチェックリスト（最小）

- [x] EHorseCallbackInterruptedクラスがExceptionを継承していることを確認
- [x] 2つのコンストラクタオーバーロードが存在することを確認
- [x] 空文字初期化の動作が正しいことを確認
- [x] FPC/Delphi両対応のコンパイラディレクティブが正しいことを確認
