---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-MIMEタイプ判定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Horse.Mime.pas` - 7-9行目（コンパイラディレクティブ）
- E-02: `src/Horse.Mime.pas` - 22-26行目（THorseMimeTypesクラス宣言）
- E-03: `src/Horse.Mime.pas` - 44-62行目（THorseMimeTypesExtクラス宣言）
- E-04: `src/Horse.Mime.pas` - 66-77行目（GetExtTypeメソッド実装）
- E-05: `src/Horse.Mime.pas` - 79-90行目（GetFileTypeメソッド実装）
- E-06: `src/Horse.Mime.pas` - 116-132行目（GetDefaultメソッド実装）
- E-07: `src/Horse.Mime.pas` - 134-139行目（NormalizeExtメソッド実装）
- E-08: `src/Horse.Mime.pas` - 141-148行目（THorseMimeTypesExt.GetExtType実装）
- E-09: `src/Horse.Mime.pas` - 155行目以降（InitializeFileType実装）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 46行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseMimeTypesクラスが存在する | E-02 (22行目: `THorseMimeTypes = class`) | ○ |
| C-02 | GetFileTypeはstaticメソッドである | E-02 (24行目: `class function GetFileType ... static`) | ○ |
| C-03 | GetExtTypeはstaticメソッドである | E-02 (25行目: `class function GetExtType ... static`) | ○ |
| C-04 | コンパイラバージョンで実装が分岐する | E-01 (7-9行目: `{$IF DEFINED(FPC) OR (CompilerVersion <= 32.0)}`) | ○ |
| C-05 | THorseMimeTypesExtはシングルトンである | E-06 (116-132行目: GetDefaultメソッドでシングルトン実装) | ○ |
| C-06 | TCriticalSectionで排他制御している | E-06 (120行目: `FLock.Enter`, 128行目: `FLock.Leave`) | ○ |
| C-07 | NormalizeExtは拡張子を小文字に変換する | E-07 (136行目: `AFileExt.Trim.ToLower`) | ○ |
| C-08 | NormalizeExtは先頭のドットを除去する | E-07 (137-138行目: ドット判定と除去) | ○ |
| C-09 | 不明な拡張子はapplication/octet-streamを返す | E-08 (147行目: `Result := 'application/octet-stream'`) | ○ |
| C-10 | TDictionaryを使用して拡張子-MIMEマッピングを保持 | E-03 (53行目: `FFileType: TDictionary<string, string>`) | ○ |
| C-11 | GetFileTypeは内部でGetExtTypeを呼び出す | E-05 (88行目: `Result := THorseMimeTypesExt.Default.GetFileType`) | ○ |
| C-12 | jsonはapplication/jsonに対応 | E-09 (191行目: `FFileType.AddOrSetValue('json', 'application/json')`) | ○ |
| C-13 | pdfはapplication/pdfに対応 | E-09 (243行目: `FFileType.AddOrSetValue('pdf', 'application/pdf')`) | ○ |
| C-14 | Delphi 32.0以降ではSystem.Net.Mimeを使用 | E-04 (72-73行目: `System.Net.Mime.TMimeTypes.Default.GetExtInfo`) | ○ |

## 4) 不足情報（Unknown / Missing）

- 不足情報なし。すべての主張に対してソースコード根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [x] THorseMimeTypes.GetFileType/GetExtTypeの実装が正しいか確認
- [x] コンパイラディレクティブによる分岐が正しく機能するか確認
- [x] シングルトンパターンの実装がスレッドセーフか確認
- [x] NormalizeExtの正規化ロジックが正しいか確認
- [x] デフォルトMIMEタイプの返却が正しいか確認
