---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-Consoleプロバイダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Horse.Provider.Console.pas` - 5行目（FPC条件コンパイル）
- E-02: `src/Horse.Provider.Console.pas` - 15-24行目（クラス変数宣言）
- E-03: `src/Horse.Provider.Console.pas` - 50-55行目（プロパティ宣言）
- E-04: `src/Horse.Provider.Console.pas` - 113-116行目（GetDefaultHostメソッド）
- E-05: `src/Horse.Provider.Console.pas` - 118-121行目（GetDefaultPortメソッド）
- E-06: `src/Horse.Provider.Console.pas` - 174-238行目（InternalListenメソッド）
- E-07: `src/Horse.Provider.Console.pas` - 240-253行目（InternalStopListenメソッド）
- E-08: `src/Horse.Provider.Console.pas` - 78-87行目（GetDefaultHTTPWebBrokerメソッド）
- E-09: `src/Horse.Provider.Console.pas` - 158-172行目（InitServerIOHandlerSSLOpenSSLメソッド）
- E-10: `src/Horse.Provider.Console.pas` - 331-332行目（initialization節）
- E-11: `src/Horse.Constants.pas` - 10-11行目（デフォルト定数）
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` - 51行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Delphi専用（FPCでは使用不可） | E-01 (5行目: `{$IF NOT DEFINED(FPC)}`) | ○ |
| C-02 | THorseProviderクラスが存在する | E-02 (15行目: `THorseProvider = class`) | ○ |
| C-03 | FPortクラス変数が存在する | E-02 (17行目: `class var FPort: Integer`) | ○ |
| C-04 | FHostクラス変数が存在する | E-02 (18行目: `class var FHost: string`) | ○ |
| C-05 | FIdHTTPWebBrokerBridgeクラス変数が存在する | E-02 (24行目: `class var FIdHTTPWebBrokerBridge: TIdHTTPWebBrokerBridge`) | ○ |
| C-06 | Hostプロパティが存在する | E-03 (50行目: `class property Host: string read GetHost write SetHost`) | ○ |
| C-07 | Portプロパティが存在する | E-03 (51行目: `class property Port: Integer read GetPort write SetPort`) | ○ |
| C-08 | デフォルトホストは'0.0.0.0' | E-04 (115行目: `Result := DEFAULT_HOST`) + E-11 | ○ |
| C-09 | デフォルトポートは9000 | E-05 (120行目: `Result := DEFAULT_PORT`) + E-11 | ○ |
| C-10 | InternalListenでサーバーを起動する | E-06 (212行目: `LIdHTTPWebBrokerBridge.Active := True`) | ○ |
| C-11 | コンソールアプリでイベントループを実行する | E-06 (217-220行目: `if IsConsole then while FRunning do GetDefaultEvent.WaitFor`) | ○ |
| C-12 | InternalStopListenでサーバーを停止する | E-07 (244-245行目: `GetDefaultHTTPWebBroker.StopListening; ...Active := False`) | ○ |
| C-13 | 未起動でStopListenすると例外発生 | E-07 (252行目: `raise Exception.Create('Horse not listen')`) | ○ |
| C-14 | TIdHTTPWebBrokerBridgeを遅延生成する | E-08 (80-86行目: `if HTTPWebBrokerIsNil then FIdHTTPWebBrokerBridge := ...`) | ○ |
| C-15 | SSL設定メソッドが存在する | E-09 (158行目: `class procedure THorseProvider.InitServerIOHandlerSSLOpenSSL`) | ○ |
| C-16 | KeepConnectionAliveデフォルトはTrue | E-10 (332行目: `THorseProvider.SetKeepConnectionAlive(True)`) | ○ |
| C-17 | MaxConnectionsプロパティが存在する | E-03 (52行目: `class property MaxConnections: Integer`) | ○ |
| C-18 | IOHandleSSLプロパティが存在する | E-03 (55行目: `class property IOHandleSSL: IHorseProviderIOHandleSSL`) | ○ |

## 4) 不足情報（Unknown / Missing）

- 不足情報なし。すべての主張に対してソースコード根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [x] THorseProviderクラスの構造がドキュメント記載と一致するか確認
- [x] プロパティ（Host、Port、MaxConnections等）が正しく定義されているか確認
- [x] デフォルト値（ポート9000、ホスト0.0.0.0）が正しいか確認
- [x] InternalListen/InternalStopListenの処理フローが正しいか確認
- [x] SSL設定機能が正しく実装されているか確認
- [x] FPC条件コンパイルによりDelphi専用であることを確認
