---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-Lazarus対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.pas` - メインユニット（117行）
- E-02: `src/Horse.Provider.FPC.LCL.pas` - LCLプロバイダー（300行）
- E-03: `src/Horse.Provider.FPC.Daemon.pas` - FPCデーモンプロバイダー（288行）
- E-04: `src/Horse.Provider.FPC.CGI.pas` - FPC CGIプロバイダー（92行）
- E-05: `src/Horse.Provider.FPC.Apache.pas` - FPC Apacheプロバイダー（132行）
- E-06: `src/Horse.WebModule.pas` - WebModule（118行）
- E-07: `samples/lazarus/lcl/src/views.main.pas` - LCLサンプル（73行）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FPC条件コンパイルでの環境検出 | E-01: 3行目 `{$IF DEFINED(FPC)}` | ○ |
| C-02 | {$MODE DELPHI}によるDelphi互換性確保 | E-01: 4行目, E-02: 4行目 | ○ |
| C-03 | FPC用プロバイダーユニット群 | E-01: 13-23行目 | ○ |
| C-04 | HORSE_LCLでLCLプロバイダー選択 | E-01: 97-98行目 | ○ |
| C-05 | HORSE_DAEMONでFPCデーモンプロバイダー選択 | E-01: 92-93行目 | ○ |
| C-06 | HORSE_CGIでFPC CGIプロバイダー選択 | E-01: 80-81行目 | ○ |
| C-07 | HORSE_APACHEでFPC Apacheプロバイダー選択 | E-01: 73-74行目 | ○ |
| C-08 | TFPHTTPServerの使用 | E-02: 15行目, 32行目, 224行目 | ○ |
| C-09 | THTTPServerThreadクラス定義 | E-02: 26-45行目 | ○ |
| C-10 | THorseCore.GetInstance取得 | E-02: 226行目 | ○ |
| C-11 | FServer.OnRequest設定 | E-02: 225行目 | ○ |
| C-12 | FServer.Threaded = True | E-02: 258行目 | ○ |
| C-13 | FPC版WebModuleでTFPWebModule継承 | E-06: 23行目 | ○ |
| C-14 | FPC版でRegisterHTTPModule呼び出し | E-06: 114行目 | ○ |
| C-15 | FPC版リソースファイル(.lfm) | E-06: 59行目 | ○ |
| C-16 | LCLメインフォームとの関連 | E-08: 画面No.4とのマッピング | ○ |
| C-17 | デーモンメインとの関連 | E-08: 画面No.5とのマッピング | ○ |
| C-18 | デーモンマネージャーとの関連 | E-08: 画面No.6とのマッピング | ○ |
| C-19 | LCLサンプルでTHorse.Listen使用 | E-07: 63行目 | ○ |
| C-20 | LCLサンプルでHORSE_LCLコメント | E-07: 62行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードの根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] FPC条件コンパイルの構造が正しく説明されているか
- [ ] {$MODE DELPHI}の目的が正しく理解されているか
- [ ] 各FPC版プロバイダーの選択条件が正確か
- [ ] TFPHTTPServerの使用方法が正しく記述されているか
