---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-ミドルウェア登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.pas` 73-76行目 - Use メソッドのオーバーロード宣言（4種類）
- E-02: `src/Horse.Core.pas` 393-397行目 - Use(ACallback) メソッド実装
- E-03: `src/Horse.Core.pas` 399-403行目 - Use(APath, ACallback) メソッド実装
- E-04: `src/Horse.Core.pas` 342-349行目 - Use(ACallbacks) メソッド実装（配列版）
- E-05: `src/Horse.Core.pas` 384-391行目 - Use(APath, ACallbacks) メソッド実装
- E-06: `src/Horse.Core.RouterTree.pas` 39行目 - FMiddleware: TList<THorseCallback> の定義
- E-07: `src/Horse.Core.RouterTree.pas` 317-320行目 - RegisterMiddleware(AMiddleware) メソッド
- E-08: `src/Horse.Core.RouterTree.pas` 322-332行目 - RegisterMiddleware(APath, AMiddleware) メソッド
- E-09: `src/Horse.Core.RouterTree.pas` 334-341行目 - RegisterMiddlewareInternal メソッド
- E-10: `src/Horse.Core.RouterTree.pas` 168-194行目 - ExecuteInternal メソッド
- E-11: `src/Horse.Core.RouterTree.pas` 183行目 - SetMiddleware(FMiddleware) 呼び出し
- E-12: `src/Horse.Callback.pas` 26-38行目 - コールバック型定義
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - ミドルウェア登録に直接関連する画面なし
- E-14: `docs/code-to-docs/機能一覧/機能一覧.csv` 9行目 - ミドルウェア登録の機能定義
- E-15: `src/Horse.Core.pas` 229-232行目 - TrimPath メソッド
- E-16: `src/Horse.Core.RouterTree.pas` 119-127行目 - コンストラクタでFMiddleware初期化

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseCore.Use メソッドでミドルウェアを登録する | E-01, E-02, E-14 | ○ |
| C-02 | Use メソッドには4種類のオーバーロードがある | E-01 | ○ |
| C-03 | パス指定なしの場合はルート'/'に登録される | E-02 | ○ |
| C-04 | TrimPathでパスを正規化する | E-15 | ○ |
| C-05 | THorseRouterTree.RegisterMiddlewareでミドルウェアを登録 | E-07, E-08 | ○ |
| C-06 | RegisterMiddlewareInternalで再帰的に登録 | E-09 | ○ |
| C-07 | FMiddlewareはTList<THorseCallback>型 | E-06 | ○ |
| C-08 | ミドルウェアはFMiddleware.Addで追加される | E-09 (338行目) | ○ |
| C-09 | ExecuteInternalでTNextCallerを使用してミドルウェアを実行 | E-10, E-11 | ○ |
| C-10 | コールバック型はHorse.Callback.pasで定義されている | E-12 | ○ |
| C-11 | 画面機能マッピングにミドルウェア登録関連画面は定義されていない | E-13 | ○ |
| C-12 | Useメソッドは全Delphiバージョン・FPC環境で利用可能 | E-01（条件コンパイルなし） | ○ |
| C-13 | 配列版Useはループで各コールバックを登録 | E-04, E-05 | ○ |
| C-14 | FMiddlewareはコンストラクタで初期化される | E-16 | ○ |
| C-15 | ForcePath で中間ノードを作成 | E-09 (340行目) | ○ |
| C-16 | GetQueuePathでパスをセグメント化 | E-08 (326行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード上の根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] Use メソッドのオーバーロード数が正しいか確認
- [x] パス指定なしの場合のデフォルトパス('/')が正確か確認
- [x] FMiddlewareの型（TList<THorseCallback>）が正確か確認
- [x] RegisterMiddlewareInternalの再帰処理が正確に記述されているか確認
- [x] 画面機能マッピングにミドルウェア登録関連画面がないことを確認
