---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-コールバック追加

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.pas` 67-68行目 - AddCallback/AddCallbacks メソッドの宣言
- E-02: `src/Horse.Core.pas` 143-149行目 - AddCallback メソッド実装
- E-03: `src/Horse.Core.pas` 151-158行目 - AddCallbacks メソッド実装
- E-04: `src/Horse.Core.pas` 176-184行目 - GetCallbacks メソッド実装
- E-05: `src/Horse.Core.pas` 186-193行目 - RegisterCallbacksRoute メソッド実装
- E-06: `src/Horse.Core.pas` 43行目 - FCallbacks: TList<THorseCallback> クラス変数宣言
- E-07: `src/Horse.Core.pas` 146-147行目 - FCallbacksの遅延初期化
- E-08: `src/Horse.Core.pas` 182行目 - FCallbacks.ToArray
- E-09: `src/Horse.Core.pas` 183行目 - FCallbacks.Clear
- E-10: `src/Horse.Callback.pas` 26-38行目 - コールバック型定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - コールバック追加に直接関連する画面なし
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` 10行目 - コールバック追加の機能定義
- E-13: `src/Horse.Core.pas` 300-304行目 - Get メソッドでRegisterCallbacksRouteを呼び出し
- E-14: `src/Horse.Core.pas` 265-267行目 - UnInitializeでFCallbacksを解放
- E-15: `src/Horse.Core.pas` 191行目 - for LCallback in GetCallbacks do RegisterRoute

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseCore.AddCallback/AddCallbacksでコールバックを蓄積する | E-01, E-02, E-12 | ○ |
| C-02 | FCallbacksはTList<THorseCallback>型のクラス変数 | E-06 | ○ |
| C-03 | FCallbacksは初回使用時に遅延初期化される | E-07 | ○ |
| C-04 | AddCallbacksは各コールバックに対してAddCallbackを呼び出す | E-03 | ○ |
| C-05 | GetCallbacksでFCallbacksの内容を取得しクリアする | E-04, E-08, E-09 | ○ |
| C-06 | RegisterCallbacksRouteで蓄積コールバックを登録 | E-05, E-15 | ○ |
| C-07 | Get/Post等のルート登録時にRegisterCallbacksRouteが呼び出される | E-13 | ○ |
| C-08 | 蓄積コールバックはメインコールバックより先に登録される | E-13（RegisterCallbacksRouteが先） | ○ |
| C-09 | コールバック型はHorse.Callback.pasで定義されている | E-10 | ○ |
| C-10 | 画面機能マッピングにコールバック追加関連画面は定義されていない | E-11 | ○ |
| C-11 | AddCallback/AddCallbacksは全バージョンで利用可能 | E-01（条件コンパイルなし） | ○ |
| C-12 | FCallbacksはUnInitializeで解放される | E-14 | ○ |
| C-13 | メソッドチェーンが可能（THorseCoreを返す） | E-02 (Result := GetInstance) | ○ |
| C-14 | GetCallbacks後にFCallbacks.Clearが呼ばれる | E-09 | ○ |
| C-15 | RegisterCallbacksRouteはGetCallbacksの結果をループ処理 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード上の根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] AddCallback/AddCallbacksメソッドの実装が正しいか確認
- [x] FCallbacksの遅延初期化が正確に記述されているか確認
- [x] GetCallbacksでのToArray/Clear処理が正確か確認
- [x] RegisterCallbacksRouteでのループ処理が正確か確認
- [x] 画面機能マッピングにコールバック追加関連画面がないことを確認
