---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があるため、特に優先レビューが必要な項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `samples/delphi/vcl/src/Main.Form.dfm` - Delphi VCLサンプルのフォーム定義ファイル
- E-02: `samples/delphi/vcl/src/Main.Form.pas` - Delphi VCLサンプルのPascalソースコード
- E-03: `samples/delphi/vcl-ssl/src/Main.Form.dfm` - Delphi VCL-SSLサンプルのフォーム定義ファイル
- E-04: `samples/delphi/vcl-ssl/src/Main.Form.pas` - Delphi VCL-SSLサンプルのPascalソースコード
- E-05: `samples/delphi/winsvc/src/Main.Service.dfm` - Delphi Windowsサービスの定義ファイル
- E-06: `samples/delphi/winsvc/src/Main.Service.pas` - Delphi Windowsサービスのソースコード
- E-07: `samples/lazarus/lcl/src/views.main.lfm` - Lazarus LCLサンプルのフォーム定義ファイル
- E-08: `samples/lazarus/lcl/src/views.main.pas` - Lazarus LCLサンプルのPascalソースコード
- E-09: `samples/lazarus/winsvc/daemonmain.lfm` - Lazarusデーモンメインの定義ファイル
- E-10: `samples/lazarus/winsvc/daemonmain.pas` - Lazarusデーモンメインのソースコード
- E-11: `samples/lazarus/winsvc/daemonmanager.lfm` - Lazarusデーモンマネージャーの定義ファイル
- E-12: `samples/lazarus/winsvc/daemonmanager.pas` - Lazarusデーモンマネージャーのソースコード
- E-13: `src/Horse.WebModule.dfm` - WebモジュールのDelphiフォーム定義ファイル
- E-14: `src/Horse.WebModule.lfm` - WebモジュールのLazarusフォーム定義ファイル
- E-15: `src/Horse.WebModule.pas` - Webモジュールのソースコード
- E-16: `README.md` - プロジェクトの概要説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VCLメインフォームはサーバーの起動・停止を制御する | E-01, E-02 | ○ |
| C-02 | VCL-SSLメインフォームはSSL対応サーバーを制御する | E-03, E-04 | ○ |
| C-03 | WindowsサービスメインはTServiceを継承している | E-05, E-06 | ○ |
| C-04 | LCLメインフォームはVCLサンプルのLazarus版である | E-07, E-08 | ○ |
| C-05 | デーモンメインはTDaemonを継承している | E-09, E-10 | ○ |
| C-06 | デーモンマネージャーはサービス設定を管理する | E-11, E-12 | ○ |
| C-07 | WebモジュールはHTTPリクエストを処理する | E-13, E-14, E-15 | ○ |
| C-08 | HorseはExpress風のWebフレームワークである | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特に不足情報はありません
- 全ての画面定義ファイル（.dfm、.lfm）と対応するソースコード（.pas）を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧に記載された8つの画面がプロジェクトに存在することを確認
- [ ] 画面遷移図のmermaid記法が正しく表示されることを確認
- [ ] VCLとLCLの画面が同等の機能を持つことを確認
- [ ] Windowsサービス関連の画面定義が正確であることを確認
