# 画面遷移図

## 概要

Horseは、Delphi/Lazarus用のExpressインスパイアードWebフレームワークです。このプロジェクトには、フレームワークの使用方法を示すサンプルアプリケーションが含まれています。

画面遷移は主に以下のパターンで構成されています：
1. **GUIアプリケーション（VCL/LCL）**: ユーザーがボタン操作でサーバーの起動・停止を制御
2. **サービスアプリケーション**: OSによる自動制御

## Delphi VCLサンプル 画面遷移

```mermaid
stateDiagram-v2
    [*] --> VCLメインフォーム: アプリケーション起動

    state VCLメインフォーム {
        [*] --> 停止状態
        停止状態 --> 起動状態: Startボタンクリック
        起動状態 --> 停止状態: Stopボタンクリック
        起動状態 --> 停止状態: フォームクローズ
    }

    VCLメインフォーム --> [*]: アプリケーション終了
```

## Delphi VCL-SSL サンプル 画面遷移

```mermaid
stateDiagram-v2
    [*] --> VCL_SSLメインフォーム: アプリケーション起動

    state VCL_SSLメインフォーム {
        [*] --> 設定入力
        設定入力 --> 秘密鍵選択: "..."ボタンクリック
        設定入力 --> 公開鍵選択: "..."ボタンクリック
        秘密鍵選択 --> 設定入力: ファイル選択完了
        公開鍵選択 --> 設定入力: ファイル選択完了
        設定入力 --> サーバー起動: Startボタンクリック
    }

    VCL_SSLメインフォーム --> [*]: アプリケーション終了
```

## Lazarus LCLサンプル 画面遷移

```mermaid
stateDiagram-v2
    [*] --> LCLメインフォーム: アプリケーション起動

    state LCLメインフォーム {
        [*] --> 停止状態
        停止状態 --> 起動状態: Startボタンクリック
        起動状態 --> 停止状態: Stopボタンクリック
    }

    LCLメインフォーム --> [*]: アプリケーション終了
```

## Windowsサービス ライフサイクル

```mermaid
stateDiagram-v2
    [*] --> サービス停止
    サービス停止 --> サービス起動中: ServiceStart
    サービス起動中 --> Horseサーバー稼働: THorse.Listen
    Horseサーバー稼働 --> サービス停止中: ServiceStop
    サービス停止中 --> サービス停止: THorse.StopListen
    サービス停止 --> [*]: サービス削除
```

## 全体アーキテクチャ

```mermaid
flowchart TB
    subgraph サンプルアプリケーション
        subgraph Delphi
            VCL[VCLメインフォーム<br/>Main.Form.dfm]
            VCLSSL[VCL-SSLメインフォーム<br/>Main.Form.dfm]
            WinSvc[Windowsサービス<br/>Main.Service.dfm]
        end
        subgraph Lazarus
            LCL[LCLメインフォーム<br/>views.main.lfm]
            LazSvc[デーモンメイン<br/>daemonmain.lfm]
            LazMgr[デーモンマネージャー<br/>daemonmanager.lfm]
        end
    end

    subgraph フレームワークコア
        WebMod[Webモジュール<br/>Horse.WebModule]
        Core[THorseCore]
        Routes[ルーティング]
    end

    VCL --> Core
    VCLSSL --> Core
    WinSvc --> Core
    LCL --> Core
    LazSvc --> Core
    LazMgr --> LazSvc

    Core --> Routes
    WebMod --> Core
```

## 画面コンポーネント詳細

### VCLメインフォーム（Main.Form.dfm）

| コンポーネント | 種類 | 機能 |
|--------------|------|------|
| edtPort | TEdit | ポート番号入力（デフォルト: 9000） |
| btnStart | TBitBtn | サーバー起動 |
| btnStop | TBitBtn | サーバー停止 |
| Label1 | TLabel | "Port:"ラベル |

### VCL-SSLメインフォーム（Main.Form.dfm）

| コンポーネント | 種類 | 機能 |
|--------------|------|------|
| edtPort | TSpinEdit | ポート番号入力（デフォルト: 9000） |
| leKey | TLabeledEdit | 秘密鍵ファイルパス表示 |
| leCrt | TLabeledEdit | 公開鍵ファイルパス表示 |
| lePassword | TLabeledEdit | パスワード入力 |
| Button1 | TButton | サーバー起動（Start） |
| Button2 | TButton | 秘密鍵ファイル選択ダイアログ |
| Button3 | TButton | 公開鍵ファイル選択ダイアログ |
| OpenDialog1 | TOpenDialog | ファイル選択ダイアログ |
| StatusBar1 | TStatusBar | サーバー状態表示 |

### LCLメインフォーム（views.main.lfm）

| コンポーネント | 種類 | 機能 |
|--------------|------|------|
| edtPort | TEdit | ポート番号入力（デフォルト: 9000） |
| btnStart | TBitBtn | サーバー起動 |
| btnStop | TBitBtn | サーバー停止 |
| Label1 | TLabel | "Port:"ラベル |
