---
generated_at: 2026-01-22 00:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 42
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：42 / 42、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `samples/delphi/vcl/src/Main.Form.dfm`
- E-04: `samples/delphi/vcl/src/Main.Form.pas`
- E-05: `samples/delphi/vcl-ssl/src/Main.Form.dfm`
- E-06: `samples/delphi/vcl-ssl/src/Main.Form.pas`
- E-07: `samples/delphi/winsvc/src/Main.Service.dfm`
- E-08: `samples/delphi/winsvc/src/Main.Service.pas`
- E-09: `samples/lazarus/lcl/src/views.main.lfm`
- E-10: `samples/lazarus/lcl/src/views.main.pas`
- E-11: `samples/lazarus/winsvc/daemonmain.lfm`
- E-12: `samples/lazarus/winsvc/daemonmain.pas`
- E-13: `samples/lazarus/winsvc/daemonmanager.lfm`
- E-14: `samples/lazarus/winsvc/daemonmanager.pas`
- E-15: `src/Horse.WebModule.dfm`
- E-16: `src/Horse.WebModule.pas`
- E-17: `src/Horse.WebModule.lfm`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面1（VCLメインフォーム）とサーバー起動（機能26）の関連 | E-01, E-02, E-04 | ○ |
| C-02 | 画面1（VCLメインフォーム）とサーバー停止（機能27）の関連 | E-01, E-02, E-04 | ○ |
| C-03 | 画面1（VCLメインフォーム）とポート設定（機能28）の関連 | E-01, E-02, E-03, E-04 | ○ |
| C-04 | 画面1（VCLメインフォーム）とGETリクエスト処理（機能1）の関連 | E-01, E-02, E-04 | ○ |
| C-05 | 画面1（VCLメインフォーム）とテキストレスポンス送信（機能17）の関連 | E-01, E-02, E-04 | ○ |
| C-06 | 画面1（VCLメインフォーム）とVCLプロバイダー（機能51）の関連 | E-01, E-02, E-04 | ○ |
| C-07 | 画面2（VCL-SSLメインフォーム）とサーバー起動（機能26）の関連 | E-01, E-02, E-06 | ○ |
| C-08 | 画面2（VCL-SSLメインフォーム）とポート設定（機能28）の関連 | E-01, E-02, E-05, E-06 | ○ |
| C-09 | 画面2（VCL-SSLメインフォーム）とSSL/TLS設定（機能31）の関連 | E-01, E-02, E-06 | ○ |
| C-10 | 画面2（VCL-SSLメインフォーム）とGETリクエスト処理（機能1）の関連 | E-01, E-02, E-06 | ○ |
| C-11 | 画面2（VCL-SSLメインフォーム）とテキストレスポンス送信（機能17）の関連 | E-01, E-02, E-06 | ○ |
| C-12 | 画面2（VCL-SSLメインフォーム）とVCLプロバイダー（機能51）の関連 | E-01, E-02, E-06 | ○ |
| C-13 | 画面3（Windowsサービスメイン）とサーバー起動（機能26）の関連 | E-01, E-02, E-08 | ○ |
| C-14 | 画面3（Windowsサービスメイン）とサーバー停止（機能27）の関連 | E-01, E-02, E-08 | ○ |
| C-15 | 画面3（Windowsサービスメイン）とGETリクエスト処理（機能1）の関連 | E-01, E-02, E-08 | ○ |
| C-16 | 画面3（Windowsサービスメイン）とテキストレスポンス送信（機能17）の関連 | E-01, E-02, E-08 | ○ |
| C-17 | 画面4（LCLメインフォーム）とサーバー起動（機能26）の関連 | E-01, E-02, E-10 | ○ |
| C-18 | 画面4（LCLメインフォーム）とサーバー停止（機能27）の関連 | E-01, E-02, E-10 | ○ |
| C-19 | 画面4（LCLメインフォーム）とポート設定（機能28）の関連 | E-01, E-02, E-09, E-10 | ○ |
| C-20 | 画面4（LCLメインフォーム）とGETリクエスト処理（機能1）の関連 | E-01, E-02, E-10 | ○ |
| C-21 | 画面4（LCLメインフォーム）とテキストレスポンス送信（機能17）の関連 | E-01, E-02, E-10 | ○ |
| C-22 | 画面4（LCLメインフォーム）とLazarus対応（機能56）の関連 | E-01, E-02, E-10 | ○ |
| C-23 | 画面5（デーモンメイン）とサーバー起動（機能26）の関連 | E-01, E-02, E-12 | ○ |
| C-24 | 画面5（デーモンメイン）とサーバー停止（機能27）の関連 | E-01, E-02, E-12 | ○ |
| C-25 | 画面5（デーモンメイン）とポート設定（機能28）の関連 | E-01, E-02, E-12 | ○ |
| C-26 | 画面5（デーモンメイン）とGETリクエスト処理（機能1）の関連 | E-01, E-02, E-12 | ○ |
| C-27 | 画面5（デーモンメイン）とテキストレスポンス送信（機能17）の関連 | E-01, E-02, E-12 | ○ |
| C-28 | 画面5（デーモンメイン）とDaemonプロバイダー（機能55）の関連 | E-01, E-02, E-12 | ○ |
| C-29 | 画面5（デーモンメイン）とLazarus対応（機能56）の関連 | E-01, E-02, E-12 | ○ |
| C-30 | 画面6（デーモンマネージャー）とDaemonプロバイダー（機能55）の関連 | E-01, E-02, E-13, E-14 | ○ |
| C-31 | 画面6（デーモンマネージャー）とLazarus対応（機能56）の関連 | E-01, E-02, E-14 | ○ |
| C-32 | 画面7（Webモジュール）とリクエストボディ取得（機能10）の関連 | E-01, E-02, E-16 | ○ |
| C-33 | 画面7（Webモジュール）とテキストレスポンス送信（機能17）の関連 | E-01, E-02, E-16 | ○ |
| C-34 | 画面7（Webモジュール）と割り込み例外（機能42）の関連 | E-01, E-02, E-16 | ○ |
| C-35 | 画面7（Webモジュール）とCGIプロバイダー（機能52）の関連 | E-01, E-02, E-16 | ○ |
| C-36 | 画面7（Webモジュール）とISAPIプロバイダー（機能53）の関連 | E-01, E-02, E-16 | ○ |
| C-37 | 画面7（Webモジュール）とApacheプロバイダー（機能54）の関連 | E-01, E-02, E-16 | ○ |
| C-38 | 画面8（Webモジュール Lazarus版）とリクエストボディ取得（機能10）の関連 | E-01, E-02, E-16 | ○ |
| C-39 | 画面8（Webモジュール Lazarus版）とテキストレスポンス送信（機能17）の関連 | E-01, E-02, E-16 | ○ |
| C-40 | 画面8（Webモジュール Lazarus版）と割り込み例外（機能42）の関連 | E-01, E-02, E-16 | ○ |
| C-41 | 画面8（Webモジュール Lazarus版）とCGIプロバイダー（機能52）の関連 | E-01, E-02, E-16 | ○ |
| C-42 | 画面8（Webモジュール Lazarus版）とLazarus対応（機能56）の関連 | E-01, E-02, E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての画面機能マッピングはソースコード解析により根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧.csvの全画面（8件）がマッピングされているか確認
- [ ] 機能一覧.csvの機能との紐付けが正確か確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
- [ ] 「関連する操作・処理」の説明がソースコードの実装と一致しているか確認
