# 画面設計書 1-VCLメインフォーム

## 概要

本ドキュメントは、Horseフレームワークを使用したDelphiVCLサンプルアプリケーションのメインフォーム（VCLメインフォーム）について、その機能、コンポーネント構成、処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

VCLメインフォームは、HorseフレームワークベースのHTTPサーバーをGUIから制御するためのWindows VCLアプリケーション画面である。ユーザーはこの画面を通じて、ポート番号の指定、サーバーの起動・停止を行うことができる。

**業務上の目的・背景**：Horseフレームワークを使用したWebサーバーアプリケーションを開発する際、開発者がGUIから簡単にサーバーの起動・停止を制御できるようにするためのサンプル画面である。コマンドラインではなくビジュアルな操作でサーバー管理を行いたい場合に使用する。また、Horseフレームワークの基本的な使用方法を学ぶための教材としても機能する。

**画面へのアクセス方法**：コンパイル済みの実行ファイル（SamplesVCL.exe）を起動すると、本画面が自動的に表示される。アプリケーション起動時にFormCreate処理が実行され、/pingエンドポイントのルーティングが登録される。

**主要な操作・処理内容**：
1. ポート番号入力（edtPort）：サーバーがリッスンするポート番号を入力する（デフォルト: 9000）
2. Startボタン押下（btnStart）：THorse.Listenを呼び出し、指定ポートでHTTPサーバーを起動する
3. Stopボタン押下（btnStop）：THorse.StopListenを呼び出し、実行中のHTTPサーバーを停止する
4. フォームクローズ時：サーバーが実行中の場合は自動的に停止処理を行う

**画面遷移**：本画面は単一画面のアプリケーションであり、他の画面への遷移はない。アプリケーション起動時に表示され、終了時にクローズされる。サーバー状態（起動/停止）に応じてボタンの有効/無効状態が変化する。

**権限による表示制御**：本サンプルアプリケーションには権限管理機能は実装されていない。すべての機能が制限なく使用可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | サーバー起動 | 主機能 | Startボタン押下時にTHorse.Listenを呼び出してHTTPサーバーを起動 |
| 27 | サーバー停止 | 主機能 | Stopボタン押下時にTHorse.StopListenを呼び出してHTTPサーバーを停止 |
| 28 | ポート設定 | 補助機能 | edtPortテキストボックスで入力されたポート番号をサーバー起動時に使用 |
| 1 | GET リクエスト処理 | 補助機能 | FormCreate時に/pingエンドポイントをGETルートとして登録 |
| 17 | テキストレスポンス送信 | 補助機能 | /pingエンドポイントでRes.Send('pong')によりテキストレスポンスを返却 |
| 51 | VCL プロバイダー | 補助機能 | HORSE_VCLコンパイルディレクティブによりVCLプロバイダーを使用 |

## 画面種別

制御画面（サーバー管理コンソール）

## URL/ルーティング

- アプリケーションURL: なし（デスクトップアプリケーション）
- 登録エンドポイント: `GET /ping` -> レスポンス: `pong`

## 入出力項目

| 項目名 | コンポーネント名 | 種類 | I/O | データ型 | 必須 | 初期値 | 説明 |
|--------|-----------------|------|-----|----------|------|--------|------|
| ポート番号 | edtPort | TEdit | 入力 | Integer | はい | 9000 | サーバーがリッスンするポート番号（数値のみ入力可） |

## 表示項目

| 項目名 | コンポーネント名 | 種類 | 表示内容 |
|--------|-----------------|------|----------|
| ポートラベル | Label1 | TLabel | "Port:" |
| スタートボタン | btnStart | TBitBtn | "Start" - サーバー停止中は有効、実行中は無効 |
| ストップボタン | btnStop | TBitBtn | "Stop" - サーバー実行中は有効、停止中は無効 |

## イベント仕様

### 1-FormCreate（フォーム作成イベント）

**トリガー**: アプリケーション起動時、フォームが作成される際に自動実行

**処理内容**:
1. THorse.Getメソッドを呼び出し
2. パス'ping'に対するGETリクエストハンドラを登録
3. ハンドラは匿名プロシージャで、Res.Send('pong')を実行

**コード参照**: `Main.Form.pas` 39-46行目

### 2-btnStartClick（Startボタン押下イベント）

**トリガー**: ユーザーがStartボタンをクリック

**処理内容**:
1. Startプロシージャを呼び出し
2. THorse.Listen(StrToInt(edtPort.Text))でサーバーを起動
3. Statusプロシージャを呼び出し
4. ボタンとテキストボックスの有効/無効状態を更新

**コード参照**: `Main.Form.pas` 66-70行目

### 3-btnStopClick（Stopボタン押下イベント）

**トリガー**: ユーザーがStopボタンをクリック

**処理内容**:
1. Stopプロシージャを呼び出し
2. THorse.StopListenでサーバーを停止
3. Statusプロシージャを呼び出し
4. ボタンとテキストボックスの有効/無効状態を更新

**コード参照**: `Main.Form.pas` 72-76行目

### 4-FormClose（フォーム終了イベント）

**トリガー**: ユーザーがフォームを閉じる操作を行った時

**処理内容**:
1. THorse.IsRunningでサーバー実行状態を確認
2. 実行中の場合、Stopプロシージャを呼び出してサーバーを停止

**コード参照**: `Main.Form.pas` 33-37行目

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面ではデータベースアクセスは行わない |

### テーブル別更新項目詳細

本画面ではデータベースを使用しない。

## メッセージ仕様

| 種別 | メッセージ内容 | 表示条件 |
|------|--------------|----------|
| レスポンス | "pong" | /pingエンドポイントにGETリクエストが送信された場合 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|---------|---------|
| ポート番号変換エラー | edtPortに数値以外が入力されている場合 | StrToIntで例外が発生（ただしNumbersOnly=Trueにより通常発生しない） |
| ポート使用中エラー | 指定ポートが既に使用されている場合 | THorse.Listenで例外が発生 |

## 備考

- HORSE_VCLコンパイルディレクティブを設定する必要がある
- VCLプロバイダーはWindows専用であり、GUIスレッドでの動作をサポートする
- ウィンドウは固定サイズ（ClientWidth=201, ClientHeight=82）で、最大化・最小化ボタンは無効化されている
- 画面中央（poScreenCenter）に配置される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Horseフレームワークのリクエストとレスポンスのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequestクラスの構造、リクエストデータの取得方法 |
| 1-2 | Horse.Response.pas | `src/Horse.Response.pas` | THorseResponseクラスの構造、Sendメソッドの実装 |

**読解のコツ**: DelphiのクラスはTPascal形式で、TプレフィックスがついたクラスがDelphiの標準命名規則。

#### Step 2: エントリーポイントを理解する

処理の起点となるフォームファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Main.Form.dfm | `samples/delphi/vcl/src/Main.Form.dfm` | フォームのビジュアルレイアウト定義、コンポーネント配置 |
| 2-2 | Main.Form.pas | `samples/delphi/vcl/src/Main.Form.pas` | フォームクラスの実装、イベントハンドラ |

**主要処理フロー**:
1. **39-46行目**: FormCreate - /pingエンドポイントの登録
2. **48-52行目**: Start - THorse.Listenでサーバー起動
3. **54-59行目**: Status - UI状態の更新
4. **61-64行目**: Stop - THorse.StopListenでサーバー停止
5. **66-70行目**: btnStartClick - 起動ボタンイベント
6. **72-76行目**: btnStopClick - 停止ボタンイベント
7. **33-37行目**: FormClose - フォーム終了時の後処理

#### Step 3: Horseフレームワークコアを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.pas | `src/Horse.pas` | THorseクラスの定義、Listen/StopListenメソッド |
| 3-2 | Horse.Core.pas | `src/Horse.Core.pas` | THorseCoreの実装、ルーティング登録 |
| 3-3 | Horse.Provider.VCL.pas | `src/Horse.Provider.VCL.pas` | VCLプロバイダーの実装 |

**主要処理フロー**:
- **THorse.Listen**: VCLプロバイダーを使用してHTTPサーバーを起動
- **THorse.Get**: ルーティングテーブルにGETメソッドハンドラを登録

### プログラム呼び出し階層図

```
SamplesVCL.exe
    |
    +-- TFrmVCL (Main.Form.pas)
           |
           +-- FormCreate
           |      +-- THorse.Get('/ping', callback)
           |             +-- THorseCore.Get
           |                    +-- Routes.Add
           |
           +-- btnStartClick
           |      +-- Start
           |      |      +-- THorse.Listen(port)
           |      |             +-- THorseProvider<VCL>.Listen
           |      +-- Status
           |             +-- THorse.IsRunning
           |
           +-- btnStopClick
           |      +-- Stop
           |      |      +-- THorse.StopListen
           |      |             +-- THorseProvider<VCL>.StopListen
           |      +-- Status
           |
           +-- FormClose
                  +-- THorse.IsRunning
                  +-- Stop (if running)
```

### データフロー図

```
[入力]                    [処理]                          [出力]

edtPort.Text --------> StrToInt変換 -----------------> THorse.Listenへ
     (9000)                                           (ポート番号)

HTTP GET /ping ------> THorse.Routes.Execute --------> Res.Send('pong')
                              |                              |
                       THorseRequest                   THorseResponse
                       (リクエスト解析)                (レスポンス生成)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Main.Form.pas | `samples/delphi/vcl/src/Main.Form.pas` | ソース | メインフォームの実装コード |
| Main.Form.dfm | `samples/delphi/vcl/src/Main.Form.dfm` | 設定 | フォームのビジュアルレイアウト定義 |
| SamplesVCL.dpr | `samples/delphi/vcl/SamplesVCL.dpr` | ソース | プロジェクトファイル（エントリーポイント） |
| Horse.pas | `src/Horse.pas` | ソース | Horseフレームワークのメインユニット |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | THorseCoreクラスの実装 |
| Horse.Provider.VCL.pas | `src/Horse.Provider.VCL.pas` | ソース | VCLプロバイダーの実装 |
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | HTTPリクエストクラス |
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | HTTPレスポンスクラス |
