# 画面設計書 2-VCL-SSLメインフォーム

## 概要

本ドキュメントは、Horseフレームワークを使用したSSL対応のDelphi VCLサンプルアプリケーションのメインフォーム（VCL-SSLメインフォーム）について、その機能、コンポーネント構成、処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

VCL-SSLメインフォームは、SSL/TLS対応のHTTPSサーバーをGUIから制御するためのWindows VCLアプリケーション画面である。ユーザーはこの画面を通じて、ポート番号の指定、SSL証明書（秘密鍵・公開鍵）の設定、パスワードの入力、およびHTTPSサーバーの起動を行うことができる。

**業務上の目的・背景**：開発環境やテスト環境において、SSL/TLS暗号化通信を行うWebサーバーを簡単に起動・設定できるようにするためのサンプル画面である。HTTPS通信のテストや、SSL証明書の動作確認を行いたい場合に使用する。自己署名証明書を使用したテストシナリオに特に有効である。本番環境ではLet's Encryptなどの正規証明書の使用が推奨される。

**画面へのアクセス方法**：コンパイル済みの実行ファイル（SamplesVCLSSL.exe）を起動すると、本画面が自動的に表示される。アプリケーション起動時にFormCreate処理が実行され、/pingエンドポイントのルーティングが登録される。SSL関連のDLLファイル（libeay32.dll、ssleay32.dll）が実行ファイルと同じフォルダに必要である。

**主要な操作・処理内容**：
1. ポート番号入力（edtPort）：サーバーがリッスンするポート番号を入力する（デフォルト: 9000、範囲: 1000-9999999）
2. 秘密鍵ファイル選択（Button2 + leKey）：「...」ボタンでファイル選択ダイアログを開き、.keyファイルを選択
3. 公開鍵ファイル選択（Button3 + leCrt）：「...」ボタンでファイル選択ダイアログを開き、.crtファイルを選択
4. パスワード入力（lePassword）：秘密鍵のパスワードを入力（パスワードマスク表示）
5. Startボタン押下（Button1）：SSL設定を適用し、THorse.Listenを呼び出してHTTPSサーバーを起動

**画面遷移**：本画面は単一画面のアプリケーションであり、他の画面への遷移はない。ファイル選択ダイアログ（TOpenDialog）がモーダルで表示される。サーバー起動後、StatusBar1に起動状態が表示される。

**権限による表示制御**：本サンプルアプリケーションには権限管理機能は実装されていない。すべての機能が制限なく使用可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | サーバー起動 | 主機能 | Startボタン押下時にTHorse.Listenを呼び出してHTTPSサーバーを起動 |
| 28 | ポート設定 | 補助機能 | edtPortスピンエディットで入力されたポート番号をサーバー起動時に使用 |
| 31 | SSL/TLS設定 | 主機能 | THorse.IOHandleSSLで秘密鍵・公開鍵・パスワード・SSLバージョンを設定 |
| 1 | GET リクエスト処理 | 補助機能 | FormCreate時に/pingエンドポイントをGETルートとして登録 |
| 17 | テキストレスポンス送信 | 補助機能 | /pingエンドポイントでRes.Send('securite pong')によりテキストレスポンスを返却 |
| 51 | VCL プロバイダー | 補助機能 | HORSE_VCLコンパイルディレクティブによりVCLプロバイダーを使用 |

## 画面種別

制御画面（SSL対応サーバー管理コンソール）

## URL/ルーティング

- アプリケーションURL: なし（デスクトップアプリケーション）
- 登録エンドポイント: `GET /ping` -> レスポンス: `securite pong`

## 入出力項目

| 項目名 | コンポーネント名 | 種類 | I/O | データ型 | 必須 | 初期値 | 説明 |
|--------|-----------------|------|-----|----------|------|--------|------|
| ポート番号 | edtPort | TSpinEdit | 入力 | Integer | はい | 9000 | サーバーがリッスンするポート番号（1000-9999999） |
| 秘密鍵ファイルパス | leKey | TLabeledEdit | 入力 | String | はい | （空） | SSL秘密鍵ファイル（.key）のフルパス |
| 公開鍵ファイルパス | leCrt | TLabeledEdit | 入力 | String | はい | （空） | SSL公開鍵ファイル（.crt）のフルパス |
| パスワード | lePassword | TLabeledEdit | 入力 | String | いいえ | （空） | 秘密鍵のパスワード（パスワードマスク表示） |

## 表示項目

| 項目名 | コンポーネント名 | 種類 | 表示内容 |
|--------|-----------------|------|----------|
| 秘密鍵ラベル | leKey.EditLabel | TLabel | "Private Key" |
| 公開鍵ラベル | leCrt.EditLabel | TLabel | "Public Key" |
| パスワードラベル | lePassword.EditLabel | TLabel | "Password" |
| スタートボタン | Button1 | TButton | "Start" |
| 秘密鍵選択ボタン | Button2 | TButton | "..." |
| 公開鍵選択ボタン | Button3 | TButton | "..." |
| ステータスバー | StatusBar1 | TStatusBar | サーバー起動状態（例: "Securite Server is running on https://0.0.0.0:9000"） |

## イベント仕様

### 1-FormCreate（フォーム作成イベント）

**トリガー**: アプリケーション起動時、フォームが作成される際に自動実行

**処理内容**:
1. THorse.Getメソッドを呼び出し
2. パス'/ping'に対するGETリクエストハンドラを登録
3. ハンドラは匿名プロシージャで、Res.Send('securite pong')を実行

**コード参照**: `Main.Form.pas` 53-60行目

### 2-Button1Click（Startボタン押下イベント）

**トリガー**: ユーザーがStartボタンをクリック

**処理内容**:
1. Startプロシージャを呼び出し

**コード参照**: `Main.Form.pas` 38-41行目

### 3-Start（サーバー起動処理）

**トリガー**: Button1Click内部で呼び出し

**処理内容**:
1. THorse.IOHandleSSLを呼び出しSSL設定を構成
   - KeyFile(leKey.Text): 秘密鍵ファイルパスを設定
   - CertFile(leCrt.Text): 公開鍵ファイルパスを設定
   - OnGetPassword(Self.OnGetPassword): パスワード取得コールバックを設定
   - SSLVersions([sslvTLSv1_2]): TLS 1.2を使用
   - Active(True): SSL機能を有効化
2. THorse.Listen(edtPort.Value, callback)でHTTPSサーバーを起動
3. コールバック内でStatusBar1にサーバー起動状態を表示

**コード参照**: `Main.Form.pas` 78-103行目

### 4-Button2Click（秘密鍵ファイル選択イベント）

**トリガー**: ユーザーが秘密鍵の「...」ボタンをクリック

**処理内容**:
1. GetFileプロシージャを呼び出し（'Private Key', '*key'）
2. 選択されたファイルパスをleKey.Textに設定

**コード参照**: `Main.Form.pas` 43-46行目

### 5-Button3Click（公開鍵ファイル選択イベント）

**トリガー**: ユーザーが公開鍵の「...」ボタンをクリック

**処理内容**:
1. GetFileプロシージャを呼び出し（'Public Key', '*crt'）
2. 選択されたファイルパスをleCrt.Textに設定

**コード参照**: `Main.Form.pas` 48-51行目

### 6-GetFile（ファイル選択ダイアログ処理）

**トリガー**: Button2ClickまたはButton3Click内部で呼び出し

**処理内容**:
1. OpenDialog1.Filterに説明と拡張子を設定
2. OpenDialog1.Execute()でダイアログを表示
3. ファイルが選択されていればファイルパスを返却

**コード参照**: `Main.Form.pas` 62-71行目

### 7-OnGetPassword（パスワード取得コールバック）

**トリガー**: SSL初期化時にIdSSLOpenSSLから呼び出し

**処理内容**:
1. lePassword.Textの値をPasswordパラメータに設定

**コード参照**: `Main.Form.pas` 73-76行目

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面ではデータベースアクセスは行わない |

### テーブル別更新項目詳細

本画面ではデータベースを使用しない。

## メッセージ仕様

| 種別 | メッセージ内容 | 表示条件 |
|------|--------------|----------|
| レスポンス | "securite pong" | /pingエンドポイントにGETリクエストが送信された場合 |
| 状態表示 | "Securite Server is running on https://{host}:{port}" | サーバー起動成功時にStatusBar1に表示 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|---------|---------|
| 証明書ファイル不正 | 秘密鍵または公開鍵ファイルが不正または存在しない場合 | SSL初期化時に例外が発生 |
| パスワード不一致 | 秘密鍵のパスワードが間違っている場合 | SSL初期化時に例外が発生 |
| ポート使用中エラー | 指定ポートが既に使用されている場合 | THorse.Listenで例外が発生 |
| DLLファイル欠落 | libeay32.dllまたはssleay32.dllが存在しない場合 | IdSSLOpenSSL初期化時に例外が発生 |

## 備考

- HORSE_VCLコンパイルディレクティブを設定する必要がある
- SSL使用時はlibeay32.dllとssleay32.dllが実行ファイルフォルダに必要
- 自己署名証明書の生成コマンド例（git bash推奨）:
  ```
  openssl req -x509 -nodes -days 365 -newkey rsa:2048 -keyout cert.key -out cert.crt
  ```
- 本サンプルはテスト・内部使用目的であり、本番環境では正規証明書（Let's Encrypt等）の使用を推奨
- SSLバージョンはTLS 1.2のみに制限されている（sslvTLSv1_2）
- フォームのタイトルは"Horse VCL with SSL - Sample"

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SSL設定に関連するデータ構造とHorseフレームワークのリクエスト/レスポンスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IdSSLOpenSSL.pas | Indy ライブラリ | TIdSSLIOHandlerSocketOpenSSLクラス、SSL設定オプション |
| 1-2 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequestクラスの構造 |
| 1-3 | Horse.Response.pas | `src/Horse.Response.pas` | THorseResponseクラスの構造、Sendメソッド |

**読解のコツ**: SSL設定はIndyライブラリのOpenSSL実装を使用している。

#### Step 2: エントリーポイントを理解する

処理の起点となるフォームファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Main.Form.dfm | `samples/delphi/vcl-ssl/src/Main.Form.dfm` | フォームのビジュアルレイアウト、コンポーネント配置 |
| 2-2 | Main.Form.pas | `samples/delphi/vcl-ssl/src/Main.Form.pas` | フォームクラスの実装、SSL設定処理 |

**主要処理フロー**:
1. **53-60行目**: FormCreate - /pingエンドポイントの登録
2. **62-71行目**: GetFile - ファイル選択ダイアログ処理
3. **73-76行目**: OnGetPassword - パスワード取得コールバック
4. **78-103行目**: Start - SSL設定とサーバー起動
5. **38-41行目**: Button1Click - Startボタンイベント
6. **43-46行目**: Button2Click - 秘密鍵選択イベント
7. **48-51行目**: Button3Click - 公開鍵選択イベント

#### Step 3: SSL設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.pas | `src/Horse.pas` | THorse.IOHandleSSLメソッドの定義 |
| 3-2 | Horse.Provider.IOHandleSSL.pas | `src/Horse.Provider.IOHandleSSL.pas` | SSL設定プロバイダーの実装 |

**主要処理フロー**:
- **89-94行目**: THorse.IOHandleSSLによるSSL設定チェーン
  - KeyFile: 秘密鍵ファイルパス設定
  - CertFile: 公開鍵ファイルパス設定
  - OnGetPassword: パスワードコールバック設定
  - SSLVersions: TLSバージョン設定
  - Active: SSL有効化

### プログラム呼び出し階層図

```
SamplesVCLSSL.exe
    |
    +-- TfrmMain (Main.Form.pas)
           |
           +-- FormCreate
           |      +-- THorse.Get('/ping', callback)
           |             +-- THorseCore.Get
           |
           +-- Button1Click (Start)
           |      +-- Start
           |             +-- THorse.IOHandleSSL
           |             |      +-- KeyFile(path)
           |             |      +-- CertFile(path)
           |             |      +-- OnGetPassword(callback)
           |             |      +-- SSLVersions([TLS1.2])
           |             |      +-- Active(True)
           |             +-- THorse.Listen(port, callback)
           |                    +-- THorseProvider<VCL>.Listen
           |                    +-- StatusBar1.Panels[0].Text := status
           |
           +-- Button2Click
           |      +-- GetFile('Private Key', '*key')
           |             +-- OpenDialog1.Execute()
           |             +-- leKey.Text := result
           |
           +-- Button3Click
                  +-- GetFile('Public Key', '*crt')
                         +-- OpenDialog1.Execute()
                         +-- leCrt.Text := result
```

### データフロー図

```
[入力]                        [処理]                              [出力]

edtPort.Value -----------> THorse.Listen ---------------> HTTPSサーバー起動
    (9000)                      |
                                v
leKey.Text --------------> IOHandleSSL.KeyFile ---------> SSL設定
    (cert.key path)             |
                                v
leCrt.Text --------------> IOHandleSSL.CertFile --------> SSL設定
    (cert.crt path)             |
                                v
lePassword.Text ---------> OnGetPassword callback ------> SSL初期化
    (password)                  |
                                v
                          Active(True) -----------------> StatusBar1表示
                                                         "Securite Server..."

HTTP GET /ping ---------> THorse.Routes.Execute --------> Res.Send('securite pong')
                                |                              |
                         THorseRequest                  THorseResponse
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Main.Form.pas | `samples/delphi/vcl-ssl/src/Main.Form.pas` | ソース | メインフォームの実装コード |
| Main.Form.dfm | `samples/delphi/vcl-ssl/src/Main.Form.dfm` | 設定 | フォームのビジュアルレイアウト定義 |
| SamplesVCLSSL.dpr | `samples/delphi/vcl-ssl/SamplesVCLSSL.dpr` | ソース | プロジェクトファイル（エントリーポイント） |
| Horse.pas | `src/Horse.pas` | ソース | Horseフレームワークのメインユニット |
| Horse.Provider.IOHandleSSL.pas | `src/Horse.Provider.IOHandleSSL.pas` | ソース | SSL設定プロバイダー |
| Horse.Provider.VCL.pas | `src/Horse.Provider.VCL.pas` | ソース | VCLプロバイダーの実装 |
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | HTTPリクエストクラス |
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | HTTPレスポンスクラス |
| libeay32.dll | 実行ファイルフォルダ | 外部DLL | OpenSSL暗号化ライブラリ |
| ssleay32.dll | 実行ファイルフォルダ | 外部DLL | OpenSSL SSLライブラリ |
