# 画面設計書 3-Windowsサービスメイン

## 概要

本ドキュメントは、Horseフレームワークを使用したDelphiのWindowsサービスアプリケーション（Windowsサービスメイン）について、その機能、サービス構成、処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

Windowsサービスメインは、HorseフレームワークベースのHTTPサーバーをWindowsサービスとして実行するためのサービスコンポーネントである。GUI画面は持たず、Windowsサービスコントロールマネージャー（SCM）からの指示に応じてサーバーの起動・停止を行う。

**業務上の目的・背景**：Webサーバーをバックグラウンドで常時稼働させる必要がある場合に使用する。Windowsサービスとして登録することで、ユーザーがログインしていない状態でも自動起動・実行が可能となる。サーバー管理者がGUIを使わずにサーバーを管理したい場合や、本番環境でのデプロイメントに適している。

**画面へのアクセス方法**：本コンポーネントはGUI画面を持たない。Windowsサービスとしてインストール後、以下の方法で制御する：
1. Windowsサービスコントロールパネル（services.msc）から起動・停止
2. コマンドライン: `net start MainService` / `net stop MainService`
3. sc.exe コマンドによる制御

**主要な操作・処理内容**：
1. ServiceCreate：サービスインスタンス作成時に/pingエンドポイントを登録
2. ServiceStart：サービス開始時にTHorse.Listenを呼び出してHTTPサーバーを起動
3. ServiceStop：サービス停止時にTHorse.StopListenを呼び出してHTTPサーバーを停止

**画面遷移**：本コンポーネントは画面を持たないため、画面遷移は存在しない。サービスの状態（停止中/起動中/実行中/停止中）はWindowsサービスマネージャーで管理される。

**権限による表示制御**：Windowsサービスの起動・停止には管理者権限が必要である。サービスのインストール・アンインストールにも管理者権限が必要となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | サーバー起動 | 主機能 | ServiceStart時にTHorse.Listenを呼び出してHTTPサーバーを起動 |
| 27 | サーバー停止 | 主機能 | ServiceStop時にTHorse.StopListenを呼び出してHTTPサーバーを停止 |
| 1 | GET リクエスト処理 | 補助機能 | ServiceCreate時に/pingエンドポイントをGETルートとして登録 |
| 17 | テキストレスポンス送信 | 補助機能 | /pingエンドポイントでRes.Send('pong')によりテキストレスポンスを返却 |

## 画面種別

バックグラウンドサービス（GUIなし）

## URL/ルーティング

- サービスURL: なし（Windowsサービス）
- 登録エンドポイント: `GET /ping` -> レスポンス: `pong`
- デフォルトリッスンポート: 9000（THorse.Listenのデフォルト値）

## 入出力項目

| 項目名 | 種類 | I/O | データ型 | 必須 | 初期値 | 説明 |
|--------|------|-----|----------|------|--------|------|
| - | - | - | - | - | - | 本コンポーネントはGUI入出力項目を持たない |

## 表示項目

| 項目名 | 種類 | 表示内容 |
|--------|------|----------|
| - | - | 本コンポーネントはGUI表示項目を持たない |

## サービスプロパティ

| プロパティ名 | 値 | 説明 |
|-------------|-----|------|
| DisplayName | MainService | サービスの表示名 |
| StartType | stManual | 起動種別（手動起動） |
| OnCreate | ServiceCreate | サービス作成イベント |
| OnStart | ServiceStart | サービス開始イベント |
| OnStop | ServiceStop | サービス停止イベント |

## イベント仕様

### 1-ServiceCreate（サービス作成イベント）

**トリガー**: サービスインスタンスが作成される際に自動実行

**処理内容**:
1. THorse.Getメソッドを呼び出し
2. パス'ping'に対するGETリクエストハンドラを登録
3. ハンドラは匿名プロシージャで、Res.Send('pong')を実行

**コード参照**: `Main.Service.pas` 36-43行目

### 2-ServiceStart（サービス開始イベント）

**トリガー**: サービスコントロールマネージャーからStart指示を受けた時

**処理内容**:
1. THorse.Listenを呼び出し（デフォルトポートで起動）
2. Started変数をTrueに設定してサービス開始完了を通知

**コード参照**: `Main.Service.pas` 45-49行目

### 3-ServiceStop（サービス停止イベント）

**トリガー**: サービスコントロールマネージャーからStop指示を受けた時

**処理内容**:
1. THorse.StopListenを呼び出してHTTPサーバーを停止
2. Stopped変数をTrueに設定してサービス停止完了を通知

**コード参照**: `Main.Service.pas` 51-55行目

### 4-ServiceController（サービスコントローラー）

**トリガー**: サービスコントロールマネージャーからの制御コード受信時

**処理内容**:
1. 制御コード(CtrlCode)をMainService.Controllerに渡す
2. TServiceから継承したControllerメソッドで処理

**コード参照**: `Main.Service.pas` 26-29行目

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本コンポーネントではデータベースアクセスは行わない |

### テーブル別更新項目詳細

本コンポーネントではデータベースを使用しない。

## メッセージ仕様

| 種別 | メッセージ内容 | 表示条件 |
|------|--------------|----------|
| レスポンス | "pong" | /pingエンドポイントにGETリクエストが送信された場合 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|---------|---------|
| ポート使用中エラー | デフォルトポートが既に使用されている場合 | THorse.Listenで例外が発生し、サービス開始失敗 |
| 権限エラー | サービス制御に必要な権限がない場合 | サービスコントロールマネージャーがエラーを返す |

## 備考

- サービスのインストール: `SamplesWinSvc.exe /install`
- サービスのアンインストール: `SamplesWinSvc.exe /uninstall`
- デフォルトポート番号は9000（THorse.Listenのデフォルト値）
- StartTypeがstManual（手動起動）のため、システム起動時の自動起動には設定変更が必要
- TServiceクラスを継承しており、Vcl.SvcMgrユニットを使用

---

## コードリーディングガイド

本コンポーネントを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Windowsサービスの基本構造とHorseフレームワークのリクエスト/レスポンスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Vcl.SvcMgr.pas | Delphi VCL | TServiceクラスの構造、サービスイベント |
| 1-2 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequestクラスの構造 |
| 1-3 | Horse.Response.pas | `src/Horse.Response.pas` | THorseResponseクラスの構造、Sendメソッド |

**読解のコツ**: TServiceはDelphiのVCL.SvcMgrユニットで提供されるWindowsサービス基底クラス。

#### Step 2: エントリーポイントを理解する

処理の起点となるサービスファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Main.Service.dfm | `samples/delphi/winsvc/src/Main.Service.dfm` | サービスコンポーネントのプロパティ定義 |
| 2-2 | Main.Service.pas | `samples/delphi/winsvc/src/Main.Service.pas` | サービスクラスの実装 |

**主要処理フロー**:
1. **26-29行目**: ServiceController - 制御コードの処理
2. **31-34行目**: GetServiceController - コントローラー取得
3. **36-43行目**: ServiceCreate - /pingエンドポイント登録
4. **45-49行目**: ServiceStart - サーバー起動
5. **51-55行目**: ServiceStop - サーバー停止

#### Step 3: Horseフレームワークコアを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.pas | `src/Horse.pas` | THorseクラス、Listen/StopListenメソッド |
| 3-2 | Horse.Core.pas | `src/Horse.Core.pas` | THorseCoreの実装、ルーティング登録 |

**主要処理フロー**:
- **THorse.Listen**: デフォルトプロバイダーでHTTPサーバーを起動
- **THorse.StopListen**: HTTPサーバーを停止
- **THorse.Get**: ルーティングテーブルにGETメソッドハンドラを登録

### プログラム呼び出し階層図

```
Windows SCM (Service Control Manager)
    |
    +-- SamplesWinSvc.exe (サービスプロセス)
           |
           +-- TMainService (Main.Service.pas)
                  |
                  +-- ServiceController(CtrlCode)
                  |      +-- MainService.Controller(CtrlCode)
                  |
                  +-- ServiceCreate
                  |      +-- THorse.Get('ping', callback)
                  |             +-- THorseCore.Get
                  |                    +-- Routes.Add
                  |
                  +-- ServiceStart
                  |      +-- THorse.Listen
                  |             +-- THorseProvider.Listen (default port)
                  |      +-- Started := True
                  |
                  +-- ServiceStop
                         +-- THorse.StopListen
                                +-- THorseProvider.StopListen
                         +-- Stopped := True
```

### データフロー図

```
[入力]                     [処理]                          [出力]

SCM Start Command -----> ServiceStart ----------------> HTTP Server起動
                              |                         (port 9000)
                              v
                         THorse.Listen
                              |
                              v
HTTP GET /ping --------> THorse.Routes.Execute -------> Res.Send('pong')
                              |                              |
                        THorseRequest                  THorseResponse
                              |
                              v
SCM Stop Command ------> ServiceStop -----------------> HTTP Server停止
                              |
                              v
                        THorse.StopListen
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Main.Service.pas | `samples/delphi/winsvc/src/Main.Service.pas` | ソース | サービスの実装コード |
| Main.Service.dfm | `samples/delphi/winsvc/src/Main.Service.dfm` | 設定 | サービスのプロパティ定義 |
| SamplesWinSvc.dpr | `samples/delphi/winsvc/SamplesWinSvc.dpr` | ソース | プロジェクトファイル（エントリーポイント） |
| Horse.pas | `src/Horse.pas` | ソース | Horseフレームワークのメインユニット |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | THorseCoreクラスの実装 |
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | HTTPリクエストクラス |
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | HTTPレスポンスクラス |
