# 画面設計書 4-LCLメインフォーム

## 概要

本ドキュメントは、Horseフレームワークを使用したLazarus LCLサンプルアプリケーションのメインフォーム（LCLメインフォーム）について、その機能、コンポーネント構成、処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

LCLメインフォームは、HorseフレームワークベースのHTTPサーバーをGUIから制御するためのLazarus LCLアプリケーション画面である。Delphi VCLメインフォームのLazarus版として、同等の機能を提供する。ユーザーはこの画面を通じて、ポート番号の指定、サーバーの起動・停止を行うことができる。

**業務上の目的・背景**：LazarusはFreePascal Compiler（FPC）を使用するクロスプラットフォームのRAD環境である。Windows以外のプラットフォーム（Linux、macOS）でもHorseサーバーをGUIから制御したい場合に本サンプルが参考となる。VCLサンプルと同様、開発者がGUIから簡単にサーバーの起動・停止を制御できるようにするためのサンプル画面である。

**画面へのアクセス方法**：コンパイル済みの実行ファイル（SamplesLCL）を起動すると、本画面が自動的に表示される。アプリケーション起動時にFormCreate処理が実行され、/pingエンドポイントのルーティングが登録される。

**主要な操作・処理内容**：
1. ポート番号入力（edtPort）：サーバーがリッスンするポート番号を入力する（デフォルト: 9000）
2. Startボタン押下（btnStart）：THorse.Listenを呼び出し、指定ポートでHTTPサーバーを起動する
3. Stopボタン押下（btnStop）：THorse.StopListenを呼び出し、実行中のHTTPサーバーを停止する

**画面遷移**：本画面は単一画面のアプリケーションであり、他の画面への遷移はない。アプリケーション起動時に表示され、終了時にクローズされる。サーバー状態（起動/停止）に応じてボタンの有効/無効状態が変化する。

**権限による表示制御**：本サンプルアプリケーションには権限管理機能は実装されていない。すべての機能が制限なく使用可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | サーバー起動 | 主機能 | Startボタン押下時にTHorse.Listenを呼び出してHTTPサーバーを起動 |
| 27 | サーバー停止 | 主機能 | Stopボタン押下時にTHorse.StopListenを呼び出してHTTPサーバーを停止 |
| 28 | ポート設定 | 補助機能 | edtPortテキストボックスで入力されたポート番号をサーバー起動時に使用 |
| 1 | GET リクエスト処理 | 補助機能 | FormCreate時に/pingエンドポイントをGETルートとして登録 |
| 17 | テキストレスポンス送信 | 補助機能 | DoPingコールバックでRes.Send('pong')によりテキストレスポンスを返却 |
| 56 | Lazarus対応 | 補助機能 | HORSE_LCLコンパイルディレクティブによりLazarus/LCL環境で動作 |

## 画面種別

制御画面（サーバー管理コンソール）

## URL/ルーティング

- アプリケーションURL: なし（デスクトップアプリケーション）
- 登録エンドポイント: `GET /ping` -> レスポンス: `pong`

## 入出力項目

| 項目名 | コンポーネント名 | 種類 | I/O | データ型 | 必須 | 初期値 | 説明 |
|--------|-----------------|------|-----|----------|------|--------|------|
| ポート番号 | edtPort | TEdit | 入力 | Integer | はい | 9000 | サーバーがリッスンするポート番号（数値のみ入力可） |

## 表示項目

| 項目名 | コンポーネント名 | 種類 | 表示内容 |
|--------|-----------------|------|----------|
| ポートラベル | Label1 | TLabel | "Port:" |
| スタートボタン | btnStart | TBitBtn | "Start" - サーバー停止中は有効、実行中は無効 |
| ストップボタン | btnStop | TBitBtn | "Stop" - サーバー実行中は有効、停止中は無効 |

## イベント仕様

### 1-FormCreate（フォーム作成イベント）

**トリガー**: アプリケーション起動時、フォームが作成される際に自動実行

**処理内容**:
1. THorse.Getメソッドを呼び出し
2. パス'/ping'に対するGETリクエストハンドラとしてDoPingプロシージャを登録

**コード参照**: `views.main.pas` 48-51行目

### 2-DoPing（pingエンドポイントハンドラ）

**トリガー**: /pingエンドポイントにGETリクエストが送信された時

**処理内容**:
1. Res.Send('pong')を実行してレスポンスを返却

**コード参照**: `views.main.pas` 29-32行目

### 3-btnStartClick（Startボタン押下イベント）

**トリガー**: ユーザーがStartボタンをクリック

**処理内容**:
1. Startプロシージャを呼び出し
2. THorse.Listen(StrToInt(edtPort.Text))でサーバーを起動
3. Statusプロシージャを呼び出し
4. ボタンとテキストボックスの有効/無効状態を更新

**コード参照**: `views.main.pas` 36-40行目

### 4-btnStopClick（Stopボタン押下イベント）

**トリガー**: ユーザーがStopボタンをクリック

**処理内容**:
1. Stopプロシージャを呼び出し
2. THorse.StopListenでサーバーを停止
3. Statusプロシージャを呼び出し
4. ボタンとテキストボックスの有効/無効状態を更新

**コード参照**: `views.main.pas` 42-46行目

### 5-Start（サーバー起動処理）

**トリガー**: btnStartClick内部で呼び出し

**処理内容**:
1. edtPort.Textを整数に変換
2. THorse.Listen(port)を呼び出してHTTPサーバーを起動

**コード参照**: `views.main.pas` 60-64行目

### 6-Stop（サーバー停止処理）

**トリガー**: btnStopClick内部で呼び出し

**処理内容**:
1. THorse.StopListenを呼び出してHTTPサーバーを停止

**コード参照**: `views.main.pas` 66-69行目

### 7-Status（UI状態更新処理）

**トリガー**: Start/Stop後に呼び出し

**処理内容**:
1. THorse.IsRunningでサーバー実行状態を取得
2. btnStop.Enabled := THorse.IsRunning
3. btnStart.Enabled := not THorse.IsRunning
4. edtPort.Enabled := not THorse.IsRunning

**コード参照**: `views.main.pas` 53-58行目

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本画面ではデータベースアクセスは行わない |

### テーブル別更新項目詳細

本画面ではデータベースを使用しない。

## メッセージ仕様

| 種別 | メッセージ内容 | 表示条件 |
|------|--------------|----------|
| レスポンス | "pong" | /pingエンドポイントにGETリクエストが送信された場合 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|---------|---------|
| ポート番号変換エラー | edtPortに数値以外が入力されている場合 | StrToIntで例外が発生（ただしNumbersOnly=Trueにより通常発生しない） |
| ポート使用中エラー | 指定ポートが既に使用されている場合 | THorse.Listenで例外が発生 |

## 備考

- HORSE_LCLコンパイルディレクティブを設定する必要がある
- LCLはLazarus Component Libraryの略で、Delphi VCLのクロスプラットフォーム版
- FreePascal Compiler（FPC）を使用してコンパイル
- コンパイラディレクティブ `{$MODE DELPHI}{$H+}` によりDelphi互換モードで動作
- VCLメインフォームとは異なり、FormCloseイベントは定義されていない
- DoPingは匿名プロシージャではなく、名前付きプロシージャとして定義（FPCでの互換性のため）
- LCLVersion: 2.2.2.0

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Horseフレームワークのリクエストとレスポンスのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequestクラスの構造 |
| 1-2 | Horse.Response.pas | `src/Horse.Response.pas` | THorseResponseクラスの構造、Sendメソッド |

**読解のコツ**: FPC条件コンパイル（{$IF DEFINED(FPC)}）によりLazarus固有の実装がある。

#### Step 2: エントリーポイントを理解する

処理の起点となるフォームファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | views.main.lfm | `samples/lazarus/lcl/src/views.main.lfm` | フォームのビジュアルレイアウト定義 |
| 2-2 | views.main.pas | `samples/lazarus/lcl/src/views.main.pas` | フォームクラスの実装、イベントハンドラ |

**主要処理フロー**:
1. **29-32行目**: DoPing - /pingレスポンスハンドラ
2. **36-40行目**: btnStartClick - 起動ボタンイベント
3. **42-46行目**: btnStopClick - 停止ボタンイベント
4. **48-51行目**: FormCreate - エンドポイント登録
5. **53-58行目**: Status - UI状態更新
6. **60-64行目**: Start - サーバー起動
7. **66-69行目**: Stop - サーバー停止

#### Step 3: Horseフレームワークコアを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.pas | `src/Horse.pas` | THorseクラス定義 |
| 3-2 | Horse.Core.pas | `src/Horse.Core.pas` | THorseCoreの実装 |
| 3-3 | Horse.Provider.LCL.pas | `src/Horse.Provider.LCL.pas` | LCLプロバイダーの実装 |

**主要処理フロー**:
- **THorse.Listen**: LCLプロバイダーを使用してHTTPサーバーを起動
- **THorse.Get**: ルーティングテーブルにGETメソッドハンドラを登録

### プログラム呼び出し階層図

```
SamplesLCL (実行ファイル)
    |
    +-- TFrmMain (views.main.pas)
           |
           +-- FormCreate
           |      +-- THorse.Get('/ping', DoPing)
           |             +-- THorseCore.Get
           |                    +-- Routes.Add
           |
           +-- btnStartClick
           |      +-- Start
           |      |      +-- THorse.Listen(port)
           |      |             +-- THorseProvider<LCL>.Listen
           |      +-- Status
           |             +-- THorse.IsRunning
           |
           +-- btnStopClick
                  +-- Stop
                  |      +-- THorse.StopListen
                  |             +-- THorseProvider<LCL>.StopListen
                  +-- Status

[HTTP Request]
    |
    +-- GET /ping
           +-- DoPing(Req, Res)
                  +-- Res.Send('pong')
```

### データフロー図

```
[入力]                    [処理]                          [出力]

edtPort.Text --------> StrToInt変換 -----------------> THorse.Listenへ
     (9000)                                           (ポート番号)

HTTP GET /ping ------> THorse.Routes.Execute --------> DoPing
                              |                           |
                       THorseRequest                      v
                                                   Res.Send('pong')
                                                         |
                                                   THorseResponse
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| views.main.pas | `samples/lazarus/lcl/src/views.main.pas` | ソース | メインフォームの実装コード |
| views.main.lfm | `samples/lazarus/lcl/src/views.main.lfm` | 設定 | フォームのビジュアルレイアウト定義 |
| SamplesLCL.lpr | `samples/lazarus/lcl/SamplesLCL.lpr` | ソース | プロジェクトファイル（エントリーポイント） |
| Horse.pas | `src/Horse.pas` | ソース | Horseフレームワークのメインユニット |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | THorseCoreクラスの実装 |
| Horse.Provider.LCL.pas | `src/Horse.Provider.LCL.pas` | ソース | LCLプロバイダーの実装 |
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | HTTPリクエストクラス |
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | HTTPレスポンスクラス |
