# 画面設計書 5-デーモンメイン

## 概要

本ドキュメントは、Horseフレームワークを使用したLazarusのデーモン/サービスアプリケーション（デーモンメイン）について、その機能、デーモン構成、処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

デーモンメインは、HorseフレームワークベースのHTTPサーバーをLazarusデーモン（Windowsサービス/Linuxデーモン）として実行するためのデーモンコンポーネントである。GUI画面は持たず、OSのサービスコントロールシステムからの指示に応じてサーバーの起動・停止を行う。TDaemonクラスを継承し、クロスプラットフォームでのデーモン実行をサポートする。

**業務上の目的・背景**：Lazarusで開発したWebサーバーをバックグラウンドで常時稼働させる必要がある場合に使用する。Delphiの TService（Windowsサービス）と同様の機能を、Lazarus/FPCでクロスプラットフォーム対応として提供する。Windowsではサービスとして、Linuxではデーモンとして動作する。

**画面へのアクセス方法**：本コンポーネントはGUI画面を持たない。OSのサービス/デーモン管理システムから制御する：
- Windows: サービスコントロールパネル（services.msc）または sc.exe コマンド
- Linux: systemctl または service コマンド

**主要な操作・処理内容**：
1. DataModuleCreate：デーモンインスタンス作成時に/pingエンドポイントを登録
2. DataModuleStart：デーモン開始時に別スレッドでTHorse.Listen(9000)を呼び出してHTTPサーバーを起動
3. DataModuleShutDown：デーモン停止時にTHorse.StopListenを呼び出してHTTPサーバーを停止

**画面遷移**：本コンポーネントは画面を持たないため、画面遷移は存在しない。デーモンの状態はOSのサービス管理システムで管理される。

**権限による表示制御**：デーモン/サービスの起動・停止には管理者権限（Windows）またはroot権限（Linux）が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | サーバー起動 | 主機能 | DataModuleStart時に別スレッドでTHorse.Listen(9000)を呼び出してHTTPサーバーを起動 |
| 27 | サーバー停止 | 主機能 | DataModuleShutDown時にTHorse.StopListenを呼び出してHTTPサーバーを停止 |
| 28 | ポート設定 | 補助機能 | ポート9000をハードコードしてサーバー起動時に使用 |
| 1 | GET リクエスト処理 | 補助機能 | DataModuleCreate時に/pingエンドポイントをGETルートとして登録 |
| 17 | テキストレスポンス送信 | 補助機能 | Pingコールバックでres.Send('pong')によりテキストレスポンスを返却 |
| 55 | Daemon プロバイダー | 補助機能 | HORSE_DAEMONコンパイルディレクティブによりLinuxデーモンとして動作 |
| 56 | Lazarus対応 | 補助機能 | TDaemonクラスを継承しLazarus環境でデーモンとして動作 |

## 画面種別

バックグラウンドデーモン/サービス（GUIなし）

## URL/ルーティング

- サービスURL: なし（デーモン/サービス）
- 登録エンドポイント: `GET /ping` -> レスポンス: `pong`
- リッスンポート: 9000（ハードコード）

## 入出力項目

| 項目名 | 種類 | I/O | データ型 | 必須 | 初期値 | 説明 |
|--------|------|-----|----------|------|--------|------|
| - | - | - | - | - | - | 本コンポーネントはGUI入出力項目を持たない |

## 表示項目

| 項目名 | 種類 | 表示内容 |
|--------|------|----------|
| - | - | 本コンポーネントはGUI表示項目を持たない |

## デーモンプロパティ

| プロパティ名 | 値 | 説明 |
|-------------|-----|------|
| OnCreate | DataModuleCreate | デーモン作成イベント |
| OnStart | DataModuleStart | デーモン開始イベント |
| OnShutDown | DataModuleShutDown | デーモン停止イベント |
| OldCreateOrder | False | 作成順序設定 |

## イベント仕様

### 1-DataModuleCreate（デーモン作成イベント）

**トリガー**: デーモンインスタンスが作成される際に自動実行

**処理内容**:
1. THorse.Getメソッドを呼び出し
2. パス'ping'に対するGETリクエストハンドラとしてPingプロシージャを登録（@Ping構文でプロシージャ参照を渡す）

**コード参照**: `daemonmain.pas` 43-46行目

### 2-Ping（pingエンドポイントハンドラ）

**トリガー**: /pingエンドポイントにGETリクエストが送信された時

**処理内容**:
1. res.Send('pong')を実行してレスポンスを返却

**コード参照**: `daemonmain.pas` 36-39行目

### 3-DataModuleStart（デーモン開始イベント）

**トリガー**: OSのサービス管理システムからStart指示を受けた時

**処理内容**:
1. TThread.CreateAnonymousThread(@RunHorse).Startで別スレッドを起動
2. 別スレッドでRunHorseプロシージャを実行

**コード参照**: `daemonmain.pas` 53-56行目

### 4-RunHorse（サーバー起動処理）

**トリガー**: DataModuleStart内部で作成されたスレッドから呼び出し

**処理内容**:
1. THorse.Listen(9000)を呼び出してポート9000でHTTPサーバーを起動

**コード参照**: `daemonmain.pas` 30-34行目

### 5-DataModuleShutDown（デーモン停止イベント）

**トリガー**: OSのサービス管理システムからStop/Shutdown指示を受けた時

**処理内容**:
1. THorse.StopListenを呼び出してHTTPサーバーを停止

**コード参照**: `daemonmain.pas` 48-51行目

### 6-RegisterDaemon（デーモン登録処理）

**トリガー**: ユニット初期化時（initialization）

**処理内容**:
1. RegisterDaemonClass(TDaemon_Main)でデーモンクラスをシステムに登録

**コード参照**: `daemonmain.pas` 25-28行目, 58-59行目

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本コンポーネントではデータベースアクセスは行わない |

### テーブル別更新項目詳細

本コンポーネントではデータベースを使用しない。

## メッセージ仕様

| 種別 | メッセージ内容 | 表示条件 |
|------|--------------|----------|
| レスポンス | "pong" | /pingエンドポイントにGETリクエストが送信された場合 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|---------|---------|
| ポート使用中エラー | ポート9000が既に使用されている場合 | THorse.Listenで例外が発生し、デーモン起動処理でエラー |
| 権限エラー | デーモン制御に必要な権限がない場合 | OSのサービス管理システムがエラーを返す |

## 備考

- HORSE_DAEMONコンパイルディレクティブを設定する必要がある
- TDaemonクラスはLazarusのDaemonAppユニットで提供される
- THorse.Listenは別スレッドで実行されるため、メインスレッドはデーモン制御に専念できる
- ポート番号（9000）はソースコードにハードコードされている
- FPCのコンパイラディレクティブ `{$mode objfpc}{$H+}` によりObject Pascal互換モードで動作
- デーモンの設定（サービス名、表示名等）はデーモンマネージャー（daemonmanager）で定義

---

## コードリーディングガイド

本コンポーネントを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Lazarusデーモンの基本構造とHorseフレームワークのリクエスト/レスポンスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DaemonApp.pas | FPC/Lazarus | TDaemon, TCustomDaemonクラスの構造 |
| 1-2 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequestクラスの構造 |
| 1-3 | Horse.Response.pas | `src/Horse.Response.pas` | THorseResponseクラスの構造、Sendメソッド |

**読解のコツ**: TDaemonはLazarusのDaemonAppユニットで提供されるクロスプラットフォームデーモン基底クラス。

#### Step 2: エントリーポイントを理解する

処理の起点となるデーモンファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | daemonmain.lfm | `samples/lazarus/winsvc/daemonmain.lfm` | デーモンコンポーネントのプロパティ定義 |
| 2-2 | daemonmain.pas | `samples/lazarus/winsvc/daemonmain.pas` | デーモンクラスの実装 |

**主要処理フロー**:
1. **25-28行目**: RegisterDaemon - デーモンクラス登録
2. **30-34行目**: RunHorse - サーバー起動処理（別スレッドで実行）
3. **36-39行目**: Ping - エンドポイントハンドラ
4. **43-46行目**: DataModuleCreate - /pingエンドポイント登録
5. **48-51行目**: DataModuleShutDown - サーバー停止
6. **53-56行目**: DataModuleStart - 別スレッドでサーバー起動
7. **58-59行目**: initialization - デーモン登録

#### Step 3: デーモンマネージャーとの関連を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | daemonmanager.lfm | `samples/lazarus/winsvc/daemonmanager.lfm` | デーモンの設定定義 |
| 3-2 | daemonmanager.pas | `samples/lazarus/winsvc/daemonmanager.pas` | TDaemonMapperの実装 |

**主要処理フロー**:
- **daemonmanager.lfm**: デーモン名、表示名、説明、オプション等を定義

### プログラム呼び出し階層図

```
OS Service Manager (SCM / systemd)
    |
    +-- SamplesWinSvc (デーモンプロセス)
           |
           +-- TDaemon_Manager (daemonmanager.pas)
           |      +-- DaemonDefs設定
           |             - DaemonClassName = 'TDaemon_Main'
           |             - Name = 'HorseService'
           |             - DisplayName = 'WinSrvHorse'
           |
           +-- TDaemon_Main (daemonmain.pas)
                  |
                  +-- [initialization]
                  |      +-- RegisterDaemon
                  |             +-- RegisterDaemonClass(TDaemon_Main)
                  |
                  +-- DataModuleCreate
                  |      +-- THorse.Get('ping', @Ping)
                  |             +-- THorseCore.Get
                  |
                  +-- DataModuleStart
                  |      +-- TThread.CreateAnonymousThread(@RunHorse).Start
                  |             +-- RunHorse (別スレッド)
                  |                    +-- THorse.Listen(9000)
                  |
                  +-- DataModuleShutDown
                         +-- THorse.StopListen
```

### データフロー図

```
[入力]                       [処理]                          [出力]

OS Start Command ------> DataModuleStart ---------------> スレッド起動
                              |
                              v
                         TThread.Create
                              |
                              v [別スレッド]
                         RunHorse
                              |
                              v
                         THorse.Listen(9000) -----------> HTTP Server起動
                                                         (port 9000)

HTTP GET /ping --------> THorse.Routes.Execute --------> Ping
                              |                              |
                        THorseRequest                        v
                                                   res.Send('pong')
                                                         |
                                                   THorseResponse

OS Stop Command -------> DataModuleShutDown ------------> HTTP Server停止
                              |
                              v
                        THorse.StopListen
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| daemonmain.pas | `samples/lazarus/winsvc/daemonmain.pas` | ソース | デーモンの実装コード |
| daemonmain.lfm | `samples/lazarus/winsvc/daemonmain.lfm` | 設定 | デーモンのプロパティ定義 |
| daemonmanager.pas | `samples/lazarus/winsvc/daemonmanager.pas` | ソース | デーモンマネージャーの実装 |
| daemonmanager.lfm | `samples/lazarus/winsvc/daemonmanager.lfm` | 設定 | デーモン設定定義 |
| SamplesWinSvc.lpr | `samples/lazarus/winsvc/SamplesWinSvc.lpr` | ソース | プロジェクトファイル |
| Horse.pas | `src/Horse.pas` | ソース | Horseフレームワークのメインユニット |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | THorseCoreクラスの実装 |
| Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | ソース | Daemonプロバイダーの実装 |
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | HTTPリクエストクラス |
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | HTTPレスポンスクラス |
