# 画面設計書 6-デーモンマネージャー

## 概要

本ドキュメントは、Horseフレームワークを使用したLazarusのデーモンマネージャーコンポーネント（デーモンマネージャー）について、その機能、設定内容、役割を詳細に記述した画面設計書である。

### 本画面の処理概要

デーモンマネージャーは、Lazarusデーモンの設定・管理を行うマッパーコンポーネントである。TDaemonMapperクラスを継承し、デーモンの名前、表示名、説明、起動オプションなどのメタデータを定義する。実際の処理ロジックは持たず、デーモンメイン（TDaemon_Main）の設定情報を保持するコンテナとして機能する。

**業務上の目的・背景**：Lazarusデーモンアプリケーションでは、実際の処理を行うデーモンクラス（TDaemon）と、その設定を管理するデーモンマッパークラス（TDaemonMapper）を分離する設計パターンを採用している。これにより、デーモンの設定を変更する際にロジックコードを修正する必要がなく、保守性が向上する。サービス名や表示名などのWindows/Linuxサービス登録に必要な情報をLFMファイルで定義する。

**画面へのアクセス方法**：本コンポーネントはGUI画面を持たない。コンポーネントの設定はLFMファイル（daemonmanager.lfm）で定義され、コンパイル時にアプリケーションに組み込まれる。実行時にはOSのサービス管理システムがこの設定を参照してサービスを登録・管理する。

**主要な操作・処理内容**：
1. デーモンクラスの登録：RegisterDaemonMapper(TDaemon_Manager)によりマッパーをシステムに登録
2. デーモン定義の提供：DaemonDefsプロパティでデーモンの設定情報を提供

**画面遷移**：本コンポーネントは画面を持たないため、画面遷移は存在しない。

**権限による表示制御**：本コンポーネントは設定情報のみを持つため、権限による制御は適用されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | Daemon プロバイダー | 主機能 | TDaemonMapperを継承しデーモンサービスの設定・管理を担当 |
| 56 | Lazarus対応 | 補助機能 | Lazarus環境でデーモンマッパーとして動作 |

## 画面種別

設定コンポーネント（GUIなし）

## URL/ルーティング

本コンポーネントはHTTPリクエストを処理しない。

## 入出力項目

| 項目名 | 種類 | I/O | データ型 | 必須 | 初期値 | 説明 |
|--------|------|-----|----------|------|--------|------|
| - | - | - | - | - | - | 本コンポーネントはGUI入出力項目を持たない |

## 表示項目

| 項目名 | 種類 | 表示内容 |
|--------|------|----------|
| - | - | 本コンポーネントはGUI表示項目を持たない |

## デーモン定義（DaemonDefs）

### 基本設定

| プロパティ名 | 値 | 説明 |
|-------------|-----|------|
| DaemonClassName | TDaemon_Main | 対象デーモンクラス名 |
| Name | HorseService | サービスの内部名（識別子） |
| Description | Windows Service Horse | サービスの説明文 |
| DisplayName | WinSrvHorse | サービスの表示名（ユーザー向け） |
| Options | doAllowStop, doAllowPause | 許可する操作オプション |
| LogStatusReport | False | ステータスレポートのログ出力 |

### Windows固有設定（WinBindings）

| プロパティ名 | 値 | 説明 |
|-------------|-----|------|
| Dependencies | （空） | 依存サービスなし |
| StartType | stBoot | 起動種別（ブート時起動） |
| WaitHint | 0 | 待機ヒント（ミリ秒） |
| IDTag | 0 | サービスIDタグ |
| ServiceType | stWin32 | サービス種別（Win32サービス） |
| ErrorSeverity | esIgnore | エラー深刻度（無視） |
| AcceptedCodes | （空） | 受け入れるカスタムコード |

## イベント仕様

### 1-RegisterMapper（マッパー登録処理）

**トリガー**: ユニット初期化時（initialization）

**処理内容**:
1. RegisterDaemonMapper(TDaemon_Manager)でマッパークラスをシステムに登録

**コード参照**: `daemonmanager.pas` 19-22行目, 26-27行目

## 処理フロー

本コンポーネントは処理ロジックを持たず、設定情報のみを提供する。処理フローは以下の通り：

1. アプリケーション起動時
   - initializationセクションでRegisterMapperが呼び出される
   - RegisterDaemonMapper(TDaemon_Manager)によりマッパーが登録される
2. デーモン登録時
   - OSのサービス管理システムがDaemonDefsを参照
   - Name、DisplayName、Description等の情報を使用してサービスを登録
3. デーモン起動時
   - DaemonClassNameで指定されたTDaemon_Mainが実行される
   - Optionsで許可された操作（Stop、Pause）が有効になる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本コンポーネントではデータベースアクセスは行わない |

### テーブル別更新項目詳細

本コンポーネントではデータベースを使用しない。

## メッセージ仕様

本コンポーネントはメッセージを出力しない。

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|---------|---------|
| 登録エラー | DaemonClassNameで指定されたクラスが存在しない場合 | アプリケーション起動時にエラー |

## 備考

- TDaemonMapperはLazarusのDaemonAppユニットで提供される
- 実際の処理ロジックはデーモンメイン（daemonmain.pas）で実装される
- LFMファイル（daemonmanager.lfm）でデーモン設定を定義
- コードファイル（daemonmanager.pas）は最小限の実装のみ
- StartType=stBootは「システム起動時に自動起動」を意味する
- Options=[doAllowStop, doAllowPause]により、サービスの停止・一時停止が許可される

---

## コードリーディングガイド

本コンポーネントを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Lazarusデーモンマッパーの基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DaemonApp.pas | FPC/Lazarus | TDaemonMapper, TDaemonDefクラスの構造 |

**読解のコツ**: TDaemonMapperはデーモンの設定情報を保持するコンテナクラス。DaemonDefsプロパティでデーモン定義のコレクションを管理する。

#### Step 2: 設定ファイルを理解する

デーモンの設定が定義されているLFMファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | daemonmanager.lfm | `samples/lazarus/winsvc/daemonmanager.lfm` | デーモン設定定義 |

**主要設定項目**:
1. **2-17行目**: DaemonDefs - デーモン定義コレクション
2. **4行目**: DaemonClassName - 対象デーモンクラス名
3. **5行目**: Name - サービス内部名
4. **6行目**: Description - サービス説明
5. **7行目**: DisplayName - 表示名
6. **8行目**: Options - 許可オプション
7. **9-16行目**: WinBindings - Windows固有設定

#### Step 3: 実装コードを確認する

最小限の実装コードを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | daemonmanager.pas | `samples/lazarus/winsvc/daemonmanager.pas` | マッパーの実装 |

**主要処理フロー**:
1. **11行目**: TDaemonMapperを継承したTDaemon_Managerクラス定義
2. **19-22行目**: RegisterMapper - マッパー登録プロシージャ
3. **26-27行目**: initialization - 起動時にRegisterMapperを呼び出し

### プログラム呼び出し階層図

```
SamplesWinSvc (デーモンプロセス)
    |
    +-- [initialization]
    |      +-- daemonmanager.RegisterMapper
    |      |      +-- RegisterDaemonMapper(TDaemon_Manager)
    |      |
    |      +-- daemonmain.RegisterDaemon
    |             +-- RegisterDaemonClass(TDaemon_Main)
    |
    +-- OS Service Manager
           |
           +-- TDaemon_Manager (daemonmanager.pas)
           |      +-- DaemonDefs 設定参照
           |             - DaemonClassName = 'TDaemon_Main'
           |             - Name = 'HorseService'
           |             - DisplayName = 'WinSrvHorse'
           |             - Description = 'Windows Service Horse'
           |
           +-- TDaemon_Main (daemonmain.pas)
                  +-- 実際のデーモン処理を実行
```

### データフロー図

```
[設定]                       [処理]                      [出力]

daemonmanager.lfm -------> コンパイル時読み込み ------> TDaemon_Manager
    |                                                       |
    v                                                       v
DaemonDefs設定            RegisterDaemonMapper -------> OSに登録
    |                                                       |
    v                                                       v
・DaemonClassName ------> TDaemon_Mainと紐付け            サービス登録
・Name/DisplayName -----> サービス名として使用            services.msc
・Options --------------> 停止/一時停止許可                に表示
・WinBindings ----------> Windows固有設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| daemonmanager.pas | `samples/lazarus/winsvc/daemonmanager.pas` | ソース | マッパーの最小実装 |
| daemonmanager.lfm | `samples/lazarus/winsvc/daemonmanager.lfm` | 設定 | デーモン設定定義 |
| daemonmain.pas | `samples/lazarus/winsvc/daemonmain.pas` | ソース | 実際のデーモン実装 |
| daemonmain.lfm | `samples/lazarus/winsvc/daemonmain.lfm` | 設定 | デーモンプロパティ |
| SamplesWinSvc.lpr | `samples/lazarus/winsvc/SamplesWinSvc.lpr` | ソース | プロジェクトファイル |
