# 画面設計書 7-Webモジュール

## 概要

本ドキュメントは、HorseフレームワークのコアコンポーネントであるWebモジュール（Delphi版）について、その機能、処理フロー、アーキテクチャを詳細に記述した画面設計書である。

### 本画面の処理概要

Webモジュールは、CGI、ISAPI、Apache モジュールなどのWebサーバー統合環境でHTTPリクエストを処理するためのコアコンポーネントである。TWebModule（Delphi）またはTFPWebModule（Lazarus/FPC）を継承し、Webサーバーからのリクエストを受け取り、Horseフレームワークのルーティングシステムに橋渡しを行う。GUI画面は持たず、HTTPリクエスト/レスポンス処理に特化したモジュールである。

**業務上の目的・背景**：HorseフレームワークをCGI、ISAPI、Apacheモジュールとしてデプロイする際の基盤コンポーネントである。スタンドアロンのHTTPサーバーではなく、既存のWebサーバー（Apache、IIS等）の拡張モジュールとしてHorseアプリケーションを実行したい場合に使用する。これにより、Webサーバーの負荷分散、SSL処理、仮想ホスト設定などの機能を活用できる。

**画面へのアクセス方法**：本コンポーネントはGUI画面を持たない。Webサーバーがリクエストを受け取ると、自動的にこのモジュールのHandlerActionまたはDoOnRequestが呼び出される。

**主要な操作・処理内容**：
1. HTTPリクエストの受信：Webサーバーからリクエストを受け取る
2. THorseRequestの生成：リクエスト情報をTHorseRequestオブジェクトにラップ
3. THorseResponseの生成：レスポンス用のTHorseResponseオブジェクトを作成
4. ルーティング実行：FHorse.Routes.Executeでルーティング処理を実行
5. 例外処理：EHorseCallbackInterrupted例外を適切に処理
6. リソース解放：リクエスト/レスポンスオブジェクトを解放

**画面遷移**：本コンポーネントは画面を持たないため、画面遷移は存在しない。

**権限による表示制御**：本コンポーネント自体には権限管理機能はない。権限制御はHorseミドルウェアで実装する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | リクエストボディ取得 | 主機能 | HandlerActionでTHorseRequestを生成しリクエストボディを処理 |
| 17 | テキストレスポンス送信 | 主機能 | HandlerActionでTHorseResponseを生成しレスポンスを処理 |
| 42 | 割り込み例外 | 補助機能 | EHorseCallbackInterrupted例外を捕捉してコールバックチェーンの中断を処理 |
| 52 | CGI プロバイダー | API連携 | CGIモードでHTTPリクエストを処理するためのWebモジュール |
| 53 | ISAPI プロバイダー | API連携 | ISAPIモジュールとしてHTTPリクエストを処理するためのWebモジュール |
| 54 | Apache プロバイダー | API連携 | ApacheモジュールとしてHTTPリクエストを処理するためのWebモジュール |

## 画面種別

Webモジュールコンポーネント（GUIなし）

## URL/ルーティング

- デフォルトアクションパス: `/`
- デフォルトアクション名: `DefaultHandler`
- ルーティング: Horseフレームワークのルーティングシステムに委譲

## 入出力項目

| 項目名 | 種類 | I/O | データ型 | 必須 | 初期値 | 説明 |
|--------|------|-----|----------|------|--------|------|
| Request | TWebRequest | 入力 | Object | はい | - | WebサーバーからのHTTPリクエスト |
| Response | TWebResponse | 出力 | Object | はい | - | WebサーバーへのHTTPレスポンス |
| Handled | Boolean | 出力 | Boolean | はい | True | リクエスト処理完了フラグ |

## 表示項目

本コンポーネントはGUI表示項目を持たない。

## Webモジュールプロパティ

| プロパティ名 | 値 | 説明 |
|-------------|-----|------|
| Actions[0].Default | True | デフォルトアクションとして設定 |
| Actions[0].Name | DefaultHandler | アクション名 |
| Actions[0].PathInfo | / | 処理対象パス |
| Actions[0].OnAction | HandlerAction | アクションイベントハンドラ |

## イベント仕様

### 1-HandlerAction（HTTPリクエスト処理 - Delphi/共通）

**トリガー**: WebサーバーからHTTPリクエストを受信した時

**処理内容**:
1. Handled := True を設定（リクエスト処理を担当することを宣言）
2. THorseRequest.Create(Request) でリクエストオブジェクトを生成
3. THorseResponse.Create(Response) でレスポンスオブジェクトを生成
4. try-except ブロックで例外を捕捉
5. FHorse.Routes.Execute(LRequest, LResponse) でルーティングを実行
6. EHorseCallbackInterrupted 以外の例外は再スロー
7. finally ブロックでリソースを解放
   - リクエストボディとレスポンスコンテンツが同一オブジェクトの場合、Content(nil) で参照を解除
   - LRequest.Free と LResponse.Free でオブジェクトを解放

**コード参照**: `Horse.WebModule.pas` 87-110行目

### 2-DoOnRequest（HTTPリクエスト処理 - Lazarus/FPC専用）

**トリガー**: FPCコンパイル時、WebサーバーからHTTPリクエストを受信した時

**処理内容**:
1. HandlerActionを呼び出して処理を委譲

**コード参照**: `Horse.WebModule.pas` 80-85行目

### 3-Create（コンストラクタ）

**トリガー**: Webモジュールインスタンス作成時

**処理内容**:
1. 親クラスのコンストラクタを呼び出し（FPCの場合はCreateNew）
2. FHorse := THorseCore.GetInstance でHorseCoreインスタンスを取得
3. FInstance := Self でシングルトンインスタンスを設定

**コード参照**: `Horse.WebModule.pas` 69-78行目

### 4-GetInstance（シングルトン取得）

**トリガー**: 外部からWebモジュールインスタンスを取得する時

**処理内容**:
1. FInstance（クラス変数）を返却

**コード参照**: `Horse.WebModule.pas` 64-67行目

## 処理フロー図

```
Webサーバー (Apache/IIS)
    |
    v
[HTTPリクエスト受信]
    |
    v
THorseWebModule.HandlerAction (または DoOnRequest)
    |
    +-- Handled := True
    |
    +-- LRequest := THorseRequest.Create(Request)
    |
    +-- LResponse := THorseResponse.Create(Response)
    |
    +-- try
    |      |
    |      +-- FHorse.Routes.Execute(LRequest, LResponse)
    |             |
    |             +-- ルーティングマッチング
    |             |
    |             +-- ミドルウェア実行
    |             |
    |             +-- ハンドラ実行
    |
    +-- except
    |      |
    |      +-- EHorseCallbackInterrupted: 無視（正常な中断）
    |      |
    |      +-- その他の例外: 再スロー
    |
    +-- finally
           |
           +-- リソース解放
                  |
                  +-- LRequest.Free
                  |
                  +-- LResponse.Free
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本コンポーネント自体はデータベースアクセスを行わない |

### テーブル別更新項目詳細

本コンポーネントではデータベースを使用しない。データベースアクセスは登録されたルートハンドラ内で実装する。

## メッセージ仕様

本コンポーネント自体はメッセージを出力しない。メッセージはルートハンドラ内でレスポンスとして送信する。

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|---------|---------|
| EHorseCallbackInterrupted | コールバックチェーン中断時（ミドルウェアでのガード処理等） | 例外を捕捉し、処理を正常終了として扱う |
| その他の例外 | ルートハンドラ内でのエラー | 例外を再スローし、Webサーバーのエラーハンドリングに委譲 |

## 備考

- 条件コンパイル `{$IF DEFINED(FPC)}` によりDelphi/Lazarus両方に対応
- Delphiの場合: TWebModuleを継承
- Lazarus/FPCの場合: TFPWebModuleを継承
- シングルトンパターンを採用（GetInstanceメソッド）
- Lazarus/FPCの場合、initializationセクションでRegisterHTTPModule(THorseWebModule)によりモジュール登録
- リソースファイル: Delphiは.dfm、Lazarusは.lfm

---

## コードリーディングガイド

本コンポーネントを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、HTTPリクエスト/レスポンスのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequestクラス、リクエストデータのラップ方法 |
| 1-2 | Horse.Response.pas | `src/Horse.Response.pas` | THorseResponseクラス、レスポンス生成方法 |
| 1-3 | Horse.Exception.Interrupted.pas | `src/Horse.Exception.Interrupted.pas` | EHorseCallbackInterrupted例外クラス |

**読解のコツ**: THorseRequest/THorseResponseはWebサーバー固有のリクエスト/レスポンスオブジェクトをラップしている。

#### Step 2: エントリーポイントを理解する

Webモジュールの設定と実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.WebModule.dfm | `src/Horse.WebModule.dfm` | モジュールプロパティ、アクション定義 |
| 2-2 | Horse.WebModule.pas | `src/Horse.WebModule.pas` | モジュール実装、HandlerAction |

**主要処理フロー**:
1. **64-67行目**: GetInstance - シングルトンインスタンス取得
2. **69-78行目**: Create - コンストラクタ、THorseCoreの取得
3. **80-85行目**: DoOnRequest - FPC用リクエストハンドラ（HandlerActionに委譲）
4. **87-110行目**: HandlerAction - メインのリクエスト処理
5. **112-115行目**: initialization（FPC）- モジュール登録

#### Step 3: Horseコアとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Core.pas | `src/Horse.Core.pas` | THorseCoreクラス、Routes.Execute |
| 3-2 | Horse.Router.pas | `src/Horse.Router.pas` | ルーティングシステム |

**主要処理フロー**:
- **FHorse.Routes.Execute**: ルーティングマッチングとハンドラ実行

### プログラム呼び出し階層図

```
Webサーバー (Apache/IIS/CGI)
    |
    +-- THorseWebModule
           |
           +-- [initialization] (FPCのみ)
           |      +-- RegisterHTTPModule(THorseWebModule)
           |
           +-- Create (コンストラクタ)
           |      +-- inherited Create/CreateNew
           |      +-- FHorse := THorseCore.GetInstance
           |      +-- FInstance := Self
           |
           +-- DoOnRequest (FPCのみ)
           |      +-- HandlerAction(Self, ARequest, AResponse, AHandled)
           |
           +-- HandlerAction
                  |
                  +-- Handled := True
                  |
                  +-- THorseRequest.Create(Request)
                  |      +-- Webサーバーリクエストをラップ
                  |
                  +-- THorseResponse.Create(Response)
                  |      +-- Webサーバーレスポンスをラップ
                  |
                  +-- try
                  |      +-- FHorse.Routes.Execute(LRequest, LResponse)
                  |             |
                  |             +-- THorseRouter.Route
                  |             |      +-- パスマッチング
                  |             |      +-- ミドルウェア実行
                  |             |      +-- ハンドラ実行
                  |             |
                  |             +-- レスポンス送信
                  |
                  +-- except (EHorseCallbackInterrupted)
                  |      +-- 無視（正常な処理中断）
                  |
                  +-- finally
                         +-- LRequest.Free
                         +-- LResponse.Free
```

### データフロー図

```
[入力]                       [処理]                          [出力]

TWebRequest/TRequest -----> THorseRequest.Create --------> LRequest
(Webサーバー固有)                |
                                v
                         FHorse.Routes.Execute
                                |
                                v
                         [ルートマッチング]
                                |
                                v
                         [ミドルウェア実行]
                                |
                                v
                         [ハンドラ実行]
                                |
                                v
TWebResponse/TResponse <----- THorseResponse ------------ LResponse
(Webサーバー固有)                                         (レスポンス)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | Webモジュールの実装（Delphi/Lazarus共通） |
| Horse.WebModule.dfm | `src/Horse.WebModule.dfm` | 設定 | Delphi用モジュールプロパティ |
| Horse.WebModule.lfm | `src/Horse.WebModule.lfm` | 設定 | Lazarus用モジュールプロパティ |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | THorseCoreクラス |
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | THorseRequestクラス |
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | THorseResponseクラス |
| Horse.Exception.Interrupted.pas | `src/Horse.Exception.Interrupted.pas` | ソース | 中断例外クラス |
