# 画面設計書 8-Webモジュール（Lazarus版）

## 概要

本ドキュメントは、HorseフレームワークのコアコンポーネントであるWebモジュール（Lazarus版）について、その機能、処理フロー、アーキテクチャを詳細に記述した画面設計書である。

### 本画面の処理概要

Webモジュール（Lazarus版）は、CGI、FastCGI、ApacheモジュールなどのWebサーバー統合環境でHTTPリクエストを処理するためのコアコンポーネントである。TFPWebModuleを継承し、Lazarus/FreePascal環境でWebサーバーからのリクエストを受け取り、Horseフレームワークのルーティングシステムに橋渡しを行う。No.7のDelphiWebモジュールと同一のソースファイル（Horse.WebModule.pas）を条件コンパイルで使用するが、LFMファイルはLazarus専用の設定となる。

**業務上の目的・背景**：HorseフレームワークをLazarus/FreePascal環境でCGI、FastCGI、Apacheモジュールとしてデプロイする際の基盤コンポーネントである。クロスプラットフォーム対応により、Linux/macOS環境でのWebアプリケーション開発が可能となる。FreePascalの fpWeb フレームワークと統合し、標準的なWebサーバーモジュール開発パターンを採用している。

**画面へのアクセス方法**：本コンポーネントはGUI画面を持たない。Webサーバーがリクエストを受け取ると、自動的にこのモジュールのDoOnRequestが呼び出され、HandlerActionに処理が委譲される。

**主要な操作・処理内容**：
1. HTTPリクエストの受信：fpWebフレームワーク経由でリクエストを受け取る
2. DoOnRequestでリクエストを処理
3. HandlerActionに処理を委譲
4. THorseRequestの生成：リクエスト情報をTHorseRequestオブジェクトにラップ
5. THorseResponseの生成：レスポンス用のTHorseResponseオブジェクトを作成
6. ルーティング実行：FHorse.Routes.Executeでルーティング処理を実行
7. 例外処理：EHorseCallbackInterrupted例外を適切に処理
8. リソース解放：リクエスト/レスポンスオブジェクトを解放

**画面遷移**：本コンポーネントは画面を持たないため、画面遷移は存在しない。

**権限による表示制御**：本コンポーネント自体には権限管理機能はない。権限制御はHorseミドルウェアで実装する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | リクエストボディ取得 | 主機能 | DoOnRequestでTHorseRequestを生成しリクエストボディを処理 |
| 17 | テキストレスポンス送信 | 主機能 | DoOnRequestでTHorseResponseを生成しレスポンスを処理 |
| 42 | 割り込み例外 | 補助機能 | EHorseCallbackInterrupted例外を捕捉してコールバックチェーンの中断を処理 |
| 52 | CGI プロバイダー | API連携 | CGIモードでHTTPリクエストを処理するためのWebモジュール（Lazarus版） |
| 56 | Lazarus対応 | 補助機能 | FPC条件コンパイルによりLazarus環境で動作 |

## 画面種別

Webモジュールコンポーネント（GUIなし）

## URL/ルーティング

- デフォルトアクション: なし（DoOnRequestでハンドリング）
- セッション作成: False
- ルーティング: Horseフレームワークのルーティングシステムに委譲

## 入出力項目

| 項目名 | 種類 | I/O | データ型 | 必須 | 初期値 | 説明 |
|--------|------|-----|----------|------|--------|------|
| ARequest | TRequest | 入力 | Object | はい | - | fpWebからのHTTPリクエスト |
| AResponse | TResponse | 出力 | Object | はい | - | fpWebへのHTTPレスポンス |
| AHandled | Boolean | 出力 | Boolean | はい | True | リクエスト処理完了フラグ |

## 表示項目

本コンポーネントはGUI表示項目を持たない。

## Webモジュールプロパティ（Lazarus版）

| プロパティ名 | 値 | 説明 |
|-------------|-----|------|
| OldCreateOrder | False | 旧式の作成順序を使用しない |
| Actions | （空） | アクションコレクション（空、DoOnRequestで処理） |
| CreateSession | False | セッション自動作成を無効化 |

## Delphiモジュールとの差異

| 項目 | Delphi版（No.7） | Lazarus版（No.8） |
|-----|-----------------|------------------|
| LFMファイル | Horse.WebModule.dfm | Horse.WebModule.lfm |
| 継承クラス | TWebModule | TFPWebModule |
| リクエスト型 | TWebRequest | TRequest |
| レスポンス型 | TWebResponse | TResponse |
| Actions設定 | DefaultHandler（PathInfo='/'） | 空（DoOnRequestで直接処理） |
| CreateSession | なし | False |
| エントリーポイント | HandlerActionイベント | DoOnRequestオーバーライド |
| モジュール登録 | WebModuleClass変数 | RegisterHTTPModule関数 |

## イベント仕様

### 1-DoOnRequest（HTTPリクエスト処理 - Lazarus/FPC専用）

**トリガー**: fpWebからHTTPリクエストを受信した時

**処理内容**:
1. HandlerAction(Self, ARequest, AResponse, AHandled) を呼び出して処理を委譲

**コード参照**: `Horse.WebModule.pas` 80-85行目

### 2-HandlerAction（HTTPリクエスト処理 - 共通）

**トリガー**: DoOnRequestから呼び出し

**処理内容**:
1. Handled := True を設定
2. THorseRequest.Create(Request) でリクエストオブジェクトを生成
3. THorseResponse.Create(Response) でレスポンスオブジェクトを生成
4. try-except ブロックで例外を捕捉
5. FHorse.Routes.Execute(LRequest, LResponse) でルーティングを実行
6. EHorseCallbackInterrupted 以外の例外は再スロー
7. finally ブロックでリソースを解放

**コード参照**: `Horse.WebModule.pas` 87-110行目

### 3-Create（コンストラクタ - Lazarus専用）

**トリガー**: Webモジュールインスタンス作成時

**処理内容**:
1. inherited CreateNew(AOwner, 0) で親クラスのコンストラクタを呼び出し（FPC用）
2. FHorse := THorseCore.GetInstance でHorseCoreインスタンスを取得
3. FInstance := Self でシングルトンインスタンスを設定

**コード参照**: `Horse.WebModule.pas` 69-78行目

### 4-initialization（モジュール登録 - Lazarus専用）

**トリガー**: ユニット初期化時

**処理内容**:
1. RegisterHTTPModule(THorseWebModule) でHTTPモジュールとしてシステムに登録

**コード参照**: `Horse.WebModule.pas` 112-115行目

## 処理フロー図

```
fpWeb (Lazarus/FPC Webフレームワーク)
    |
    v
[HTTPリクエスト受信]
    |
    v
THorseWebModule.DoOnRequest
    |
    +-- HandlerAction(Self, ARequest, AResponse, AHandled)
           |
           +-- Handled := True
           |
           +-- LRequest := THorseRequest.Create(Request)
           |
           +-- LResponse := THorseResponse.Create(Response)
           |
           +-- try
           |      |
           |      +-- FHorse.Routes.Execute(LRequest, LResponse)
           |             |
           |             +-- ルーティングマッチング
           |             |
           |             +-- ミドルウェア実行
           |             |
           |             +-- ハンドラ実行
           |
           +-- except
           |      |
           |      +-- EHorseCallbackInterrupted: 無視
           |      |
           |      +-- その他の例外: 再スロー
           |
           +-- finally
                  |
                  +-- LRequest.Free
                  |
                  +-- LResponse.Free
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | 本コンポーネント自体はデータベースアクセスを行わない |

### テーブル別更新項目詳細

本コンポーネントではデータベースを使用しない。データベースアクセスは登録されたルートハンドラ内で実装する。

## メッセージ仕様

本コンポーネント自体はメッセージを出力しない。メッセージはルートハンドラ内でレスポンスとして送信する。

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|---------|---------|
| EHorseCallbackInterrupted | コールバックチェーン中断時 | 例外を捕捉し、処理を正常終了として扱う |
| その他の例外 | ルートハンドラ内でのエラー | 例外を再スローし、fpWebのエラーハンドリングに委譲 |

## 備考

- Lazarus/FreePascal環境専用の設定ファイル（Horse.WebModule.lfm）を使用
- TFPWebModuleを継承し、fpWebフレームワークと統合
- DoOnRequestをオーバーライドして直接リクエストを処理
- Actions設定が空のため、すべてのリクエストをDoOnRequestで処理
- CreateSession=Falseにより、セッションの自動作成を無効化
- initializationセクションでRegisterHTTPModule(THorseWebModule)によりモジュール登録
- CGI/FastCGI/Apache モジュールとしてデプロイ可能

---

## コードリーディングガイド

本コンポーネントを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、fpWebのリクエスト/レスポンスとHorseのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | httpdefs.pas | FPC/Lazarus | TRequest, TResponseクラスの構造 |
| 1-2 | fpHTTP.pas | FPC/Lazarus | fpWebフレームワークの基本構造 |
| 1-3 | fpWeb.pas | FPC/Lazarus | TFPWebModuleクラスの構造 |
| 1-4 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequestクラス |
| 1-5 | Horse.Response.pas | `src/Horse.Response.pas` | THorseResponseクラス |

**読解のコツ**: fpWebはLazarus/FPCの標準Webフレームワーク。TRequest/TResponseはDelphiのTWebRequest/TWebResponseに相当する。

#### Step 2: エントリーポイントを理解する

LFMファイルとPASファイルのFPC条件コンパイル部分を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.WebModule.lfm | `src/Horse.WebModule.lfm` | Lazarus用モジュールプロパティ |
| 2-2 | Horse.WebModule.pas | `src/Horse.WebModule.pas` | FPC条件コンパイル部分に注目 |

**主要処理フロー（FPC部分）**:
1. **3-5行目**: `{$IF DEFINED(FPC)}` - FPCモードディレクティブ
2. **10-14行目**: FPC用uses句（Classes, httpdefs, fpHTTP, fpWeb）
3. **23行目**: TFPWebModule継承宣言
4. **24行目**: DoOnRequestオーバーライド宣言
5. **39-41行目**: FPC用グローバル変数（HorseWebModule）
6. **58-59行目**: FPC用リソースファイル指定（Horse.WebModule.lfm）
7. **71-72行目**: FPC用コンストラクタ（CreateNew）
8. **80-85行目**: DoOnRequest実装
9. **112-115行目**: FPC用initialization（RegisterHTTPModule）

#### Step 3: Delphiモジュールとの共通部分を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.WebModule.pas | `src/Horse.WebModule.pas` | HandlerAction（87-110行目） |

**主要処理フロー（共通部分）**:
- **87-110行目**: HandlerAction - Delphi/FPC共通のリクエスト処理

### プログラム呼び出し階層図

```
fpWeb (Lazarus/FPC)
    |
    +-- [initialization]
    |      +-- RegisterHTTPModule(THorseWebModule)
    |
    +-- HTTP Request Received
           |
           v
    THorseWebModule
           |
           +-- Create (コンストラクタ)
           |      +-- inherited CreateNew(AOwner, 0)
           |      +-- FHorse := THorseCore.GetInstance
           |      +-- FInstance := Self
           |
           +-- DoOnRequest (オーバーライド)
                  |
                  +-- HandlerAction(Self, ARequest, AResponse, AHandled)
                         |
                         +-- Handled := True
                         |
                         +-- THorseRequest.Create(Request)
                         |      +-- TRequestをラップ
                         |
                         +-- THorseResponse.Create(Response)
                         |      +-- TResponseをラップ
                         |
                         +-- FHorse.Routes.Execute(LRequest, LResponse)
                         |      |
                         |      +-- ルーティング処理
                         |
                         +-- リソース解放
```

### データフロー図

```
[入力]                       [処理]                          [出力]

TRequest (fpWeb) ----------> DoOnRequest -----------------> HandlerAction
                                   |
                                   v
                            THorseRequest.Create
                                   |
                                   v
                            FHorse.Routes.Execute
                                   |
                                   v
                            [ルートハンドラ実行]
                                   |
                                   v
TResponse (fpWeb) <--------- THorseResponse -------------- レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | Webモジュールの実装（Delphi/Lazarus共通） |
| Horse.WebModule.lfm | `src/Horse.WebModule.lfm` | 設定 | Lazarus用モジュールプロパティ |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | THorseCoreクラス |
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | THorseRequestクラス |
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | THorseResponseクラス |
| Horse.Exception.Interrupted.pas | `src/Horse.Exception.Interrupted.pas` | ソース | 中断例外クラス |
