---
generated_at: 2026-01-22 17:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-Windowsサービスメイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **デフォルトポート番号（9000）**：THorse.Listenのデフォルト値として推定、要確認
  2. **サービスインストール/アンインストールコマンド**：DPRファイルの確認推奨
  3. **ポート設定のカスタマイズ方法**：設定ファイルや引数の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `samples/delphi/winsvc/src/Main.Service.dfm` - サービスプロパティ定義
- E-02: `samples/delphi/winsvc/src/Main.Service.pas` - サービス実装コード
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サービス名がTMainServiceである | E-01 (1行目) | ○ |
| C-02 | DisplayNameが'MainService'である | E-01 (3行目) | ○ |
| C-03 | StartTypeがstManualである | E-01 (4行目) | ○ |
| C-04 | OnCreateイベントがServiceCreateである | E-01 (2行目) | ○ |
| C-05 | OnStartイベントがServiceStartである | E-01 (5行目) | ○ |
| C-06 | OnStopイベントがServiceStopである | E-01 (6行目) | ○ |
| C-07 | TServiceクラスを継承している | E-02 (9行目) | ○ |
| C-08 | Vcl.SvcMgrをusesしている | E-02 (6行目) | ○ |
| C-09 | Horseユニットをusesしている | E-02 (22行目) | ○ |
| C-10 | ServiceCreateで/pingを登録する | E-02 (36-43行目) | ○ |
| C-11 | /pingレスポンスが'pong'である | E-02 (41行目) | ○ |
| C-12 | ServiceStartでTHorse.Listenを呼ぶ | E-02 (47行目) | ○ |
| C-13 | ServiceStartでStarted := Trueを設定する | E-02 (48行目) | ○ |
| C-14 | ServiceStopでTHorse.StopListenを呼ぶ | E-02 (53行目) | ○ |
| C-15 | ServiceStopでStopped := Trueを設定する | E-02 (54行目) | ○ |
| C-16 | 関連機能にサーバー起動(No.26)が含まれる | E-05 (14行目) | ○ |
| C-17 | 関連機能にサーバー停止(No.27)が含まれる | E-05 (15行目) | ○ |
| C-18 | デフォルトポートが9000である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- THorse.Listenのデフォルトポート番号の確認
  - 候補：Horse.pas / Horse.Core.pas / ドキュメント
- サービスのインストール・アンインストールコマンドの確認
  - 候補：DPRファイル / 実行ファイルのコマンドラインオプション
- ポート番号をカスタマイズする方法
  - 候補：設定ファイル / コマンドライン引数 / ソースコード変更

## 5) リスクフラグ（レビュー観点）
- 0: サービスプロパティ（DFMファイルと完全一致）
- 0: イベントハンドラの実装（PASファイルで確認済み）
- 1: デフォルトポート番号（THorse.Listenの引数なし呼び出しのため推定値）
- 1: インストール/アンインストールコマンド（標準的なDelphiサービスの動作として推定）

## 6) レビュアーチェックリスト（最小）
- [ ] DFMファイル(E-01)とPASファイル(E-02)の内容が設計書の記述と一致しているか確認
- [ ] THorse.Listenのデフォルトポート番号を確認
- [ ] 画面機能マッピング(E-05)の機能Noが正しく参照されているか確認
- [ ] サービスのインストール・アンインストール方法を確認
- [ ] サービスの自動起動設定方法（stManualからstAutoへの変更）を必要に応じて追記
