---
generated_at: 2026-01-22 17:42:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：5-デーモンメイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **HORSE_DAEMONディレクティブの設定方法**：コード内コメントのみで具体的な設定方法の根拠なし
  2. **Linuxでの動作確認**：クロスプラットフォーム対応の実際の動作確認推奨
  3. **ポート番号のハードコード**：設定可能にすべきか検討

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `samples/lazarus/winsvc/daemonmain.lfm` - デーモンプロパティ定義
- E-02: `samples/lazarus/winsvc/daemonmain.pas` - デーモン実装コード
- E-03: `samples/lazarus/winsvc/daemonmanager.lfm` - デーモン設定定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デーモン名がTDaemon_Mainである | E-01 (1行目) | ○ |
| C-02 | OnCreateイベントがDataModuleCreateである | E-01 (2行目) | ○ |
| C-03 | OnStartイベントがDataModuleStartである | E-01 (4行目) | ○ |
| C-04 | OnShutDownイベントがDataModuleShutDownである | E-01 (5行目) | ○ |
| C-05 | OldCreateOrderがFalseである | E-01 (3行目) | ○ |
| C-06 | TDaemonクラスを継承している | E-02 (11行目) | ○ |
| C-07 | DaemonAppをusesしている | E-02 (8行目) | ○ |
| C-08 | Horseユニットをusesしている | E-02 (23行目) | ○ |
| C-09 | RegisterDaemonClass(TDaemon_Main)を呼び出す | E-02 (27行目) | ○ |
| C-10 | initializationでRegisterDaemonを呼び出す | E-02 (58-59行目) | ○ |
| C-11 | RunHorseでTHorse.Listen(9000)を呼び出す | E-02 (33行目) | ○ |
| C-12 | ポート番号が9000にハードコードされている | E-02 (33行目) | ○ |
| C-13 | Pingで'pong'をレスポンスする | E-02 (38行目) | ○ |
| C-14 | DataModuleCreateでTHorse.Get('ping', @Ping)を呼び出す | E-02 (45行目) | ○ |
| C-15 | DataModuleShutDownでTHorse.StopListenを呼び出す | E-02 (50行目) | ○ |
| C-16 | DataModuleStartでTThread.CreateAnonymousThreadを使用 | E-02 (55行目) | ○ |
| C-17 | デーモンマネージャーでDaemonClassName='TDaemon_Main'である | E-03 (4行目) | ○ |
| C-18 | デーモン名が'HorseService'である | E-03 (5行目) | ○ |
| C-19 | 表示名が'WinSrvHorse'である | E-03 (7行目) | ○ |
| C-20 | 関連機能にサーバー起動(No.26)が含まれる | E-05 (24行目) | ○ |
| C-21 | 関連機能にDaemonプロバイダー(No.55)が含まれる | E-05 (29行目) | ○ |
| C-22 | HORSE_DAEMONコンパイルディレクティブが必要 | E-02 (32行目コメント) | △ |

## 4) 不足情報（Unknown / Missing）
- HORSE_DAEMONコンパイルディレクティブの具体的な設定方法
  - 候補：プロジェクトファイル(.lpr) / コンパイラ設定 / README
- Linuxでのデーモン動作確認結果
  - 候補：テスト結果ドキュメント / CI/CDログ
- ポート番号を設定可能にする方法
  - 候補：設定ファイル / コマンドライン引数 / 環境変数

## 5) リスクフラグ（レビュー観点）
- 0: デーモンプロパティ（LFMファイルと完全一致）
- 0: イベントハンドラの実装（PASファイルで確認済み）
- 0: デーモンマネージャーの設定（LFMファイルで確認済み）
- 1: HORSE_DAEMONディレクティブの設定方法（コメントのみ）
- 1: ポート番号のハードコード（設定変更が困難）
- 1: 別スレッドでのサーバー起動（スレッド管理の確認推奨）

## 6) デーモン設定詳細（daemonmanager.lfm）

| 設定項目 | 値 | 説明 |
|---------|-----|------|
| DaemonClassName | TDaemon_Main | デーモンクラス名 |
| Name | HorseService | サービス内部名 |
| Description | Windows Service Horse | サービス説明 |
| DisplayName | WinSrvHorse | 表示名 |
| Options | doAllowStop, doAllowPause | 許可オプション |
| WinBindings.StartType | stBoot | 起動種別（ブート時） |
| WinBindings.ServiceType | stWin32 | サービス種別 |

## 7) レビュアーチェックリスト（最小）
- [ ] LFMファイル(E-01, E-03)とPASファイル(E-02)の内容が設計書の記述と一致しているか確認
- [ ] THorse.Listen(9000)の呼び出しが別スレッドで行われていることを確認
- [ ] 画面機能マッピング(E-05)の機能Noが正しく参照されているか確認
- [ ] HORSE_DAEMONディレクティブの設定方法について追加ドキュメントが必要か判断
- [ ] ポート番号を設定可能にする必要があるか検討
- [ ] Linuxでのデーモン動作をテストする必要があるか判断
