---
generated_at: 2026-01-22 17:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-デーモンマネージャー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **StartType=stBoot設定**：ブート時起動が意図通りか確認推奨
  2. **ErrorSeverity=esIgnore設定**：エラー時の動作確認推奨
  3. **Options設定**：doAllowPauseが必要か確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `samples/lazarus/winsvc/daemonmanager.lfm` - デーモン設定定義
- E-02: `samples/lazarus/winsvc/daemonmanager.pas` - マッパー実装コード
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マッパー名がTDaemon_Managerである | E-01 (1行目) | ○ |
| C-02 | DaemonClassNameが'TDaemon_Main'である | E-01 (4行目) | ○ |
| C-03 | Nameが'HorseService'である | E-01 (5行目) | ○ |
| C-04 | Descriptionが'Windows Service Horse'である | E-01 (6行目) | ○ |
| C-05 | DisplayNameが'WinSrvHorse'である | E-01 (7行目) | ○ |
| C-06 | Optionsに[doAllowStop, doAllowPause]が含まれる | E-01 (8行目) | ○ |
| C-07 | WinBindings.Dependenciesが空である | E-01 (9行目) | ○ |
| C-08 | WinBindings.StartTypeがstBootである | E-01 (10行目) | ○ |
| C-09 | WinBindings.WaitHintが0である | E-01 (11行目) | ○ |
| C-10 | WinBindings.IDTagが0である | E-01 (12行目) | ○ |
| C-11 | WinBindings.ServiceTypeがstWin32である | E-01 (13行目) | ○ |
| C-12 | WinBindings.ErrorSeverityがesIgnoreである | E-01 (14行目) | ○ |
| C-13 | WinBindings.AcceptedCodesが空である | E-01 (15行目) | ○ |
| C-14 | LogStatusReportがFalseである | E-01 (16行目) | ○ |
| C-15 | TDaemonMapperを継承している | E-02 (11行目) | ○ |
| C-16 | DaemonAppをusesしている | E-02 (8行目) | ○ |
| C-17 | RegisterDaemonMapper(TDaemon_Manager)を呼び出す | E-02 (21行目) | ○ |
| C-18 | 関連機能にDaemonプロバイダー(No.55)が含まれる | E-04 (31行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 本コンポーネントは設定のみで処理ロジックを持たないため、根拠なしの項目はない
- すべての設定値がLFMファイルで確認可能

## 5) リスクフラグ（レビュー観点）
- 0: デーモン設定（LFMファイルと完全一致）
- 0: マッパー登録処理（PASファイルで確認済み）
- 1: StartType=stBoot設定（本当にブート時起動が必要か確認推奨）
- 1: ErrorSeverity=esIgnore設定（エラー時に無視して良いか確認推奨）
- 1: doAllowPause設定（一時停止機能が必要か確認推奨）

## 6) デーモンマネージャーとデーモンメインの関係

```
TDaemon_Manager (設定担当)
    |
    +-- DaemonDefs
           |
           +-- DaemonClassName = 'TDaemon_Main' -------+
           |                                           |
           +-- Name = 'HorseService'                   |
           |                                           v
           +-- DisplayName = 'WinSrvHorse'      TDaemon_Main (処理担当)
           |                                           |
           +-- Options                                 +-- OnCreate
                                                       +-- OnStart
                                                       +-- OnShutDown
```

## 7) 設定値の妥当性チェック

| 設定 | 現在の値 | 確認事項 |
|-----|---------|---------|
| StartType | stBoot | システム起動時に自動起動するか確認。手動起動が望ましい場合はstManualに変更を検討 |
| ErrorSeverity | esIgnore | サービス起動エラー時に無視して良いか確認。重要なサービスの場合はesNormalを検討 |
| doAllowPause | 有効 | 一時停止機能が必要か確認。不要な場合はOptionsから削除を検討 |
| LogStatusReport | False | デバッグ時はTrueにすることを検討 |

## 8) レビュアーチェックリスト（最小）
- [ ] LFMファイル(E-01)とPASファイル(E-02)の内容が設計書の記述と一致しているか確認
- [ ] 画面機能マッピング(E-04)の機能Noが正しく参照されているか確認
- [ ] StartType=stBootが適切か確認（手動起動が望ましくないか）
- [ ] ErrorSeverity=esIgnoreが適切か確認（エラー時の動作）
- [ ] doAllowPauseが必要か確認（一時停止機能の要否）
- [ ] デーモンマネージャーとデーモンメインの連携が正しいか確認
