---
generated_at: 2026-01-22 17:48:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：7-Webモジュール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **ISAPIプロバイダーの具体的な使用方法**：コード内では参照のみで詳細なし
  2. **Apacheプロバイダーの具体的な使用方法**：コード内では参照のみで詳細なし
  3. **例外処理時のエラーレスポンス**：EHorseCallbackInterrupted以外の例外時の具体的な動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.WebModule.dfm` - Delphiモジュールプロパティ定義
- E-02: `src/Horse.WebModule.pas` - Webモジュール実装コード
- E-03: `src/Horse.WebModule.lfm` - Lazarusモジュールプロパティ定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モジュール名がTHorseWebModuleである | E-01 (1行目) | ○ |
| C-02 | Actions[0].Defaultが True である | E-01 (4行目) | ○ |
| C-03 | Actions[0].Nameが'DefaultHandler'である | E-01 (5行目) | ○ |
| C-04 | Actions[0].PathInfoが'/'である | E-01 (6行目) | ○ |
| C-05 | Actions[0].OnActionがHandlerActionである | E-01 (7行目) | ○ |
| C-06 | TWebModule(Delphi)/TFPWebModule(FPC)を継承している | E-02 (23, 26行目) | ○ |
| C-07 | FPCの場合DoOnRequestをオーバーライドしている | E-02 (24行目) | ○ |
| C-08 | HandlerActionでHandled:=Trueを設定する | E-02 (93行目) | ○ |
| C-09 | THorseRequest.Create(Request)を呼び出す | E-02 (94行目) | ○ |
| C-10 | THorseResponse.Create(Response)を呼び出す | E-02 (95行目) | ○ |
| C-11 | FHorse.Routes.Executeを呼び出す | E-02 (98行目) | ○ |
| C-12 | EHorseCallbackInterruptedを捕捉して無視する | E-02 (100-102行目) | ○ |
| C-13 | finallyでLRequest.FreeとLResponse.Freeを呼び出す | E-02 (107-108行目) | ○ |
| C-14 | CreateでTHorseCore.GetInstanceを呼び出す | E-02 (76行目) | ○ |
| C-15 | FInstanceにSelfを設定する | E-02 (77行目) | ○ |
| C-16 | GetInstanceでFInstanceを返す | E-02 (66行目) | ○ |
| C-17 | FPC initializationでRegisterHTTPModuleを呼び出す | E-02 (114行目) | ○ |
| C-18 | Horse.Requestをusesしている | E-02 (54行目) | ○ |
| C-19 | Horse.Responseをusesしている | E-02 (55行目) | ○ |
| C-20 | Horse.Exception.Interruptedをusesしている | E-02 (56行目) | ○ |
| C-21 | 関連機能にリクエストボディ取得(No.10)が含まれる | E-05 (33行目) | ○ |
| C-22 | ISAPIプロバイダーとして使用可能である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ISAPIプロバイダーとしての具体的な設定・使用方法
  - 候補：Horse.Provider.ISAPI.pas / サンプルコード / ドキュメント
- Apacheプロバイダーとしての具体的な設定・使用方法
  - 候補：Horse.Provider.Apache.pas / サンプルコード / ドキュメント
- EHorseCallbackInterrupted以外の例外時のエラーレスポンス形式
  - 候補：Webサーバー依存 / エラーハンドリングドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: モジュールプロパティ（DFMファイルと完全一致）
- 0: HandlerAction処理フロー（PASファイルで確認済み）
- 0: 条件コンパイル（FPC/Delphi対応）
- 1: ISAPIプロバイダーの詳細（使用方法の具体例なし）
- 1: Apacheプロバイダーの詳細（使用方法の具体例なし）
- 1: エラー時のレスポンス形式（Webサーバー依存の部分）

## 6) 条件コンパイルの詳細

| 条件 | Delphi | Lazarus/FPC |
|-----|--------|-------------|
| 継承クラス | TWebModule | TFPWebModule |
| リクエスト型 | TWebRequest | TRequest |
| レスポンス型 | TWebResponse | TResponse |
| リソースファイル | Horse.WebModule.dfm | Horse.WebModule.lfm |
| コンストラクタ | inherited | inherited CreateNew(AOwner, 0) |
| DoOnRequestオーバーライド | なし | あり |
| モジュール登録 | WebModuleClass設定 | RegisterHTTPModule |

## 7) レビュアーチェックリスト（最小）
- [ ] DFMファイル(E-01)とPASファイル(E-02)の内容が設計書の記述と一致しているか確認
- [ ] 画面機能マッピング(E-05)の機能Noが正しく参照されているか確認
- [ ] FPCとDelphiの条件コンパイルが正しく動作するか確認
- [ ] EHorseCallbackInterrupted例外の発生条件と動作を確認
- [ ] ISAPIプロバイダー、Apacheプロバイダーの使用方法について追加ドキュメントが必要か判断
- [ ] リクエストボディとレスポンスコンテンツの参照解除処理（105-106行目）の意図を確認
