---
generated_at: 2026-01-22 17:52:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：8-Webモジュール（Lazarus版）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **FastCGIプロバイダーの具体的な使用方法**：画面一覧にFastCGI言及あるが詳細なし
  2. **fpWebフレームワークとの統合詳細**：FPC固有の動作確認推奨
  3. **Delphi版との動作互換性**：条件コンパイルの正確性確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.WebModule.lfm` - Lazarusモジュールプロパティ定義
- E-02: `src/Horse.WebModule.pas` - Webモジュール実装コード
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モジュール名がTHorseWebModuleである | E-01 (1行目) | ○ |
| C-02 | OldCreateOrderがFalseである | E-01 (2行目) | ○ |
| C-03 | Actionsが空である | E-01 (3行目) | ○ |
| C-04 | CreateSessionがFalseである | E-01 (4行目) | ○ |
| C-05 | FPC条件コンパイルでTFPWebModuleを継承する | E-02 (23行目) | ○ |
| C-06 | FPC条件コンパイルでDoOnRequestをオーバーライドする | E-02 (24行目) | ○ |
| C-07 | FPC用usesにhttpdefs, fpHTTP, fpWebが含まれる | E-02 (11-14行目) | ○ |
| C-08 | FPC用グローバル変数HorseWebModuleが存在する | E-02 (40行目) | ○ |
| C-09 | FPCの場合CreateNewを呼び出す | E-02 (72行目) | ○ |
| C-10 | FPCの場合Horse.WebModule.lfmをリソース参照する | E-02 (59行目) | ○ |
| C-11 | DoOnRequestでHandlerActionを呼び出す | E-02 (83行目) | ○ |
| C-12 | initializationでRegisterHTTPModuleを呼び出す | E-02 (114行目) | ○ |
| C-13 | HandlerActionでHandled:=Trueを設定する | E-02 (93行目) | ○ |
| C-14 | THorseRequest.Create(Request)を呼び出す | E-02 (94行目) | ○ |
| C-15 | THorseResponse.Create(Response)を呼び出す | E-02 (95行目) | ○ |
| C-16 | FHorse.Routes.Executeを呼び出す | E-02 (98行目) | ○ |
| C-17 | EHorseCallbackInterruptedを捕捉して無視する | E-02 (100-102行目) | ○ |
| C-18 | 関連機能にリクエストボディ取得(No.10)が含まれる | E-04 (39行目) | ○ |
| C-19 | 関連機能にLazarus対応(No.56)が含まれる | E-04 (43行目) | ○ |
| C-20 | FastCGIプロバイダーとして使用可能である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- FastCGIプロバイダーとしての具体的な設定・使用方法
  - 候補：Horse.Provider.FastCGI.pas / サンプルコード / ドキュメント
- fpWebフレームワークとの統合詳細（TFPWebModuleの動作）
  - 候補：FPC/Lazarusドキュメント / fpWebサンプル
- Linux/macOSでのデプロイ手順
  - 候補：ビルドスクリプト / デプロイメントガイド

## 5) リスクフラグ（レビュー観点）
- 0: モジュールプロパティ（LFMファイルと完全一致）
- 0: FPC条件コンパイル（PASファイルで確認済み）
- 0: DoOnRequest実装（HandlerActionへの委譲）
- 1: FastCGIプロバイダーの詳細（使用方法の具体例なし）
- 1: Delphi版との動作互換性（条件コンパイルの正確性）
- 1: fpWebフレームワーク固有の動作（ドキュメント不足）

## 6) Delphi版との差異比較

| 項目 | Delphi版（No.7） | Lazarus版（No.8） | 確認状況 |
|-----|-----------------|------------------|---------|
| LFMファイル構造 | Actions設定あり | Actions設定なし | E-01で確認済み ○ |
| 継承クラス | TWebModule | TFPWebModule | E-02で確認済み ○ |
| エントリーポイント | HandlerAction | DoOnRequest | E-02で確認済み ○ |
| モジュール登録 | WebModuleClass | RegisterHTTPModule | E-02で確認済み ○ |
| コンストラクタ | inherited | CreateNew | E-02で確認済み ○ |

## 7) LFMファイル詳細

```
object HorseWebModule: THorseWebModule
  OldCreateOrder = False     # 旧式作成順序を無効化
  Actions = <>               # アクション空（DoOnRequestで処理）
  CreateSession = False      # セッション自動作成を無効化
  Height = 150               # デザイン時の高さ
  HorizontalOffset = 527     # デザイン時の水平オフセット
  VerticalOffset = 145       # デザイン時の垂直オフセット
  Width = 150                # デザイン時の幅
end
```

## 8) レビュアーチェックリスト（最小）
- [ ] LFMファイル(E-01)とPASファイル(E-02)の内容が設計書の記述と一致しているか確認
- [ ] 画面機能マッピング(E-04)の機能Noが正しく参照されているか確認
- [ ] FPC条件コンパイル部分が正しく動作するか確認
- [ ] DoOnRequest -> HandlerAction の呼び出しフローが正しいか確認
- [ ] FastCGIプロバイダーの使用方法について追加ドキュメントが必要か判断
- [ ] Delphi版との動作互換性を確認（同一のHandlerAction実装を使用）
- [ ] fpWebフレームワークとの統合が正しく機能するか確認
