---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 本プロジェクトは「Horse」というDelphi/Free Pascal向けWebフレームワークライブラリであり、一般的なアプリケーションのような通知機能（メール送信、プッシュ通知、SMS等）は実装されていません
  - 本一覧はシステム内部で使用される「通知的な機能」（ログ出力、HTTPレスポンス、例外メッセージ）を抽出したものです

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Provider.Daemon.pas` - Syslogを使用したシステムログ通知機能
- E-02: `src/ThirdParty.Posix.Syslog.pas` - Syslog関数のラッパー実装
- E-03: `src/Horse.Core.RouterTree.NextCaller.pas` - HTTPエラーレスポンス送信機能
- E-04: `src/Horse.Core.RouterTree.pas` - Not Foundレスポンス送信機能
- E-05: `src/Horse.Provider.Console.pas` - コンソール例外出力機能
- E-06: `src/Horse.Core.Param.Field.pas` - パラメータバリデーション例外機能
- E-07: `src/Horse.Core.Param.Config.pas` - パラメータエラーメッセージ設定
- E-08: `src/Horse.Exception.pas` - 例外クラス定義（TMessageType含む）
- E-09: `src/Horse.Commons.pas` - TMessageType列挙型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Syslog INFO通知：デーモン起動時にサーバー起動情報を記録 | E-01 (260行目) | ○ |
| C-02 | Syslog ERR通知：エラー発生時にエラー情報を記録 | E-01 (263行目, 271行目) | ○ |
| C-03 | Syslog NOTICE通知（リロード）：SIGHUPシグナルで設定リロード通知 | E-01 (103行目) | ○ |
| C-04 | Syslog NOTICE通知（停止）：デーモン停止時に停止通知 | E-01 (275行目) | ○ |
| C-05 | Internal Server Error通知：予期しない例外時に500エラー返却 | E-03 (109行目) | ○ |
| C-06 | Method Not Allowed通知：未サポートHTTPメソッドで405エラー返却 | E-03 (121行目) | ○ |
| C-07 | Not Found通知：パス未発見時に404エラー返却 | E-03 (124行目, 130行目), E-04 (158行目) | ○ |
| C-08 | Console例外通知：コンソールでの例外時に標準出力表示 | E-05 (227行目) | ○ |
| C-09 | パラメータ必須エラー通知：必須パラメータ不足時にBadRequest例外 | E-06 (218行目, 260行目, 274行目, 283行目) | ○ |
| C-10 | パラメータ形式エラー通知：形式不正時にBadRequest例外 | E-06 (117行目, 135行目, 157行目, 172行目, 187行目, 200行目, 300行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 本プロジェクトには一般的なアプリケーション通知機能（メール、プッシュ通知、SMS、Webhook等）は実装されていません
  - 理由：Horseはフレームワークライブラリであり、通知機能はアプリケーション側で実装する設計
  - 候補：なし（設計上の意図的な欠落）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての通知項目はソースコードから直接抽出されており、根拠が明確
- 注意点：本一覧は「通知機能」の一般的な定義（外部への能動的通知）とは異なり、システム内部のログ/レスポンス/例外を「通知」として解釈したものです

## 6) レビュアーチェックリスト（最小）
- [ ] 「通知」の定義がプロジェクトの意図と一致しているか確認
- [ ] Syslog関連の通知が実際のPOSIX環境で動作することを確認（HORSE_DAEMONコンパイル指令が必要）
- [ ] HTTPレスポンス通知のステータスコードが適切か確認
- [ ] 例外メッセージの多言語対応要否を確認（現在は英語固定）
