# 通知設計書 10-パラメータ形式エラー通知

## 概要

本ドキュメントは、Horse Webフレームワークにおけるパラメータ形式エラー通知機能の設計を記述する。パラメータの形式が不正な場合にBadRequest例外を発生させる通知機能である。

### 本通知の処理概要

本通知は、HTTPリクエストのパラメータ値を特定の型（Integer、Float、Date、DateTime等）に変換しようとした際に、形式が不正で変換に失敗した場合に、EHorseException（HTTP 400 Bad Request）を発生させる機能を提供する。

**業務上の目的・背景**：Web APIにおいて、パラメータの型検証はリクエストの妥当性を確保するための基本要件である。この通知により、クライアントアプリケーションは不正な形式のパラメータを特定でき、正しいフォーマットでリクエストを再構成できる。具体的な型情報（integer、numeric、date等）を含むエラーメッセージにより、開発者のデバッグ効率が向上する。

**通知の送信タイミング**：THorseCoreParamFieldクラスの型変換メソッド（AsInteger、AsFloat、AsDate、AsDateTime、AsTime、AsISO8601DateTime、AsInt64等）が呼ばれた際に、文字列から目的の型への変換に失敗した場合に発生する。

**通知の受信者**：HTTPリクエストを送信したクライアント（Webブラウザ、モバイルアプリ、他のサービス等）。例外がキャッチされてHTTPレスポンスに変換される。

**通知内容の概要**：カスタマイズ可能なエラーメッセージが含まれ、HTTPステータスコード400 Bad Requestと共に返却される。デフォルトではパラメータ名、送信された値、期待される型を含むメッセージが生成される。

**期待されるアクション**：クライアントはパラメータ形式のエラーを検知し、エラーメッセージからどのパラメータがどのような型であるべきかを特定して、正しい形式でリクエストを再送する。

## 通知種別

例外メッセージ（EHorseException） - HTTP 400 Bad Request

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（例外発生） |
| 優先度 | 即時 |
| リトライ | 無し（クライアント側で判断） |

### 送信先決定ロジック

EHorseExceptionが発生し、上位のエラーハンドラでキャッチされてHTTPレスポンスに変換される。送信先はHTTPリクエスト元のクライアントに自動的に決定される。

## 通知テンプレート

### HTTPレスポンスの場合

| 項目 | 内容 |
|-----|------|
| HTTPステータスコード | 400 |
| ステータスメッセージ | Bad Request |
| Content-Type | application/json (EHorseException.ToJSON使用時) |
| 形式 | テキストまたはJSON |

### 本文テンプレート

```
{InvalidFormatMessage}
```

プレースホルダー:
- `%s` (1番目): パラメータ名（FFieldName）
- `%s` (2番目): 送信された値（LStrParam）
- `%s` (3番目): 期待される型（'integer', 'numeric', 'date', 'datetime', 'time', 'int64', 'ISO8601 date'）

デフォルトメッセージ例：
```
The parameter 'age' with value 'abc' is not a valid integer
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | HTTPレスポンスボディのみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| FFieldName | パラメータ名 | THorseCoreParamField.FFieldName | Yes |
| LStrParam | 送信されたパラメータ値 | Trim(AsString)の結果 | Yes |
| type | 期待される型名 | 各変換メソッドで固定 | Yes |
| FInvalidFormatMessage | カスタムエラーメッセージ | THorseCoreParamField.FInvalidFormatMessage | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 整数変換失敗 | AsInteger呼び出し | EConvertError発生 | 文字列→Integer変換失敗 |
| 浮動小数点変換失敗 | AsFloat/AsCurrency/AsExtended呼び出し | EConvertError発生 | 文字列→Double変換失敗 |
| 日付変換失敗 | AsDate呼び出し | EConvertError発生 | 文字列→TDateTime(日付)変換失敗 |
| 日時変換失敗 | AsDateTime呼び出し | EConvertError発生 | 文字列→TDateTime変換失敗 |
| 時刻変換失敗 | AsTime呼び出し | EConvertError発生 | 文字列→TTime変換失敗 |
| Int64変換失敗 | AsInt64呼び出し | EConvertError発生 | 文字列→Int64変換失敗 |
| ISO8601変換失敗 | AsISO8601DateTime呼び出し | TryISO8601ToDate失敗 | ISO8601形式→TDateTime変換失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 変換成功 | 型変換が正常に完了した場合は例外は発生しない |
| 空文字列 | パラメータ値が空の場合は変換をスキップしデフォルト値を返す |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[型変換メソッド呼び出し] --> B{パラメータ値が空?}
    B -->|空| C[デフォルト値を返却]
    B -->|非空| D[型変換を試行]
    D --> E{変換成功?}
    E -->|成功| F[変換結果を返却]
    E -->|失敗 EConvertError| G[RaiseHorseException呼び出し]
    G --> H[EHorseException生成]
    H --> I[Status: BadRequest設定]
    I --> J[Error: FInvalidFormatMessage設定]
    J --> K[例外をthrow]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 本通知はデータベースを使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知はデータベースを更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 整数形式エラー | '123abc' → Integer | 400レスポンスを返却（type: 'integer'） |
| 数値形式エラー | 'abc' → Float | 400レスポンスを返却（type: 'numeric'） |
| 日付形式エラー | '2024-13-45' → Date | 400レスポンスを返却（type: 'date'） |
| 日時形式エラー | 不正な日時文字列 → DateTime | 400レスポンスを返却（type: 'datetime'） |
| 時刻形式エラー | '25:00:00' → Time | 400レスポンスを返却（type: 'time'） |
| Int64形式エラー | 'abc' → Int64 | 400レスポンスを返却（type: 'int64'） |
| ISO8601形式エラー | 不正なISO8601文字列 | 400レスポンスを返却（type: 'ISO8601 date'） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | サーバー側では行わない（クライアント側で判断） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

パラメータ変換時に即座に発生する。時間帯の制限はない。

## セキュリティ考慮事項

- エラーメッセージに送信された値が含まれるため、ログや画面表示時に機密情報が露出する可能性がある
- カスタムメッセージ（FInvalidFormatMessage）の設定により詳細度を調整可能
- 大量の形式エラーリクエストは攻撃の可能性があるため、監視が推奨される

## 備考

- `InvalidFormatMessage()`メソッドでカスタムエラーメッセージを設定可能
- 各変換メソッドで期待される型名は固定文字列として設定されている
- EConvertErrorはDelphi標準の変換エラー例外クラス
- 空文字列の場合は変換をスキップしてデフォルト値（0、0.0等）を返す設計

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パラメータフィールドクラスと形式エラーメッセージの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | FInvalidFormatMessageフィールド（行29） |
| 1-2 | Horse.Exception.pas | `src/Horse.Exception.pas` | EHorseExceptionクラス定義 |

**読解のコツ**: FInvalidFormatMessageはFormat関数のテンプレートとして使用され、3つのプレースホルダー（%s）を持つことが想定される。

#### Step 2: エントリーポイントを理解する

各型変換メソッドの処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | AsIntegerメソッド（行176-189）が代表的な例 |

**主要処理フロー（AsInteger）**:
1. **行176**: `function THorseCoreParamField.AsInteger: Integer;`
2. **行182**: `LStrParam := Trim(AsString)` - 値の取得とトリム
3. **行184**: `if LStrParam <> EmptyStr then Result := StrToInt(LStrParam)` - 変換試行
4. **行186-188**: `on E: EConvertError do` - 変換エラーのキャッチ
5. **行187**: `RaiseHorseException(FInvalidFormatMessage, [FFieldName, LStrParam, 'integer'])` - **ここが形式エラー通知の送信箇所**

#### Step 3: 各型変換メソッドの型名を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | 各変換メソッドで使用される型名 |

**各メソッドの型名**:
| メソッド | 型名文字列 | 行番号 |
|---------|----------|--------|
| AsInteger | 'integer' | 行187 |
| AsFloat | 'numeric' | 行157 |
| AsDate | 'date' | 行117 |
| AsDateTime | 'datetime' | 行135 |
| AsTime | 'time' | 行300 |
| AsInt64 | 'int64' | 行172 |
| AsISO8601DateTime | 'ISO8601 date' | 行200 |

### プログラム呼び出し階層図

```
[ユーザーコード]
    │
    └─ Request.Query['age'].AsInteger
           │
           └─ THorseCoreParamField.AsInteger (行176)
                  │
                  ├─ LStrParam := Trim(AsString) (行182)
                  │
                  ├─ try (行183)
                  │      │
                  │      └─ Result := StrToInt(LStrParam) (行184)
                  │             │
                  │             └─ [EConvertError発生!]
                  │
                  └─ except on E: EConvertError do (行186)
                         │
                         └─ RaiseHorseException(FInvalidFormatMessage,
                                [FFieldName, LStrParam, 'integer'])
                                (行187)
                                │
                                └─ RaiseHorseException(Format(...))
                                       │
                                       └─ EHorseException.New
                                              .Status(THTTPStatus.BadRequest)
                                              .Error(formattedMessage)
                                              │
                                              └─ raise LException
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Request.Query       ───▶ THorseCoreParamField         ───▶ EHorseException
['age']='abc'              │                                 Status: 400
.AsInteger                 │                                 Error: "{message}"
                           ▼
                    LStrParam := Trim(AsString)
                    'abc'
                           │
                           ▼
                    StrToInt('abc')
                           │
                           ▼
                    [EConvertError発生]
                           │
                           ▼
                    Format(FInvalidFormatMessage,
                           [FFieldName, LStrParam, 'integer'])
                           │
                           ▼
                    "The parameter 'age' with value 'abc'
                     is not a valid integer"
                           │
                           ▼
                    EHorseException.New
                    .Status(THTTPStatus.BadRequest)
                    .Error(message)
                           │
                           ▼
                    raise LException
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | ソース | パラメータフィールドクラス、形式エラー通知の送信元 |
| Horse.Exception.pas | `src/Horse.Exception.pas` | ソース | EHorseException例外クラス定義 |
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | THTTPStatus列挙型、BadRequest = 400 |
| Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | ソース | パラメータ管理クラス |
