# 通知設計書 8-Console例外通知

## 概要

本ドキュメントは、Horse WebフレームワークのConsoleプロバイダーにおける例外通知機能の設計を記述する。コンソールアプリケーションで例外が発生した場合に標準出力へエラーメッセージを表示する通知機能である。

### 本通知の処理概要

本通知は、コンソールアプリケーションとしてHorseサーバーを起動する際に例外が発生した場合に、標準出力（コンソール）にエラー情報を表示する機能を提供する。

**業務上の目的・背景**：開発環境やデバッグ時にコンソールアプリケーションとしてWebサーバーを起動することは一般的である。この通知により、開発者はサーバー起動失敗や実行時エラーの詳細を即座にコンソールで確認でき、問題の迅速な特定と解決が可能となる。GUIを持たないコンソール環境では、標準出力がユーザーへの主要なフィードバック手段となる。

**通知の送信タイミング**：Consoleプロバイダーの起動処理（InternalListenメソッド）内で例外が発生した場合に送信される。具体的には、HTTPサーバーの設定、バインディング、起動処理中にエラーが発生した時点で実行される。

**通知の受信者**：コンソールアプリケーションを実行している開発者やオペレーター。標準出力を監視しているターミナル、ログ収集システム。

**通知内容の概要**：例外のクラス名とエラーメッセージがコンソールに出力される。形式は「{ExceptionClassName}: {ExceptionMessage}」である。

**期待されるアクション**：開発者はエラー内容を確認し、設定の修正やコードの修正を行う。例外クラス名とメッセージから問題の原因を特定する。

## 通知種別

コンソール出力（標準出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Writeln） |
| 優先度 | 即時 |
| リトライ | 無し |

### 送信先決定ロジック

Pascal標準のWriteln手続きにより、標準出力に直接出力される。出力先はプロセスの標準出力ストリームであり、通常はターミナル/コンソールウィンドウに表示される。

## 通知テンプレート

### コンソール出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | 標準出力（stdout） |
| 形式 | テキスト |
| 文字コード | システムデフォルト |

### 本文テンプレート

```
{ExceptionClassName}: {ExceptionMessage}
```

実際の出力例：
```
EIdSocketError: Connection refused
EIdCouldNotBindSocket: Could not bind socket. Address and port are already in use.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | コンソール出力のみ |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| E.ClassName | 例外クラス名 | Exception.ClassName | Yes |
| E.Message | 例外メッセージ | Exception.Message | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 起動エラー | InternalListenメソッドのtry-except | IsConsole = True かつ 例外発生 | コンソールモードでの起動処理エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| IsConsole = False | GUIアプリケーションの場合は表示されず、例外が再throwされる |
| 非Consoleプロバイダー | Daemon/VCL等の他プロバイダーでは本コードは実行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[InternalListen呼び出し] --> B[HTTPサーバー設定]
    B --> C[StartListening実行]
    C --> D{例外発生?}
    D -->|発生| E{IsConsole?}
    E -->|True| F[Writelnでコンソール出力]
    F --> G[E.ClassName + ': ' + E.Message]
    G --> H[Readで入力待ち]
    H --> I[終了]
    E -->|False| J[例外を再throw]
    D -->|なし| K[正常動作継続]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 本通知はデータベースを使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知はデータベースを更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ソケットエラー | ポートが既に使用中 | エラーメッセージを表示し入力待ち |
| バインドエラー | アドレス/ポートのバインド失敗 | エラーメッセージを表示し入力待ち |
| SSL設定エラー | 証明書ファイル不正 | エラーメッセージを表示し入力待ち |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

例外発生時に即座に出力される。時間帯の制限はない。

## セキュリティ考慮事項

- 例外クラス名とメッセージがコンソールに表示されるため、機密情報を含む可能性がある例外メッセージには注意が必要
- 開発/デバッグ環境での使用を想定しており、本番環境ではDaemonプロバイダー等の使用が推奨される
- Read手続きによる入力待ちがあるため、無人運用環境では注意が必要

## 備考

- `IsConsole`システム変数がTrueの場合のみコンソール出力が行われる
- GUIアプリケーション（IsConsole = False）の場合は例外が再throwされる
- Delphi 10.2（CompilerVersion >= 32.0）以降とそれ以前でraiseの方法が異なる
- 出力後にRead(LAttach)で入力待ちとなり、ユーザーが確認できるようになっている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

例外クラスとコンソールモード判定の仕組みを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | IsConsole変数の使用（行217、225） |

**読解のコツ**: `IsConsole`はDelphiのシステム変数で、アプリケーションがコンソールアプリケーションとしてコンパイルされた場合にTrueになる。

#### Step 2: エントリーポイントを理解する

例外処理とコンソール出力の流れを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | InternalListenメソッド（行174-238）の例外処理部分 |

**主要処理フロー**:
1. **行188**: try開始（HTTPサーバー設定処理）
2. **行213**: StartListening実行
3. **行214**: FRunning := True
4. **行222-237**: except句での例外処理
5. **行223-229**: IsConsole = True の場合
   - **行225**: `Writeln(E.ClassName, ': ', E.Message)` - **ここがConsole例外通知の送信箇所**
   - **行226-228**: Read(LAttach)で入力待ち
6. **行230-235**: IsConsole = False の場合
   - 例外を再throw

#### Step 3: コンパイラバージョン分岐を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | コンパイラバージョンによる分岐（行231-235） |

**コンパイラバージョン分岐の詳細**:
```pascal
{$IF CompilerVersion >= 32.0}
  raise AcquireExceptionObject;
{$ELSE}
  raise;
{$ENDIF}
```
- Delphi 10.2 Tokyo（CompilerVersion 32.0）以降では`AcquireExceptionObject`を使用
- それ以前のバージョンでは`raise`を使用

### プログラム呼び出し階層図

```
THorseProvider.Listen (public)
    │
    └─ THorseProvider.InternalListen (private, 行174)
           │
           ├─ GetDefaultHTTPWebBroker (行186)
           │
           ├─ WebRequestHandler.WebModuleClass := ... (行187)
           │
           ├─ try (行188)
           │      │
           │      ├─ 各種設定処理 (行189-211)
           │      │
           │      ├─ LIdHTTPWebBrokerBridge.StartListening (行213)
           │      │
           │      └─ [例外発生!]
           │
           └─ except on E: Exception do (行222)
                  │
                  ├─ if IsConsole then (行223-229)
                  │      │
                  │      ├─ Writeln(E.ClassName, ': ', E.Message) (行227)
                  │      │      │
                  │      │      └─ 標準出力へ出力
                  │      │
                  │      └─ Read(LAttach) (行228) - 入力待ち
                  │
                  └─ else (行230-235)
                         │
                         └─ raise / AcquireExceptionObject
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Exception発生      ───┬──▶ IsConsole判定               ───▶ 標準出力
                      │           │                          (コンソール)
                      │           ▼
                      │    [IsConsole = True]
                      │           │
                      │           ▼
                      │    E.ClassName取得
                      │           │
                      │           ▼
                      │    E.Message取得
                      │           │
                      │           ▼
                      │    Writeln(E.ClassName, ': ', E.Message)
                      │           │
                      │           ▼
                      │    "EIdSocketError: Connection refused"
                      │           │
                      └───────────▼
                           Read(LAttach) - 入力待ち
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | ソース | Consoleプロバイダーのメイン実装、Console例外通知の送信元 |
| Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | ソース | プロバイダー基底クラス |
| Horse.Constants.pas | `src/Horse.Constants.pas` | ソース | DEFAULT_HOST/PORT定数定義 |
