---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-パラメータ形式エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.Param.Field.pas` 行187 - RaiseHorseException(FInvalidFormatMessage, [FFieldName, LStrParam, 'integer'])
- E-02: `src/Horse.Core.Param.Field.pas` 行157 - RaiseHorseException(FInvalidFormatMessage, [FFieldName, LStrParam, 'numeric'])
- E-03: `src/Horse.Core.Param.Field.pas` 行117 - RaiseHorseException(FInvalidFormatMessage, [FFieldName, LStrParam, 'date'])
- E-04: `src/Horse.Core.Param.Field.pas` 行135 - RaiseHorseException(FInvalidFormatMessage, [FFieldName, LStrParam, 'datetime'])
- E-05: `src/Horse.Core.Param.Field.pas` 行300 - RaiseHorseException(FInvalidFormatMessage, [FFieldName, LStrParam, 'time'])
- E-06: `src/Horse.Core.Param.Field.pas` 行172 - RaiseHorseException(FInvalidFormatMessage, [FFieldName, LStrParam, 'int64'])
- E-07: `src/Horse.Core.Param.Field.pas` 行200 - RaiseHorseException(FInvalidFormatMessage, [FFieldName, LStrParam, 'ISO8601 date'])
- E-08: `src/Horse.Core.Param.Field.pas` 行29 - FInvalidFormatMessage: string
- E-09: `src/Horse.Core.Param.Field.pas` 行186 - on E: EConvertError do
- E-10: `src/Horse.Core.Param.Field.pas` 行380-384 - function InvalidFormatMessage(const AValue: string)
- E-11: `src/Horse.Core.Param.Field.pas` 行395 - EHorseException.New.Status(THTTPStatus.BadRequest).Error(AMessage)
- E-12: `src/Horse.Commons.pas` 行46 - BadRequest = 400

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AsIntegerで'integer'型名が使用される | E-01 | ○ |
| C-02 | AsFloatで'numeric'型名が使用される | E-02 | ○ |
| C-03 | AsDateで'date'型名が使用される | E-03 | ○ |
| C-04 | AsDateTimeで'datetime'型名が使用される | E-04 | ○ |
| C-05 | AsTimeで'time'型名が使用される | E-05 | ○ |
| C-06 | AsInt64で'int64'型名が使用される | E-06 | ○ |
| C-07 | AsISO8601DateTimeで'ISO8601 date'型名が使用される | E-07 | ○ |
| C-08 | FInvalidFormatMessageがエラーメッセージテンプレート | E-08 | ○ |
| C-09 | EConvertErrorが変換エラーのトリガー | E-09 | ○ |
| C-10 | InvalidFormatMessage()でカスタムメッセージ設定可能 | E-10 | ○ |
| C-11 | HTTPステータス400 Bad Requestが設定される | E-11, E-12 | ○ |
| C-12 | Format関数で3つのプレースホルダーが使用される | E-01 | ○ |
| C-13 | FFieldNameがプレースホルダー1に使用される | E-01 | ○ |
| C-14 | LStrParamがプレースホルダー2に使用される | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
- すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 各変換メソッドでRaiseHorseExceptionが呼ばれていることを確認
- [ ] 各メソッドで使用される型名文字列を確認
- [ ] EConvertErrorのキャッチ処理を確認
