---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-パラメータ必須エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.Param.Field.pas` 行283 - RaiseHorseException(FRequiredMessage, [FFieldName])
- E-02: `src/Horse.Core.Param.Field.pas` 行391-398 - RaiseHorseException(const AMessage: string)
- E-03: `src/Horse.Core.Param.Field.pas` 行395 - EHorseException.New.Status(THTTPStatus.BadRequest).Error(AMessage)
- E-04: `src/Horse.Core.Param.Field.pas` 行27 - FRequired: Boolean
- E-05: `src/Horse.Core.Param.Field.pas` 行25 - FContains: Boolean
- E-06: `src/Horse.Core.Param.Field.pas` 行28 - FRequiredMessage: string
- E-07: `src/Horse.Core.Param.Field.pas` 行26 - FFieldName: string
- E-08: `src/Horse.Core.Param.Field.pas` 行406-410 - function Required: THorseCoreParamField
- E-09: `src/Horse.Core.Param.Field.pas` 行412-416 - function RequiredMessage(const AValue: string)
- E-10: `src/Horse.Core.Param.Field.pas` 行277-284 - function AsString: string
- E-11: `src/Horse.Commons.pas` 行46 - BadRequest = 400

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RaiseHorseExceptionでEHorseExceptionが発生 | E-01, E-02 | ○ |
| C-02 | HTTPステータス400 Bad Requestが設定される | E-03, E-11 | ○ |
| C-03 | FRequiredMessageがエラーメッセージに使用される | E-01, E-06 | ○ |
| C-04 | FFieldNameがプレースホルダーに使用される | E-01, E-07 | ○ |
| C-05 | FRequired = True の場合のみ例外発生 | E-04, E-10 | ○ |
| C-06 | FContains = False の場合のみ例外発生 | E-05, E-10 | ○ |
| C-07 | Required()メソッドでFRequired = Trueに設定 | E-08 | ○ |
| C-08 | RequiredMessage()でカスタムメッセージ設定可能 | E-09 | ○ |
| C-09 | AsStringが代表的なエントリーポイント | E-10 | ○ |
| C-10 | Format関数で引数が置換される | E-01 | ○ |
| C-11 | EHorseException.NewでインスタンスChain可能 | E-03 | ○ |
| C-12 | THTTPStatus.BadRequestの値は400 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
- すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] `Horse.Core.Param.Field.pas`の行283でRaiseHorseExceptionが呼ばれていることを確認
- [ ] 行395でEHorseException.New.Status(BadRequest)が設定されていることを確認
- [ ] FRequiredとFContainsの条件が正しいことを確認
