---
generated_at: 2026-01-22 18:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **サポートへの連絡方法**：GitHub URLは推測
  2. **FastCGI対応**：Lazarus固有機能の詳細確認が必要
  3. **本番環境推奨事項**：セキュリティ推奨事項の妥当性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要・技術スタック
- E-02: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件55件
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧56件
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧8件
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応43件
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-07: `docs/code-to-docs/画面設計書/1-VCLメインフォーム.md` - VCLメインフォーム設計書
- E-08: `docs/code-to-docs/画面設計書/2-VCL-SSLメインフォーム.md` - SSL対応VCLフォーム設計書

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HorseはNode.jsのExpressにインスパイアされた軽量Webフレームワーク | E-01 | ○ |
| C-02 | GET/POST/PUT/DELETE/PATCH/HEAD等のHTTPメソッドに対応 | E-02 (BR-001) | ○ |
| C-03 | Use()メソッドによるミドルウェアチェーンの構築が可能 | E-02 (BR-005, BR-006, BR-007) | ○ |
| C-04 | ヘッダー、クエリパラメータ、パスパラメータ、Cookie、フォームデータの取得が可能 | E-02 (BR-009〜BR-014), E-03 (11〜15) | ○ |
| C-05 | OpenSSLを使用したHTTPS通信をサポート | E-02 (BR-032〜BR-034), E-03 (31) | ○ |
| C-06 | Console/VCL/CGI/ISAPI/Apache/Daemon等の複数プロバイダーに対応 | E-02 (BR-050), E-03 (50〜56) | ○ |
| C-07 | Delphi XE7以降およびLazarus/Free Pascalに対応 | E-01 | ○ |
| C-08 | Bossパッケージマネージャーでのインストールが可能 | E-01 | ○ |
| C-09 | VCLメインフォームでポート入力、Start/Stopボタンが使用可能 | E-04 (No.1), E-07 | ○ |
| C-10 | デフォルトポートは9000 | E-07, E-08 | ○ |
| C-11 | THorse.Getメソッドでルーティングを登録 | E-02 (BR-001), E-03 (1), E-07 | ○ |
| C-12 | THorse.Listenでサーバーを起動 | E-02 (BR-026), E-03 (26), E-05 | ○ |
| C-13 | THorse.StopListenでサーバーを停止 | E-02 (BR-027), E-03 (27), E-05 | ○ |
| C-14 | パスパラメータは:paramName形式で定義 | E-02 (BR-002, BR-010), E-03 (35) | ○ |
| C-15 | Req.Queryでクエリパラメータを取得 | E-02 (BR-009), E-03 (11) | ○ |
| C-16 | Req.Paramsでパスパラメータを取得 | E-02 (BR-010), E-03 (12) | ○ |
| C-17 | Req.Headersでヘッダーを取得 | E-02 (BR-011), E-03 (13) | ○ |
| C-18 | Req.Bodyでリクエストボディを取得 | E-02 (BR-008), E-03 (10) | ○ |
| C-19 | Req.Cookieでクッキーを取得 | E-02 (BR-012), E-03 (14) | ○ |
| C-20 | Res.Sendでテキストレスポンスを送信 | E-02 (BR-016), E-03 (17), E-05 | ○ |
| C-21 | Res.StatusでHTTPステータスコードを設定 | E-02 (BR-018), E-03 (18) | ○ |
| C-22 | Res.AddHeaderでヘッダーを追加 | E-02 (BR-019), E-03 (23) | ○ |
| C-23 | Res.ContentTypeでContent-Typeを設定 | E-02 (BR-025), E-03 (25) | ○ |
| C-24 | Res.RedirectToでリダイレクト | E-02 (BR-021), E-03 (22) | ○ |
| C-25 | Res.SendFileでファイルをインライン表示 | E-02 (BR-022), E-03 (19) | ○ |
| C-26 | Res.Downloadでファイルをダウンロード | E-02 (BR-023), E-03 (20) | ○ |
| C-27 | SSL設定はIOHandleSSLで行う | E-02 (BR-032〜BR-034), E-08 | ○ |
| C-28 | SSL使用時はlibeay32.dllとssleay32.dllが必要 | E-08 | ○ |
| C-29 | 自己署名証明書の生成コマンドが正しい | E-08 | ○ |
| C-30 | THorse.IsRunningで起動状態を確認可能 | E-02 (BR-028), E-07 | ○ |
| C-31 | MaxConnectionsで最大接続数を設定可能 | E-02 (BR-029), E-03 (30) | ○ |
| C-32 | KeepConnectionAliveでKeep-Aliveを設定可能 | E-02 (BR-031) | ○ |
| C-33 | サポートはGitHub Issuesで受け付け | **根拠なし** | △ |
| C-34 | HORSE_FCGIはLazarusのみ対応 | E-01 | △ |
| C-35 | 本番環境ではLet's Encrypt等の正規証明書を推奨 | E-08 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-33 サポートへの連絡方法**: GitHubリポジトリのURLは「https://github.com/hashload/horse」と推測していますが、本プロジェクト内に明示的な記載がありませんでした。
  - 候補：README.md / CONTRIBUTING.md / LICENSE ファイルの確認
- **C-34 FastCGI対応**: README.mdにFastCGIの記載がありますが、HORSE_FCGIディレクティブの詳細な動作確認は未実施です。
  - 候補：samples/lazarus/fastcgi/ の実装確認
- **C-35 セキュリティ推奨事項**: 本番環境でのセキュリティ推奨事項は一般的なベストプラクティスに基づいていますが、Horse固有の推奨事項はドキュメント化されていません。
  - 候補：セキュリティガイドライン / 本番環境設定ガイド

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - システム概要、基本機能の説明（C-01〜C-10）
- **0: 低リスク** - ルーティング、リクエスト処理、レスポンス生成の説明（C-11〜C-26）
- **1: 中リスク** - SSL/TLS設定の説明（C-27〜C-29）：OpenSSL設定は環境依存が大きい
- **1: 中リスク** - プロバイダー固有の機能（C-34）：Lazarus環境での動作確認が必要
- **2: 高リスク** - サポート連絡先（C-33）：外部URLの正確性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] サポートへの連絡先（GitHub Issues URL）が正しいか確認
- [ ] SSL/TLS設定手順が実際のOpenSSL環境と整合しているか確認
- [ ] 各プロバイダー（VCL/LCL/CGI/ISAPI/Apache/Daemon）の説明が最新バージョンと整合しているか確認
- [ ] コード例が実際にコンパイル・動作するか確認（特にLazarus環境）
- [ ] 業務フロー（STEP1〜5）の流れがエンドユーザーにとって理解しやすいか確認
