---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 33
  claims_with_evidence: 27
  claims_without_evidence: 6
confidence_derived: 0.82
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.82**
  - 根拠あり：27 / 33、根拠なし：6
- 優先レビュー（高）
  1. **NFT-PERF-001/002/003**: 具体的な性能基準値（100ms、1000req/s等）はコードから推定できず要確認
  2. **NFT-AVL-001**: 稼働率99.9%の基準はコードからは特定できない
  3. **NFT-SCAL-002/003**: ミドルウェア・ルート数による性能影響の具体的数値は実測が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.pas` - メインユニット、プロバイダー切替定義
- E-02: `src/Horse.Core.pas` - コアルーティング処理、HTTPメソッドハンドラ
- E-03: `src/Horse.Provider.Console.pas` - Consoleプロバイダー実装（MaxConnections, ListenQueue, KeepConnectionAlive等）
- E-04: `src/Horse.Provider.VCL.pas` - VCLプロバイダー実装
- E-05: `src/Horse.Provider.Abstract.pas` - 抽象プロバイダー（Listen/StopListen, OnListen/OnStopListen）
- E-06: `src/Horse.Provider.IOHandleSSL.Contract.pas` - SSL設定インターフェース
- E-07: `src/Horse.Commons.pas` - HTTPステータス、MIMEタイプ定義
- E-08: `src/Horse.Exception.pas` - 例外処理、エラーレスポンス形式
- E-09: `src/Horse.Response.pas` - レスポンス処理（SendFile, Download, RedirectTo）
- E-10: `src/Horse.Request.pas` - リクエスト処理
- E-11: `src/Horse.Session.pas` - セッション管理
- E-12: `src/Horse.Constants.pas` - 定数定義（DEFAULT_PORT, HORSE_VERSION）
- E-13: `src/Horse.Core.RouterTree.pas` - ルーティングツリー実装
- E-14: `README.md` - ミドルウェア一覧、サポートバージョン情報
- E-15: `.github/workflows/tests.yml` - テスト実行設定
- E-16: `samples/` - 各デプロイメント形式サンプル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPレスポンス時間95%ile 100ms以下 | **根拠なし** | △ |
| C-02 | MaxConnections設定による接続制限 | E-03 (FMaxConnections変数) | ○ |
| C-03 | 各HTTPメソッドハンドラの存在 | E-02 (Get/Post/Put/Delete/Patch/Head/All) | ○ |
| C-04 | ListenQueue設定の存在 | E-03 (FListenQueue, IdListenQueueDefault) | ○ |
| C-05 | リソース解放処理の存在 | E-02 (UnInitialize), E-03 (UnInitialize) | ○ |
| C-06 | horse/basic-authミドルウェアの存在 | E-14 (README記載) | ○ |
| C-07 | horse/jwtミドルウェアの存在 | E-14 (README記載) | ○ |
| C-08 | SSL/TLS設定インターフェース | E-06 (SSLVersions, Method等) | ○ |
| C-09 | SSL証明書設定項目 | E-06 (CertFile, KeyFile, RootCertFile) | ○ |
| C-10 | パスパラメータ解析処理 | E-13 (ルーティングツリー) | ○ |
| C-11 | horse/corsミドルウェアの存在 | E-14 (README記載) | ○ |
| C-12 | 例外のJSON出力形式 | E-08 (ToJSON, ToJSONObject) | ○ |
| C-13 | セッション管理クラスの存在 | E-11 (THorseSessions) | ○ |
| C-14 | 稼働率99.9%以上 | **根拠なし** | △ |
| C-15 | StopListen/Listen再実行機能 | E-05, E-03 (InternalStopListen, InternalListen) | ○ |
| C-16 | グレースフルシャットダウン | E-03 (StopListening) | ○ |
| C-17 | KeepConnectionAlive設定 | E-03, E-04 (FKeepConnectionAlive, デフォルトTrue) | ○ |
| C-18 | MaxConnections上限動作 | E-03 (MaxConnections設定) | ○ |
| C-19 | ミドルウェアチェーン性能影響5ms/件 | **根拠なし** | △ |
| C-20 | ルート登録数性能影響 | **根拠なし** | △ |
| C-21 | 複数プロバイダー対応 | E-01 (条件コンパイルによるプロバイダー切替) | ○ |
| C-22 | horse/loggerミドルウェアの存在 | E-14 (README記載) | ○ |
| C-23 | horse/exceptionミドルウェアの存在 | E-14 (README記載) | ○ |
| C-24 | バージョン取得機能 | E-02 (Version), E-12 (HORSE_VERSION = '3.1.9') | ○ |
| C-25 | IsRunning状態取得 | E-03, E-04 (FRunning, IsRunning) | ○ |
| C-26 | OnListen/OnStopListenコールバック | E-05 (DoOnListen, DoOnStopListen) | ○ |
| C-27 | HTTPステータス列挙型 | E-07 (THTTPStatus) | ○ |
| C-28 | MIMEタイプ列挙型 | E-07 (TMimeTypes) | ○ |
| C-29 | RedirectTo機能 | E-09 (RedirectTo, 303 SeeOther) | ○ |
| C-30 | SendFile/Download機能 | E-09 (SendFile, Download, Content-Disposition) | ○ |
| C-31 | Delphi XE7以降サポート | E-14 (README記載) | ○ |
| C-32 | Free Pascal/Lazarus対応 | E-01, E-02等 ({$IF DEFINED(FPC)}条件) | ○ |
| C-33 | 各デプロイメント形式サンプル | E-16 (samples/delphi/, samples/lazarus/) | ○ |

## 4) 不足情報（Unknown / Missing）
- **具体的な性能基準値**: コードからは応答時間やスループットの具体的な数値目標を特定できない。これらは運用要件に基づいて設定する必要がある。
  - 候補：システム要件定義書 / SLA定義書 / 性能試験結果報告書
- **稼働率要件**: 99.9%等の稼働率目標はコードからは特定できない。
  - 候補：SLA定義書 / 運用設計書
- **ミドルウェア性能影響**: ミドルウェア1つあたりの性能影響（5ms等）は実測が必要。
  - 候補：性能試験結果報告書

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: 性能要件の具体的な数値（C-01, C-19, C-20）はコードから特定できないため、実運用環境での計測と要件定義との整合性確認が必要
- **1（中リスク）**: セキュリティミドルウェア（basic-auth, jwt, cors）は外部パッケージであり、本体コードには含まれない。導入時の設定確認が必要
- **0（低リスク）**: SSL/TLS設定、セッション管理、例外処理等の基本機能はコード内で確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 性能基準値（応答時間、スループット）が運用要件と整合しているか確認
- [ ] SSL/TLS設定項目が実際のセキュリティポリシーに適合しているか確認
- [ ] 外部ミドルウェア（basic-auth, jwt, cors, logger, exception）の導入計画を確認
- [ ] 稼働率要件がSLAと整合しているか確認
- [ ] 各デプロイメント形式（Console, VCL, CGI, ISAPI, Apache, Daemon）のテスト計画を確認
- [ ] Delphi/Lazarusバージョン対応範囲が実際のビルド環境と一致しているか確認
