---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **稼働率目標値**：フレームワークレベルでの目標値未定義のため根拠なし
  2. **RTO/RPO値**：アプリケーション実装依存であり具体的根拠なし
  3. **タイムアウト設定**：フレームワーク内での明示的定義が確認できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.pas` - メインユニット、プロバイダー選択ロジック
- E-02: `src/Horse.Core.pas` - コアルーティング、ミドルウェア登録
- E-03: `src/Horse.Provider.Abstract.pas` - プロバイダー抽象クラス
- E-04: `src/Horse.Provider.Console.pas` - コンソールプロバイダー実装
- E-05: `src/Horse.Provider.VCL.pas` - VCLプロバイダー実装
- E-06: `src/Horse.Provider.IOHandleSSL.pas` - SSL/TLSハンドラ実装
- E-07: `src/Horse.Provider.IOHandleSSL.Contract.pas` - SSL/TLSインターフェース定義
- E-08: `src/Horse.Constants.pas` - 定数定義（デフォルトポート、ホスト、バージョン）
- E-09: `src/Horse.Commons.pas` - 共通型定義（HTTPステータス、MIMEタイプ）
- E-10: `src/Horse.Exception.pas` - 例外クラス実装
- E-11: `src/Horse.Session.pas` - セッション管理クラス
- E-12: `src/Horse.Core.RouterTree.pas` - ルーターツリー実装
- E-13: `src/Horse.Request.pas` - リクエストオブジェクト
- E-14: `src/Horse.Response.pas` - レスポンスオブジェクト
- E-15: `README.md` - プロジェクトドキュメント
- E-16: `.github/workflows/tests.yml` - CI/CD設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フレームワークバージョンは3.1.9 | E-08 (`HORSE_VERSION = '3.1.9'`) | ○ |
| C-02 | デフォルトホストは0.0.0.0 | E-08 (`DEFAULT_HOST = '0.0.0.0'`) | ○ |
| C-03 | デフォルトポートは9000 | E-08 (`DEFAULT_PORT = 9000`) | ○ |
| C-04 | MaxConnections設定が可能 | E-04, E-05 (`FMaxConnections`プロパティ) | ○ |
| C-05 | ListenQueue設定が可能 | E-04, E-05 (`FListenQueue`プロパティ) | ○ |
| C-06 | KeepConnectionAliveはデフォルト有効 | E-04 (initialization節で`SetKeepConnectionAlive(True)`) | ○ |
| C-07 | StopListenメソッドで正常停止可能 | E-04, E-05 (`InternalStopListen`実装) | ○ |
| C-08 | IsRunningで稼働状態を確認可能 | E-04, E-05 (`FRunning`フラグ参照) | ○ |
| C-09 | OnListen/OnStopListenコールバック対応 | E-03 (`DoOnListen`, `DoOnStopListen`) | ○ |
| C-10 | SSL/TLS通信をサポート | E-06, E-07 (IHorseProviderIOHandleSSL実装) | ○ |
| C-11 | 証明書ファイル設定が可能 | E-06 (`CertFile`, `KeyFile`等のプロパティ) | ○ |
| C-12 | SSLVersions設定が可能 | E-06, E-07 (`SSLVersions`プロパティ) | ○ |
| C-13 | CipherList設定が可能 | E-06, E-07 (`CipherList`プロパティ) | ○ |
| C-14 | OnGetPasswordイベント対応 | E-06, E-07 (`OnGetPassword`イベント) | ○ |
| C-15 | 認証情報パースイベント対応 | E-04 (`OnAuthentication`メソッド) | ○ |
| C-16 | THorseSessionsによるセッション管理 | E-11 (`THorseSessions`クラス実装) | ○ |
| C-17 | EHorseExceptionによる例外処理 | E-10 (クラス定義、ToJSON等) | ○ |
| C-18 | 例外情報のJSON出力対応 | E-10 (`ToJSON`, `ToJSONObject`メソッド) | ○ |
| C-19 | 複数プロバイダー対応 | E-01 (条件付きコンパイル) | ○ |
| C-20 | ミドルウェアチェーン対応 | E-02, E-12 (`FMiddleware`リスト、`RegisterMiddleware`) | ○ |
| C-21 | ルーターツリー構造 | E-12 (`THorseRouterTree`クラス実装) | ○ |
| C-22 | 公式ミドルウェア一覧 | E-15 (README.mdのミドルウェア表) | ○ |
| C-23 | サードパーティミドルウェア一覧 | E-15 (README.mdのミドルウェア表) | ○ |
| C-24 | Delphiバージョン対応範囲 | E-15 (README.md記載) | ○ |
| C-25 | テストカバレッジ45%/43% | E-15 (README.mdバッジ) | ○ |
| C-26 | GitHub Actionsによる自動テスト | E-16 (tests.yml設定) | ○ |
| C-27 | MITライセンス | E-15 (README.md記載) | ○ |
| C-28 | シングルトンパターン使用 | E-02 (`GetInstance`メソッド実装) | ○ |
| C-29 | フルーエントインターフェース使用 | E-06, E-10 (メソッドチェーン実装) | ○ |
| C-30 | Boss対応 | E-15 (README.md記載) | ○ |
| C-31 | 稼働率目標値 | **根拠なし** | △ |
| C-32 | RTO目標値 | **根拠なし** | △ |
| C-33 | RPO目標値 | **根拠なし** | △ |
| C-34 | タイムアウト設定 | **根拠なし** | △ |
| C-35 | リトライ機構 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **稼働率・RTO・RPO目標値**: フレームワークはライブラリであり、これらの値はアプリケーション実装者が定義すべきもの。フレームワーク自体に目標値は存在しない。
  - 候補：アプリケーション要件定義書 / 運用設計書 / SLA定義書
- **タイムアウト設定**: フレームワーク内での明示的なタイムアウト設定は確認されず。基盤となるIndy/FPC HTTPサーバーのデフォルト設定に依存していると推測。
  - 候補：Indyライブラリドキュメント / FPC HTTPドキュメント
- **リトライ機構**: サーバーフレームワークとしてクライアント側リトライは対象外。サーバー内部でのリトライ機構は実装されていない。
  - 候補：要件なし（フレームワークの責務外）

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: SSL/TLS設定 - コードベースで明確に実装されており、証拠あり
- **0（低リスク）**: 同時接続数・キュー設定 - プロパティとして明確に定義
- **1（中リスク）**: テストカバレッジ - 45%/43%は本番運用には改善余地あり
- **1（中リスク）**: ログ・監視機能 - フレームワークコアには未実装、ミドルウェア依存
- **1（中リスク）**: レートリミット・キャッシュ - サードパーティ依存

## 6) レビュアーチェックリスト（最小）
- [ ] SSL/TLS設定項目が本番環境の要件を満たしているか確認
- [ ] MaxConnections/ListenQueueのデフォルト値が要件に適切か確認
- [ ] 必要なミドルウェア（ログ、レートリミット等）が導入されているか確認
- [ ] テストカバレッジが受け入れ可能なレベルか確認
- [ ] 稼働率・RTO・RPOの目標値をアプリケーションレベルで別途定義する必要性を確認
- [ ] タイムアウト設定をIndy/FPCレベルで確認する必要性を検討
