# 非機能要件定義書

## 概要

本ドキュメントは、Horse Webフレームワーク（バージョン3.1.9）の非機能要件を定義するものです。HorseはExpress.jsにインスパイアされた、DelphiおよびLazarus向けの軽量で高性能なWebフレームワークです。本フレームワークはミニマリスト設計を採用し、高速な開発と高いパフォーマンスを実現します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| API応答（単純なルーティング） | フレームワーク依存なし | ルーターツリー構造による高速なパス解決を実装 |
| ミドルウェアチェーン処理 | 処理チェーン数に依存 | Next()メソッドによる順次実行方式を採用 |
| 静的ファイル配信 | ストリーミング対応 | SendFile/Downloadメソッドによる効率的なファイル配信 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時接続数 | MaxConnections設定により制御 | `THorseProvider.MaxConnections`プロパティで設定可能（Horse.Provider.Console.pas:21行目） |
| 接続キュー長 | ListenQueue設定により制御 | `THorseProvider.ListenQueue`プロパティで設定可能、デフォルトはIdListenQueueDefault（Horse.Provider.Console.pas:22行目） |
| Keep-Alive接続 | デフォルト有効 | `KeepConnectionAlive`プロパティで制御（初期値True、Horse.Provider.Console.pas:332行目） |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | アプリケーション実装依存 | フレームワークとしての稼働率目標値は未定義 |
| 計画停止時間 | 停止・再起動機能あり | `StopListen`メソッドによる正常停止、`OnStopListen`コールバックで停止処理をカスタマイズ可能 |
| 障害復旧時間（RTO） | アプリケーション実装依存 | フレームワークレベルでの自動復旧機能は未実装 |
| 目標復旧時点（RPO） | アプリケーション実装依存 | ステートレスフレームワークのためデータ永続化は利用者責任 |

### 冗長構成

- **サーバー稼働状態監視**: `IsRunning`プロパティで稼働状態を確認可能（Horse.Provider.Console.pas:62行目、Horse.Provider.VCL.pas:64行目）
- **起動・停止イベント**: `OnListen`および`OnStopListen`コールバックによるライフサイクル管理（Horse.Provider.Abstract.pas:31-32行目）
- **ホスト・ポート設定**: デフォルトホスト`0.0.0.0`、デフォルトポート`9000`（Horse.Constants.pas:10-11行目）

## セキュリティ要件

### 通信暗号化（SSL/TLS）

- **SSL/TLS対応**: OpenSSLベースのSSL/TLS通信をサポート（Horse.Provider.IOHandleSSL.pas）
- **証明書設定**:
  - サーバー証明書ファイル（CertFile）
  - ルート証明書ファイル（RootCertFile）
  - 秘密鍵ファイル（KeyFile）
  - DHパラメータファイル（DHParamsFile）
- **SSLバージョン制御**: `SSLVersions`プロパティで使用するSSL/TLSバージョンを指定可能
- **暗号スイート設定**: `CipherList`プロパティで暗号スイートをカスタマイズ可能
- **パスワード保護**: `OnGetPassword`イベントによる秘密鍵パスワード入力対応

### 認証機能

- **Basic認証**: `horse/basic-auth`ミドルウェアで対応（外部ミドルウェア）
- **JWT認証**: `horse/jwt`ミドルウェアで対応（外部ミドルウェア）
- **Bearer認証**: `andre-djsystem/horse-bearer-auth`ミドルウェアで対応（サードパーティ）
- **HTTP認証パース**: `OnParseAuthentication`イベントによる認証情報解析（Horse.Provider.Console.pas:30行目）

### セッション管理

- **セッションオブジェクト管理**: `THorseSessions`クラスによる型安全なセッション管理（Horse.Session.pas）
- **セッション格納**: `TObjectDictionary`による複数セッションの管理

### 例外処理

- **構造化例外**: `EHorseException`クラスによるHTTPステータスコード付きの例外処理（Horse.Exception.pas）
- **例外情報**: エラー、タイトル、コード、ヒント、ユニット名、詳細情報を含む包括的なエラー情報
- **JSON形式出力**: 例外情報をJSONフォーマットで出力可能（`ToJSON`/`ToJSONObject`メソッド）

## 拡張性要件

### アーキテクチャ

- **ミドルウェアパターン**: Express.jsスタイルのミドルウェアチェーンをサポート
- **プロバイダー抽象化**: 複数のデプロイメントターゲットに対応
  - Console（コンソールアプリケーション）
  - VCL（Windows GUIアプリケーション）
  - ISAPI（IIS統合）
  - Apache（Apache統合）
  - CGI/FastCGI
  - Daemon（Linuxサービス）
  - LCL（Lazarusクロスプラットフォーム）
- **ルーターツリー**: 効率的なルート管理のための木構造実装

### ミドルウェアエコシステム

- **公式ミドルウェア**: JSON、Basic認証、CORS、Stream、JWT、例外ハンドリング、ロギング、圧縮
- **サードパーティミドルウェア**: ETag、ページネーション、キャッシュコントロール、レートリミット、スローダウン、アップロード、ヘルスチェック、静的ファイル配信、Prometheus連携等

### 対応プラットフォーム

- **Delphiバージョン**: Delphi 13 Florence, Delphi 12 Athens, Delphi 11 Alexandria, Delphi 10.4 Sydney, Delphi 10.3 Rio, Delphi 10.2 Tokyo, Delphi 10.1 Berlin, Delphi 10 Seattle, Delphi XE8, Delphi XE7
- **Free Pascal**: Lazarus対応

## 保守性要件

### コード品質

- **テストカバレッジ**: Console 45%、VCL 43%（README.md:116行目）
- **CI/CD**: GitHub Actionsによる自動テスト実行（.github/workflows/tests.yml）
- **ライセンス**: MITライセンスによるオープンソース

### 設計パターン

- **シングルトンパターン**: `THorseCore.GetInstance`による単一インスタンス管理
- **フルーエントインターフェース**: メソッドチェーンによる設定（例: `IOHandleSSL.CertFile('...').KeyFile('...').Active(True)`）
- **ジェネリクス活用**: 型安全なセッション管理、リスト、辞書の使用
- **コンパイラ指令**: Delphi/FPC両対応のための条件付きコンパイル

### ドキュメント

- **README**: クイックスタートガイド、インストール方法、ミドルウェア一覧
- **パッケージマネージャー**: Boss（Delphiパッケージマネージャー）対応

## 運用・監視要件

### ログ機能

- **ロギングミドルウェア**: `horse/logger`ミドルウェアによるリクエストログ（外部ミドルウェア）
- **例外ロギング**: `arvanus/horse-exception-logger`による例外ログ（サードパーティ）
- **データロガー**: `dliocode/horse-datalogger`による詳細ログ（サードパーティ）

### 監視機能

- **ヘルスチェック**: `CarlosHe/horse-healthcheck`ミドルウェアによるヘルスチェックエンドポイント（サードパーティ）
- **Prometheus連携**: `marcobreveglieri/horse-prometheus-metrics`によるメトリクス公開（サードパーティ）

### レートリミット

- **レート制限**: `dliocode/horse-ratelimit`によるリクエストレート制限（サードパーティ）
- **スローダウン**: `dliocode/horse-slowdown`による段階的レスポンス遅延（サードパーティ）

### キャッシュ

- **キャッシュコントロール**: `bittencourtthulio/horse-cachecontrol`によるキャッシュヘッダー制御（サードパーティ）
- **ETag**: `bittencourtthulio/Horse-ETag`によるETagサポート（サードパーティ）

## 備考

### 制限事項

1. **キャッシュ機能**: フレームワークコアには組み込まれておらず、サードパーティミドルウェアで対応
2. **レートリミット**: フレームワークコアには組み込まれておらず、サードパーティミドルウェアで対応
3. **タイムアウト設定**: フレームワークレベルでの明示的なタイムアウト設定は確認されず、基盤となるIndy/FPC HTTPサーバーのデフォルト設定に依存
4. **リトライ設定**: フレームワークレベルでのリトライ機構は実装されていない
5. **ロギング・監視**: フレームワークコアには組み込まれておらず、ミドルウェアで対応

### 推奨事項

1. 本番環境ではSSL/TLSの有効化を推奨
2. レートリミットミドルウェアの導入によるDoS対策を推奨
3. ロギングミドルウェアの導入による運用監視を推奨
4. ヘルスチェックエンドポイントの実装による可用性監視を推奨
