# API設計書

## 概要

本ドキュメントは、Jenkins CI/CDサーバーのREST APIの設計仕様を定義するものです。JenkinsはJavaベースのCI/CDサーバーであり、Stapler Webフレームワークを使用してRESTfulなAPIを公開しています。各エンドポイントは、リソースオブジェクトのメソッドとして実装されており、XML、JSON、Python形式でのデータアクセスをサポートしています。

## 共通仕様

### ベースURL

```
{JENKINS_URL}
```

例: `http://localhost:8080/jenkins`

### 認証方式

Jenkins APIは以下の認証方式をサポートしています:

1. **Basic認証**: ユーザー名とAPIトークン（またはパスワード）を使用
2. **セッション認証**: ブラウザセッションによる認証
3. **APIトークン**: ユーザー設定から生成されるトークンによる認証
4. **CrumbIssuer**: CSRF保護のためのcrumb値を使用

### 共通ヘッダー

| ヘッダー名 | 必須 | 説明 |
| --- | --- | --- |
| Authorization | 条件付き | Basic認証ヘッダー (`Basic base64(username:api_token)`) |
| Jenkins-Crumb | 条件付き | CSRF保護用crumb値（POST/PUT/DELETE時に必要） |
| Content-Type | 条件付き | リクエストボディの形式 (`application/json`, `application/xml`, `application/x-www-form-urlencoded`) |
| Accept | - | レスポンス形式の指定 (`application/json`, `application/xml`) |

### 共通エラーレスポンス

| ステータスコード | 説明 |
| --- | --- |
| 400 | Bad Request - リクエストパラメータ不正 |
| 401 | Unauthorized - 認証エラー |
| 403 | Forbidden - 権限エラー |
| 404 | Not Found - リソース未検出 |
| 409 | Conflict - 操作不可能な状態（ビルド不可など） |
| 500 | Internal Server Error - サーバーエラー |

### 共通レスポンスヘッダー

| ヘッダー名 | 説明 |
| --- | --- |
| X-Jenkins | Jenkinsバージョン |
| X-Jenkins-Session | Jenkinsセッションハッシュ |
| X-Content-Type-Options | `nosniff` |
| X-Frame-Options | `deny` |

## API一覧

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| API共通 | `/api/xml` | GET | XMLフォーマットでデータ取得 |
| API共通 | `/api/json` | GET | JSONフォーマットでデータ取得 |
| API共通 | `/api/python` | GET | Pythonリテラル形式でデータ取得 |
| Jenkins | `/configSubmit` | POST | Jenkins設定の保存 |
| Jenkins | `/reload` | POST | 設定の再読み込み |
| Jenkins | `/quietDown` | POST | 静止モードの開始 |
| Jenkins | `/cancelQuietDown` | POST | 静止モードのキャンセル |
| Jenkins | `/restart` | POST | Jenkinsの再起動 |
| Jenkins | `/safeRestart` | POST | 安全な再起動 |
| Jenkins | `/exit` | POST | Jenkinsの終了 |
| Jenkins | `/safeExit` | POST | 安全な終了 |
| Jenkins | `/createItem` | POST | 新規ジョブ・アイテムの作成 |
| Jenkins | `/createView` | POST | 新規ビューの作成 |
| Job | `{job}/build` | POST | ビルドの開始 |
| Job | `{job}/buildWithParameters` | POST | パラメータ付きビルドの開始 |
| Job | `{job}/cancelQueue` | POST | キュー内ビルドのキャンセル |
| Job | `{job}/config.xml` | GET/POST | ジョブ設定XMLの取得/更新 |
| Job | `{job}/configSubmit` | POST | ジョブ設定の保存 |
| Job | `{job}/submitDescription` | POST | 説明文の更新 |
| Job | `{job}/confirmRename` | POST | ジョブ名の変更 |
| Job | `{job}/doDelete` | POST | ジョブの削除 |
| Build | `{job}/{build}/` | GET | ビルド情報の取得 |
| Build | `{job}/{build}/buildStatus` | GET | ビルドステータスの取得 |
| Build | `{job}/{build}/buildNumber` | GET | ビルド番号の取得 |
| Build | `{job}/{build}/buildTimestamp` | GET | ビルドタイムスタンプの取得 |
| Build | `{job}/{build}/submitDescription` | POST | ビルド説明の更新 |
| Build | `{job}/{build}/configSubmit` | POST | ビルド設定の保存 |
| View | `{view}/config.xml` | GET/POST | ビュー設定XMLの取得/更新 |
| View | `{view}/configSubmit` | POST | ビュー設定の保存 |
| View | `{view}/submitDescription` | POST | ビュー説明の更新 |
| View | `{view}/createItem` | POST | ビュー内でのアイテム作成 |
| View | `{view}/doDelete` | POST | ビューの削除 |
| Computer | `/computer/` | GET | 全ノード一覧の取得 |
| Computer | `/computer/{name}/config.xml` | GET/POST | ノード設定XMLの取得/更新 |
| Computer | `/computer/{name}/configSubmit` | POST | ノード設定の保存 |
| Computer | `/computer/{name}/submitDescription` | POST | ノード説明の更新 |
| Queue | `/queue/` | GET | ビルドキューの取得 |
| Queue | `/queue/cancelItem` | POST | キューアイテムのキャンセル |
| User | `/user/{id}/` | GET | ユーザー情報の取得 |
| User | `/user/{id}/submitDescription` | POST | ユーザー説明の更新 |
| Script | `/script` | POST | Groovyスクリプトの実行 |
| Script | `/scriptText` | POST | スクリプト実行（テキストレスポンス） |

## 各APIエンドポイント定義

### API共通

#### 1 XML形式でのデータ取得

任意のリソースに `/api/xml` を付加することで、そのリソースのデータをXML形式で取得できます。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET {resource}/api/xml` |
| 認証 | リソースの読み取り権限に依存 |
| 権限 | READ |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| xpath | string | - | - | XPathによるフィルタリング |
| wrapper | string | - | - | 複数結果のラッパー要素名 |
| tree | string | - | - | 取得するプロパティの指定 |
| depth | int | - | 1 | 取得する階層の深さ |
| exclude | string[] | - | - | 除外するXPathパターン |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```xml
<?xml version="1.0" encoding="UTF-8"?>
<hudson>
  <mode>NORMAL</mode>
  <nodeDescription>the controller</nodeDescription>
  <numExecutors>2</numExecutors>
  <job>
    <name>my-job</name>
    <url>http://localhost:8080/job/my-job/</url>
    <color>blue</color>
  </job>
</hudson>
```

**レスポンス（エラー時）**

ステータスコード: `404 Not Found`

XPathで一致する要素がない場合に返されます。

---

#### 2 JSON形式でのデータ取得

任意のリソースに `/api/json` を付加することで、そのリソースのデータをJSON形式で取得できます。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET {resource}/api/json` |
| 認証 | リソースの読み取り権限に依存 |
| 権限 | READ |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pretty | boolean | - | false | 整形出力 |
| tree | string | - | - | 取得するプロパティの指定 |
| jsonp | string | - | - | JSONPコールバック関数名 |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "_class": "hudson.model.Hudson",
  "mode": "NORMAL",
  "nodeDescription": "the controller",
  "numExecutors": 2,
  "jobs": [
    {
      "_class": "hudson.model.FreeStyleProject",
      "name": "my-job",
      "url": "http://localhost:8080/job/my-job/",
      "color": "blue"
    }
  ]
}
```

---

#### 3 Python形式でのデータ取得

任意のリソースに `/api/python` を付加することで、そのリソースのデータをPythonリテラル形式で取得できます。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET {resource}/api/python` |
| 認証 | リソースの読み取り権限に依存 |
| 権限 | READ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```python
{
  '_class': 'hudson.model.Hudson',
  'mode': 'NORMAL',
  'nodeDescription': 'the controller',
  'numExecutors': 2,
  'jobs': [
    {
      '_class': 'hudson.model.FreeStyleProject',
      'name': 'my-job',
      'url': 'http://localhost:8080/job/my-job/',
      'color': 'blue'
    }
  ]
}
```

---

### Jenkins管理

#### 4 設定の保存

Jenkins全体の設定を保存します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /configSubmit` |
| 認証 | 必要 |
| 権限 | MANAGE |

**リクエストボディ**

Content-Type: `application/x-www-form-urlencoded`

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| json | string | ○ | 設定データのJSON文字列 |
| system_message | string | - | システムメッセージ |

**レスポンス（成功時）**

ステータスコード: `302 Found`

設定保存後、トップページにリダイレクトされます。

---

#### 5 設定の再読み込み

ディスクからJenkins設定を再読み込みします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /reload` |
| 認証 | 必要 |
| 権限 | MANAGE |

**レスポンス（成功時）**

ステータスコード: `302 Found`

再読み込み後、トップページにリダイレクトされます。

---

#### 6 静止モードの開始

新しいビルドの開始を停止し、システムのシャットダウンや再起動の準備をします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /quietDown` |
| 認証 | 必要 |
| 権限 | MANAGE |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| block | boolean | - | false | 全ビルド完了まで待機 |
| timeout | int | - | 0 | 待機タイムアウト（ミリ秒） |
| message | string | - | - | 静止モードの理由 |
| safeRestart | boolean | - | false | 安全再起動用フラグ |

**レスポンス（成功時）**

ステータスコード: `302 Found`

トップページにリダイレクトされます。

---

#### 7 静止モードのキャンセル

静止モードをキャンセルし、通常運用に戻します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /cancelQuietDown` |
| 認証 | 必要 |
| 権限 | MANAGE |

**レスポンス（成功時）**

ステータスコード: `302 Found`

トップページにリダイレクトされます。

---

#### 8 Jenkinsの再起動

Jenkinsを再起動します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /restart` |
| 認証 | 必要 |
| 権限 | ADMINISTER |

**レスポンス（成功時）**

ステータスコード: `302 Found`

再起動処理が開始され、トップページにリダイレクトされます。

---

#### 9 安全な再起動

実行中のビルドが完了するまで待機してから再起動します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /safeRestart` |
| 認証 | 必要 |
| 権限 | ADMINISTER |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| message | string | - | - | 再起動理由のメッセージ |

**レスポンス（成功時）**

ステータスコード: `302 Found`

安全再起動処理が開始されます。

---

#### 10 アイテムの作成

新しいジョブ、フォルダ、その他のアイテムを作成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /createItem` |
| 認証 | 必要 |
| 権限 | CREATE |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| name | string | ○ | - | 新規アイテム名 |
| mode | string | 条件付き | - | 作成モード（コピー元指定時は不要） |
| from | string | - | - | コピー元アイテム名 |

**リクエストボディ**

Content-Type: `application/xml`（XML形式で設定を指定する場合）

```xml
<?xml version="1.0" encoding="UTF-8"?>
<project>
  <description>サンプルジョブ</description>
  <keepDependencies>false</keepDependencies>
  <properties/>
  <scm class="hudson.scm.NullSCM"/>
  <canRoam>true</canRoam>
  <disabled>false</disabled>
  <blockBuildWhenDownstreamBuilding>false</blockBuildWhenDownstreamBuilding>
  <blockBuildWhenUpstreamBuilding>false</blockBuildWhenUpstreamBuilding>
  <triggers/>
  <concurrentBuild>false</concurrentBuild>
  <builders/>
  <publishers/>
  <buildWrappers/>
</project>
```

**レスポンス（成功時）**

ステータスコード: `200 OK`

作成されたアイテムのXMLが返されます。

---

### Job

#### 11 ビルドの開始

ジョブのビルドを開始します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST {job}/build` |
| 認証 | 必要（トークン認証も可） |
| 権限 | BUILD |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| delay | int | - | quietPeriod | ビルド開始までの遅延（秒） |
| token | string | - | - | 認証トークン |
| cause | string | - | - | ビルド理由（トークン認証時） |

**レスポンス（成功時）**

ステータスコード: `201 Created`

```
Location: http://localhost:8080/queue/item/123/
```

キューに追加されたアイテムのURLが返されます。

**レスポンス（エラー時）**

ステータスコード: `409 Conflict`

ジョブがビルド不可能な状態の場合に返されます。

---

#### 12 パラメータ付きビルドの開始

パラメータを指定してジョブのビルドを開始します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST {job}/buildWithParameters` |
| 認証 | 必要（トークン認証も可） |
| 権限 | BUILD |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| delay | int | - | quietPeriod | ビルド開始までの遅延（秒） |
| token | string | - | - | 認証トークン |
| {param_name} | any | - | - | 各パラメータの値 |

**レスポンス（成功時）**

ステータスコード: `201 Created`

**レスポンス（エラー時）**

ステータスコード: `400 Bad Request`

ジョブがパラメータ化されていない場合に返されます。

---

#### 13 キュー内ビルドのキャンセル

キューに入っているビルドをキャンセルします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST {job}/cancelQueue` |
| 認証 | 必要 |
| 権限 | CANCEL |

**レスポンス（成功時）**

ステータスコード: `302 Found`

前のページにリダイレクトされます。

---

#### 14 ジョブ設定XMLの取得

ジョブの設定をXML形式で取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET {job}/config.xml` |
| 認証 | 必要 |
| 権限 | EXTENDED_READ または CONFIGURE |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `application/xml`

```xml
<?xml version="1.0" encoding="UTF-8"?>
<project>
  <description>サンプルジョブ</description>
  <keepDependencies>false</keepDependencies>
  <!-- ... -->
</project>
```

---

#### 15 ジョブ設定XMLの更新

ジョブの設定をXML形式で更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST {job}/config.xml` |
| 認証 | 必要 |
| 権限 | CONFIGURE |

**リクエストボディ**

Content-Type: `application/xml`

ジョブ設定のXMLを送信します。

**レスポンス（成功時）**

ステータスコード: `200 OK`

---

#### 16 ジョブ名の変更

ジョブ名を変更します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST {job}/confirmRename` |
| 認証 | 必要 |
| 権限 | CONFIGURE（または CREATE + DELETE） |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| newName | string | ○ | - | 新しいジョブ名 |

**レスポンス（成功時）**

ステータスコード: `302 Found`

新しいジョブURLにリダイレクトされます。

**レスポンス（エラー時）**

- 名前が既に使用されている場合: `400 Bad Request`
- 無効な文字が含まれる場合: `400 Bad Request`

---

#### 17 ジョブの削除

ジョブを削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST {job}/doDelete` |
| 認証 | 必要 |
| 権限 | DELETE |

**レスポンス（成功時）**

ステータスコード: `302 Found`

親フォルダまたはルートにリダイレクトされます。

---

### Build

#### 18 ビルドステータスの取得

ビルドのステータスを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET {job}/{build}/buildStatus` |
| 認証 | 必要 |
| 権限 | READ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

ビルドステータスの画像（SVG/PNG）が返されます。

---

#### 19 ビルド番号の取得

ビルド番号をプレーンテキストで取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET {job}/{build}/buildNumber` |
| 認証 | 必要 |
| 権限 | READ |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/plain`

```
123
```

---

#### 20 ビルドタイムスタンプの取得

ビルドのタイムスタンプを取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET {job}/{build}/buildTimestamp` |
| 認証 | 必要 |
| 権限 | READ |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| format | string | - | - | 日付フォーマット（SimpleDateFormat形式） |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/plain`

```
2024-01-15 10:30:00
```

---

### View

#### 21 ビュー設定の保存

ビューの設定を保存します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST {view}/configSubmit` |
| 認証 | 必要 |
| 権限 | CONFIGURE |

**リクエストボディ**

Content-Type: `application/x-www-form-urlencoded`

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| json | string | ○ | 設定データのJSON |
| name | string | - | ビュー名 |
| description | string | - | 説明文 |
| filterExecutors | boolean | - | エグゼキュータのフィルタ |
| filterQueue | boolean | - | キューのフィルタ |

**レスポンス（成功時）**

ステータスコード: `302 Found`

ビュー一覧にリダイレクトされます。

---

#### 22 ビューの削除

ビューを削除します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST {view}/doDelete` |
| 認証 | 必要 |
| 権限 | DELETE |

**レスポンス（成功時）**

ステータスコード: `302 Found`

親ビューグループにリダイレクトされます。

---

### Computer (Node)

#### 23 ノード設定の取得

ノードの設定をXML形式で取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /computer/{name}/config.xml` |
| 認証 | 必要 |
| 権限 | EXTENDED_READ または CONFIGURE |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `application/xml`

```xml
<?xml version="1.0" encoding="UTF-8"?>
<slave>
  <name>agent-1</name>
  <description>Build agent</description>
  <remoteFS>/home/jenkins</remoteFS>
  <numExecutors>2</numExecutors>
  <mode>NORMAL</mode>
  <retentionStrategy class="hudson.slaves.RetentionStrategy$Always"/>
  <launcher class="hudson.slaves.JNLPLauncher"/>
</slave>
```

---

#### 24 ノード設定の更新

ノードの設定をXML形式で更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /computer/{name}/config.xml` |
| 認証 | 必要 |
| 権限 | CONFIGURE |

**リクエストボディ**

Content-Type: `application/xml`

ノード設定のXMLを送信します。

**レスポンス（成功時）**

ステータスコード: `200 OK`

---

### Queue

#### 25 キューアイテムのキャンセル

キューに入っているアイテムをキャンセルします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /queue/cancelItem` |
| 認証 | 必要 |
| 権限 | CANCEL |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| id | long | ○ | - | キューアイテムID |

**レスポンス（成功時）**

ステータスコード: `204 No Content`

---

### Script

#### 26 Groovyスクリプトの実行

Jenkinsのスクリプトコンソールでスクリプトを実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /script` |
| 認証 | 必要 |
| 権限 | ADMINISTER |

**リクエストボディ**

Content-Type: `application/x-www-form-urlencoded`

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| script | string | ○ | 実行するGroovyスクリプト |

**レスポンス（成功時）**

ステータスコード: `200 OK`

スクリプト実行結果のHTMLが返されます。

---

#### 27 スクリプト実行（テキストレスポンス）

スクリプトを実行し、プレーンテキストで結果を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /scriptText` |
| 認証 | 必要 |
| 権限 | ADMINISTER |

**リクエストボディ**

Content-Type: `application/x-www-form-urlencoded`

| フィールド名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| script | string | ○ | 実行するGroovyスクリプト |

**レスポンス（成功時）**

ステータスコード: `200 OK`

Content-Type: `text/plain`

スクリプトの実行結果がプレーンテキストで返されます。

---

## 備考

### 認証について

1. **APIトークン**: ユーザーのAPIトークンはJenkins UIの「ユーザー設定」から生成できます。Basic認証でパスワードの代わりに使用することが推奨されます。

2. **CSRF保護**: POST/PUT/DELETEリクエストには、crumb値が必要です。crumbは `/crumbIssuer/api/xml` から取得できます。

### tree パラメータ

`tree` パラメータを使用して、レスポンスに含めるプロパティを制限できます。

例: `/api/json?tree=jobs[name,color]`

### depth パラメータ

`depth` パラメータを使用して、ネストされたオブジェクトの深さを制御できます。

### Webhookとの連携

外部システムからビルドをトリガーする場合、`token` パラメータを使用した認証が便利です。

### エラーハンドリング

すべてのAPIは、エラー時に適切なHTTPステータスコードとエラーメッセージを返します。`Accept` ヘッダーに基づいて、XML、JSON、またはHTMLでエラー情報が返されます。
