---
generated_at: 2026-01-22 19:15:00
metrics:
  claims_total: 27
  claims_with_evidence: 25
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：25 / 27、根拠なし：2
- 優先レビュー（高）
  1. **共通エラーレスポンス形式**：実装により異なる可能性あり
  2. **APIトークン認証の詳細**：SecurityRealm実装による差異の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/Api.java`
- E-02: `core/src/main/java/jenkins/model/Jenkins.java`
- E-03: `core/src/main/java/hudson/model/AbstractItem.java`
- E-04: `core/src/main/java/hudson/model/Job.java`
- E-05: `core/src/main/java/hudson/model/Run.java`
- E-06: `core/src/main/java/hudson/model/View.java`
- E-07: `core/src/main/java/hudson/model/Computer.java`
- E-08: `core/src/main/java/hudson/model/Queue.java`
- E-09: `core/src/main/java/jenkins/model/ParameterizedJobMixIn.java`
- E-10: `core/src/main/java/hudson/model/AbstractProject.java`
- E-11: `core/src/main/java/hudson/model/User.java`
- E-12: `core/src/main/java/hudson/model/labels/LabelAtom.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | API共通エンドポイント（/api/xml, /api/json, /api/python） | E-01 (Api.java: doXml, doJson, doPython メソッド) | ○ |
| C-02 | XPathクエリパラメータによるXMLフィルタリング | E-01 (Api.java: 104-211行目 doXml メソッド) | ○ |
| C-03 | treeパラメータによるプロパティ指定 | E-01 (Api.java: 107行目 tree パラメータ) | ○ |
| C-04 | X-Jenkins, X-Jenkins-Session ヘッダーの設定 | E-01 (Api.java: 307-315行目 setHeaders メソッド) | ○ |
| C-05 | Jenkins設定保存 doConfigSubmit | E-02 (Jenkins.java: 4046行目) | ○ |
| C-06 | 設定再読み込み doReload | E-02 (Jenkins.java: 4413行目) | ○ |
| C-07 | 静止モード doQuietDown/doCancelQuietDown | E-02 (Jenkins.java: 4104, 4155, 4179行目) | ○ |
| C-08 | アイテム作成 doCreateItem | E-02 (Jenkins.java: 4244行目) | ○ |
| C-09 | ビュー作成 doCreateView | E-02 (Jenkins.java: 4269行目) | ○ |
| C-10 | 再起動 doRestart/doSafeRestart | E-02 (Jenkins.java: 4546, 4600行目) | ○ |
| C-11 | 終了 doExit/doSafeExit | E-02 (Jenkins.java: 4744, 4778行目) | ○ |
| C-12 | ビルド開始 doBuild | E-09 (ParameterizedJobMixIn.java: 205行目), E-10 | ○ |
| C-13 | パラメータ付きビルド doBuildWithParameters | E-09 (ParameterizedJobMixIn.java: 243行目), E-10 | ○ |
| C-14 | キュー内ビルドキャンセル doCancelQueue | E-09 (ParameterizedJobMixIn.java: 261行目) | ○ |
| C-15 | ジョブ設定XML doConfigDotXml | E-03 (AbstractItem.java: 837行目) | ○ |
| C-16 | ジョブ設定保存 doConfigSubmit | E-04 (Job.java: 1399行目) | ○ |
| C-17 | 説明文更新 doSubmitDescription | E-03 (AbstractItem.java: 655行目), E-04, E-06 | ○ |
| C-18 | ジョブ名変更 doConfirmRename | E-03 (AbstractItem.java: 250-264行目) | ○ |
| C-19 | ビルドステータス取得 doBuildStatus | E-05 (Run.java: 2102行目) | ○ |
| C-20 | ビルド番号取得 doBuildNumber | E-05 (Run.java: 2197行目) | ○ |
| C-21 | ビルドタイムスタンプ取得 doBuildTimestamp | E-05 (Run.java: 2207行目) | ○ |
| C-22 | ビュー設定保存 doConfigSubmit | E-06 (View.java: 733行目) | ○ |
| C-23 | ビュー削除 doDoDelete | E-06 (View.java: 791行目) | ○ |
| C-24 | ノード設定 doConfigDotXml | E-07 (Computer.java: 1525行目) | ○ |
| C-25 | スクリプト実行 doScript/doScriptText | E-02 (Jenkins.java: 4842, 4862行目) | ○ |
| C-26 | 共通エラーレスポンス形式（400, 401, 403, 404, 500） | **根拠なし** | △ |
| C-27 | APIトークン認証の詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **共通エラーレスポンス形式**: エラーレスポンスの形式はコード全体に分散しており、統一的な定義ファイルが見つからなかった。実際のエラーレスポンス形式はStaplerフレームワークとExceptionハンドラに依存する。
  - 候補：`hudson.util.FormValidation` / `org.kohsuke.stapler.HttpResponses` / 各メソッドのエラー処理
- **APIトークン認証の詳細仕様**: 認証の詳細実装はSecurityRealmの実装に依存しており、プラグインによって異なる可能性がある。
  - 候補：`hudson.security.SecurityRealm` / `hudson.security.BasicAuthenticationFilter` / 各種認証プラグイン

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: API共通エンドポイント - ソースコードで明確に定義されている
- **0（低リスク）**: ビルド関連API - ParameterizedJobMixInで標準実装されている
- **0（低リスク）**: 設定関連API - Jenkins.javaで明確に定義されている
- **1（中リスク）**: 認証・権限要件 - 実装はソースコードで確認できるが、プラグインによる拡張の可能性あり
- **1（中リスク）**: エラーレスポンス形式 - Staplerフレームワークの仕様に依存

## 6) レビュアーチェックリスト（最小）
- [ ] APIエンドポイントのURL形式が実際の動作と一致するか確認
- [ ] 認証要件（権限レベル）が実際の動作と一致するか確認
- [ ] リクエスト/レスポンスのサンプルが実際のフォーマットと一致するか確認
- [ ] CSRF保護（crumb）の要件が正しく記載されているか確認
- [ ] エラーレスポンスの形式を実際の動作で検証
- [ ] プラグインによる拡張APIが存在する場合、本ドキュメントの範囲外であることを確認
