# Jenkins

## 概要

Jenkinsは、Javaで構築されたオープンソースの自動化サーバーです。2,000以上のプラグインをサポートし、ビルド、テスト、デプロイなど、あらゆる開発ワークフローの自動化を実現します。継続的インテグレーション（CI）および継続的デリバリー（CD）の業界標準ツールとして、世界中の数百万のユーザーと数千の企業で採用されています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| ビルド自動化 | プロジェクトのビルドプロセスを自動化し、コード変更時に自動的にビルドを実行 |
| テスト実行 | 単体テスト、結合テストを自動実行し、バグや問題を早期に検出 |
| 静的コード解析 | コード品質のチェックと静的解析の自動化 |
| デプロイメント | アプリケーションの各種環境への自動デプロイ |
| プラグインエコシステム | 2,000以上のプラグインによる拡張性の高いアーキテクチャ |
| パイプライン | Jenkinsfileによる宣言的・スクリプト型パイプラインのサポート |
| 分散ビルド | マスター/エージェント構成による分散ビルド環境の構築 |
| WebSocket対応 | リアルタイム通信のためのWebSocketサポート |
| CLI | コマンドラインインターフェースによる操作・管理 |
| セキュリティ | 認証・認可、CSRF保護、セキュリティレルムの設定 |

## 技術スタック

### コア

- 言語: Java 21以上
- ビルドツール: Apache Maven 3.9.6以上
- Webサーバー: Winstone（Jetty組み込み）
- シリアライゼーション: XStream
- 依存性注入: Guice
- Remotingバージョン: 3355.v388858a_47b_33

### フロントエンド

- Node.js: 24.13.0
- パッケージマネージャー: Yarn 4.12.0
- バンドラー: Webpack 5.104.1
- トランスパイラー: Babel 7.28.6
- CSSプリプロセッサ: Sass 1.97.2
- UIライブラリ: jQuery 3.7.1, Tippy.js 6.3.7, Handlebars 4.7.8

### 主要ライブラリ

- ANTLR 4.13.2 - パーサー生成
- SpotBugs - 静的コード解析
- Checkstyle 13.0.0 - コードスタイルチェック
- JaCoCo 0.8.14 - コードカバレッジ
- ESLint 9.39.2 - JavaScriptリンター
- Prettier 3.8.0 - コードフォーマッター
- Stylelint 17.0.0 - CSSリンター
- Lodash 4.17.21 - ユーティリティライブラリ
- SortableJS 1.15.6 - ドラッグ&ドロップソート

## ディレクトリ構成

```
jenkins-master/
├── bom/                    # Bill of Materials（依存関係管理）
├── cli/                    # コマンドラインインターフェースモジュール
├── core/                   # Jenkinsコア機能
│   └── src/
│       ├── main/
│       │   ├── java/       # Javaソースコード
│       │   │   ├── hudson/ # 主要クラス（FilePath, Functions等）
│       │   │   └── jenkins/# Jenkins固有クラス
│       │   └── resources/  # リソースファイル、Groovyビュー
│       └── test/           # ユニットテスト
├── coverage/               # コードカバレッジレポート
├── docs/                   # ドキュメント
├── src/
│   ├── checkstyle/         # Checkstyle設定
│   └── main/scss/          # SCSSスタイルシート
├── test/                   # 機能テストモジュール
├── war/                    # WARパッケージングモジュール
│   └── src/main/webapp/    # Webアプリケーションリソース
├── websocket/              # WebSocketモジュール
│   ├── spi/                # WebSocket SPI
│   └── jetty12-ee9/        # Jetty12 EE9実装
├── .github/                # GitHub Actions、PR/Issueテンプレート
├── pom.xml                 # 親POM（Maven設定）
├── package.json            # フロントエンド依存関係
├── Jenkinsfile             # CI/CDパイプライン定義
└── webpack.config.js       # Webpackビルド設定
```

## セットアップ

### 必要条件

- Java Development Kit (JDK) 21または25
  - Eclipse TemurinまたはOpenJDK推奨
- Apache Maven 3.9.6以上
- Node.js 24.0.0以上（フロントエンド開発の場合）
- Yarn（Corepack経由）

### インストール手順

1. リポジトリをクローン

```sh
git clone https://github.com/jenkinsci/jenkins.git
cd jenkins
```

2. WARファイルをビルド（テストスキップ・高速ビルド）

```sh
mvn -am -pl war,bom -Pquick-build clean install
```

3. ビルド成果物は `war/target/jenkins.war` に生成されます

4. Jenkinsを起動

```sh
java -jar war/target/jenkins.war
```

### 開発インスタンスの起動

```sh
MAVEN_OPTS='--add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED' mvn -pl war jetty:run
```

## 開発

### リンターとフォーマッター

#### バックエンド（Java）

自動フォーマット適用:
```sh
mvn spotless:apply
```

使用ツール:
- Checkstyle - コードスタイル検証
- SpotBugs - バグ検出
- Spotless - 自動フォーマット

#### フロントエンド（JavaScript/CSS）

リンターの実行:
```sh
yarn lint
```

自動修正:
```sh
yarn lint:fix
```

使用ツール:
- ESLint - JavaScript/TypeScriptリンター
- Prettier - コードフォーマッター
- Stylelint - CSSリンター

### テストの実行

```sh
# ユニットテストのみ
mvn test -Plight-test

# ユニットテスト + 機能テスト（一部）
mvn test -Psmoke-test

# 全テスト実行
mvn test -Pall-tests
```

### フロントエンド開発

1. NodeとYarnをパスに追加（オプション）:
```sh
export PATH=$PWD/node:$PWD/node/node_modules/corepack/shims:$PATH
```

2. 依存関係インストール:
```sh
yarn
```

3. 開発サーバー起動:
```sh
yarn start
```

4. プロダクションビルド:
```sh
yarn build
```

### ライセンス

MIT License
