---
generated_at: 2026-01-22 19:10:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pom.xml` - Mavenプロジェクト設定（バージョン情報、モジュール構成、依存関係）
- E-02: `README.md` - 既存のREADMEドキュメント
- E-03: `package.json` - フロントエンド依存関係とスクリプト定義
- E-04: `CONTRIBUTING.md` - 開発ガイドライン、ビルド手順、テスト実行方法
- E-05: `core/src/main/java/hudson/` - コアJavaソースコードディレクトリ
- E-06: `war/pom.xml` - WARモジュール設定
- E-07: `cli/pom.xml` - CLIモジュール設定
- E-08: `websocket/spi/pom.xml` - WebSocket SPIモジュール設定
- E-09: `websocket/jetty12-ee9/pom.xml` - Jetty12 EE9実装設定
- E-10: `bom/pom.xml` - Bill of Materials設定
- E-11: `test/pom.xml` - テストモジュール設定
- E-12: `Jenkinsfile` - CI/CDパイプライン定義
- E-13: `webpack.config.js` - Webpackビルド設定
- E-14: `src/checkstyle/` - Checkstyle設定ディレクトリ
- E-15: `.github/` - GitHub設定ディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Jenkinsはオープンソースの自動化サーバー | E-02 | ○ |
| C-02 | Javaで構築されている | E-01, E-05 | ○ |
| C-03 | 2,000以上のプラグインをサポート | E-02 | ○ |
| C-04 | Java 21以上が必要 | E-04 | ○ |
| C-05 | Maven 3.9.6以上が必要 | E-04 | ○ |
| C-06 | Remotingバージョンは3355.v388858a_47b_33 | E-01 | ○ |
| C-07 | Node.js 24.13.0を使用 | E-01 | ○ |
| C-08 | Yarn 4.12.0を使用 | E-03 | ○ |
| C-09 | Webpack 5.104.1を使用 | E-03 | ○ |
| C-10 | Babel 7.28.6を使用 | E-03 | ○ |
| C-11 | Sass 1.97.2を使用 | E-03 | ○ |
| C-12 | jQuery 3.7.1を使用 | E-03 | ○ |
| C-13 | ESLint 9.39.2を使用 | E-03 | ○ |
| C-14 | Prettier 3.8.0を使用 | E-03 | ○ |
| C-15 | Checkstyle 13.0.0を使用 | E-01 | ○ |
| C-16 | JaCoCo 0.8.14を使用 | E-01 | ○ |
| C-17 | ANTLR 4.13.2を使用 | E-01 | ○ |
| C-18 | モジュール構成（bom, core, war, test, cli, coverage, websocket） | E-01 | ○ |
| C-19 | WARファイルは`war/target/jenkins.war`に生成 | E-04 | ○ |
| C-20 | 開発サーバー起動コマンド（MAVEN_OPTS設定） | E-04 | ○ |
| C-21 | テストプロファイル（light-test, smoke-test, all-tests） | E-04 | ○ |
| C-22 | `mvn spotless:apply`でフォーマット適用 | E-04 | ○ |
| C-23 | `yarn lint`でリンター実行 | E-03, E-04 | ○ |
| C-24 | `yarn lint:fix`で自動修正 | E-03 | ○ |
| C-25 | MITライセンス | E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠があるため、不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードまたは公式ドキュメントに基づいています

## 6) レビュアーチェックリスト（最小）
- [ ] バージョン情報が最新のpom.xmlおよびpackage.jsonと一致しているか確認
- [ ] ディレクトリ構成が実際のプロジェクト構造と一致しているか確認
- [ ] ビルド・実行コマンドが正しく動作するか確認
- [ ] 開発環境の必要条件が正確であるか確認
