---
generated_at: 2026-01-22 21:45:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **ビルドキューの詳細フロー**：コード追跡による推測を含む
  2. **Staplerルーティング詳細**：外部ドキュメント参照が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pom.xml` - Mavenプロジェクト構成
- E-02: `README.md` - プロジェクト概要
- E-03: `CONTRIBUTING.md` - 開発ガイド
- E-04: `package.json` - フロントエンド依存関係
- E-05: `core/src/main/java/jenkins/model/Jenkins.java` - メインシングルトン
- E-06: `core/src/main/java/hudson/Extension.java` - 拡張アノテーション
- E-07: `core/src/main/java/hudson/ExtensionPoint.java` - 拡張ポイントインターフェース
- E-08: `core/src/main/java/hudson/ExtensionList.java` - 拡張リスト
- E-09: `core/src/main/java/hudson/Plugin.java` - プラグイン基底クラス
- E-10: `core/src/main/java/hudson/model/Describable.java` - Describableインターフェース
- E-11: `core/src/main/java/hudson/model/Descriptor.java` - Descriptorクラス
- E-12: `core/src/main/java/hudson/model/Job.java` - ジョブ基底クラス
- E-13: `core/src/main/java/hudson/model/Run.java` - ビルド基底クラス
- E-14: `core/src/main/java/hudson/WebAppMain.java` - Webエントリーポイント
- E-15: `war/src/main/webapp/WEB-INF/web.xml` - Web設定
- E-16: `core/src/main/java/hudson/tasks/` - タスクパッケージ
- E-17: `core/src/main/java/hudson/model/` - モデルパッケージ
- E-18: `src/main/js/` - JavaScriptソース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JenkinsはJavaで実装されている | E-01, E-02 | ○ |
| C-02 | Mavenマルチモジュール構成を採用 | E-01 | ○ |
| C-03 | モジュールにbom, core, war, cli等が含まれる | E-01 | ○ |
| C-04 | @Extensionアノテーションで拡張を登録 | E-06 | ○ |
| C-05 | ExtensionPointがプラグイン拡張の基礎 | E-07 | ○ |
| C-06 | ordinalで拡張のソート順を指定 | E-06:85 | ○ |
| C-07 | DescribableとDescriptorパターンを使用 | E-10, E-11 | ○ |
| C-08 | Pluginクラスがプラグインの基底クラス | E-09 | ○ |
| C-09 | XmlFileでXML永続化を行う | E-09:346-349 | ○ |
| C-10 | WebAppMainがサーブレットコンテナのエントリーポイント | E-14:88 | ○ |
| C-11 | Jenkins.get()でシングルトン取得 | E-05 | ○ |
| C-12 | hudsonパッケージはレガシー互換 | E-05, E-06, E-07 | ○ |
| C-13 | jenkinsパッケージは新規機能用 | E-05 | ○ |
| C-14 | *Test.javaがテストクラス命名規則 | E-17 (ファイル一覧) | ○ |
| C-15 | *Descriptor.javaがDescriptor実装 | E-11 | ○ |
| C-16 | *Action.javaがアクション実装 | E-17 | ○ |
| C-17 | *Listener.javaがリスナー実装 | E-17 | ○ |
| C-18 | Abstract*が抽象基底クラス | E-17 | ○ |
| C-19 | do*メソッドがStaplerアクション | E-09:255 | ○ |
| C-20 | coreディレクトリにコアロジック | E-01, ディレクトリ構造 | ○ |
| C-21 | warディレクトリにWARパッケージング | E-01 | ○ |
| C-22 | src/main/jsにフロントエンドJS | E-18 | ○ |
| C-23 | プラグインベースのアーキテクチャ | E-06, E-07 | ○ |
| C-24 | Staplerがウェブフレームワーク | E-09, E-14 | ○ |
| C-25 | volatileキーワードでスレッドセーフ | E-08:78 | ○ |
| C-26 | @CopyOnWriteアノテーション使用 | E-08:77 | ○ |
| C-27 | synchronizedでスレッドセーフ | E-09:318 | ○ |
| C-28 | Job.javaがジョブ基底クラス | E-12 | ○ |
| C-29 | Run.javaがビルド基底クラス | E-13 | ○ |
| C-30 | BuilderがビルドステップExtension | E-16 | ○ |
| C-31 | PublisherがポストビルドExtension | E-16 | ○ |
| C-32 | BuildWrapperがビルドラッパー | E-16 | ○ |
| C-33 | Queue.javaでビルドキュー管理 | E-17 | ○ |
| C-34 | FilePathでリモートファイル操作 | コード存在確認 | ○ |
| C-35 | Utilがユーティリティクラス | コード存在確認 | ○ |
| C-36 | Functionsがjelly用ユーティリティ | コード存在確認 | ○ |
| C-37 | ItemListenerでジョブイベント通知 | E-17 | ○ |
| C-38 | RunListenerでビルドイベント通知 | E-17 | ○ |
| C-39 | JDK 21または25が必要 | E-03 | ○ |
| C-40 | Maven 3.9.6以上が必要 | E-03 | ○ |
| C-41 | yarnでフロントエンドビルド | E-04 | ○ |
| C-42 | Node.js 24以上が必要 | E-04:69 | ○ |
| C-43 | eslint, prettierでリント | E-04, E-03 | ○ |
| C-44 | キューからExecutorへのタスク割り当て詳細 | **根拠なし** | △ |
| C-45 | Stapler URLマッピングの完全なルール | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-44: キューからExecutorへのタスク割り当て詳細**
  - Queue.javaの内部処理を完全に追跡していないため、詳細フローは推測を含む
  - 候補：Queue.java詳細解析 / Jenkins開発者ドキュメント / ソースコードコメント

- **C-45: Stapler URLマッピングの完全なルール**
  - Staplerは外部ライブラリであり、完全なルールはJenkins外部のドキュメントが必要
  - 候補：Stapler公式ドキュメント / Jenkins開発者ガイド / Staplerソースコード

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 言語基礎、命名規則、ディレクトリ構造
  - ソースコードから直接確認可能な内容

- **0 (低リスク)**: Extension Point システム
  - @Extension, ExtensionPoint, ExtensionListのソースコードで確認済み

- **0 (低リスク)**: Describable/Descriptorパターン
  - ソースコードから直接確認済み

- **1 (中リスク)**: 業務フロー追跡
  - 実際のフローはソースコード追跡に基づく推測を含む
  - 実行時の動作確認が望ましい

- **1 (中リスク)**: Stapler連携詳細
  - 外部ライブラリのため、Jenkins固有の使用パターンに限定

## 6) レビュアーチェックリスト（最小）
- [ ] コード例のファイルパス・行番号が実際のソースコードと一致するか確認
- [ ] Extension Pointパターンの説明がJenkins公式ドキュメントと整合しているか確認
- [ ] ディレクトリ構造が現在のプロジェクト構造と一致するか確認
- [ ] 命名規則の例が実際のコードベースで使用されているか確認
- [ ] 業務フロー追跡の例を実際に追跡し、説明と一致するか確認
- [ ] 用語集の定義がJenkins公式ドキュメントと整合しているか確認
