# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "External Systems"
        SCM[SCM Systems<br/>Git/SVN/etc]
        AUTH[Authentication<br/>LDAP/AD/OAuth]
        NOTIFY[Notification<br/>Email/Slack/etc]
        REPO[Plugin Repository<br/>updates.jenkins.io]
    end

    subgraph "Jenkins Master"
        subgraph "Presentation Layer"
            STAPLER[Stapler<br/>URL-Object Mapping]
            JELLY[Jelly/Groovy<br/>View Templates]
            WEBUI[Web UI<br/>HTML/JS/CSS]
        end

        subgraph "Application Layer"
            JENKINS[Jenkins.java<br/>Root Object]
            QUEUE[Queue<br/>Build Queue Manager]
            EXECUTOR[Executor<br/>Build Executor]
            PM[PluginManager<br/>Plugin Lifecycle]
        end

        subgraph "Domain Layer"
            JOB[Job/Project<br/>Build Definition]
            BUILD[Build/Run<br/>Build Execution]
            NODE[Node/Computer<br/>Build Agent]
            USER[User<br/>User Management]
        end

        subgraph "Infrastructure Layer"
            XMLFILE[XmlFile<br/>XML Persistence]
            EXTLIST[ExtensionList<br/>Extension Registry]
            SECURITY[SecurityRealm<br/>Authentication]
            AUTHZ[AuthorizationStrategy<br/>Authorization]
        end

        subgraph "Embedded Server"
            WINSTONE[Winstone/Jetty<br/>Servlet Container]
            FILTER[HudsonFilter<br/>Security Filter Chain]
        end
    end

    subgraph "Jenkins Agents"
        AGENT1[Agent Node 1]
        AGENT2[Agent Node 2]
        AGENTN[Agent Node N]
    end

    %% External connections
    SCM -->|Checkout/Poll| JENKINS
    AUTH -->|Authenticate| SECURITY
    JENKINS -->|Notify| NOTIFY
    PM -->|Download| REPO

    %% Internal flow
    WINSTONE --> FILTER
    FILTER --> STAPLER
    STAPLER --> JELLY
    STAPLER --> JENKINS
    JELLY --> WEBUI

    JENKINS --> QUEUE
    JENKINS --> PM
    QUEUE --> EXECUTOR
    EXECUTOR --> BUILD

    JOB --> BUILD
    NODE --> EXECUTOR
    BUILD --> XMLFILE

    EXTLIST --> PM
    SECURITY --> AUTHZ

    %% Agent connections
    JENKINS -->|Remoting/WebSocket| AGENT1
    JENKINS -->|Remoting/WebSocket| AGENT2
    JENKINS -->|Remoting/WebSocket| AGENTN
```

## モジュール構成図

```mermaid
graph TB
    subgraph "jenkins-parent (POM)"
        BOM[bom<br/>Dependency Management]
        CORE[jenkins-core<br/>Core Module]
        WAR[war<br/>WAR Packaging]
        CLI[cli<br/>CLI Client]
        TEST[test<br/>Test Module]
        COVERAGE[coverage<br/>Code Coverage]

        subgraph "websocket"
            WSSPI[websocket-spi<br/>WebSocket SPI]
            WSJETTY[websocket-jetty12-ee9<br/>Jetty Implementation]
        end
    end

    WAR --> CORE
    CORE --> CLI
    CORE --> WSSPI
    WSJETTY --> WSSPI
    TEST --> CORE
    TEST --> WAR
    COVERAGE --> CORE
    COVERAGE --> TEST

    BOM -.->|Dependency Management| CORE
    BOM -.->|Dependency Management| WAR
    BOM -.->|Dependency Management| CLI
```

## パッケージ構造図

```mermaid
graph TB
    subgraph "jenkins-core"
        subgraph "hudson (Legacy Namespace)"
            HM[hudson.model<br/>Domain Models]
            HS[hudson.security<br/>Security]
            HT[hudson.tasks<br/>Build Tasks]
            HTL[hudson.tools<br/>Tool Installations]
            HSL[hudson.slaves<br/>Agent Management]
            HU[hudson.util<br/>Utilities]
            HCLI[hudson.cli<br/>CLI Commands]
            HSCM[hudson.scm<br/>SCM Integration]
            HTR[hudson.triggers<br/>Build Triggers]
            HI[hudson.init<br/>Initialization]
            HL[hudson.lifecycle<br/>Lifecycle]
        end

        subgraph "jenkins (New Namespace)"
            JM[jenkins.model<br/>New Models]
            JS[jenkins.security<br/>Security Extensions]
            JU[jenkins.util<br/>Utilities]
            JI[jenkins.install<br/>Install Wizard]
        end
    end

    JM -->|extends| HM
    JS -->|extends| HS
    JU -->|extends| HU
```

## 拡張ポイントアーキテクチャ

```mermaid
graph TB
    subgraph "Extension Point System"
        EP[ExtensionPoint<br/>Interface]
        EXT[@Extension<br/>Annotation]
        EL[ExtensionList<br/>Registry]
        EF[ExtensionFinder<br/>Discovery]
        GUICE[Guice Injector<br/>DI Container]
    end

    subgraph "Example Extension Points"
        BUILDER[Builder<br/>Build Steps]
        PUBLISHER[Publisher<br/>Post-Build Actions]
        SCM[SCM<br/>Source Control]
        TRIGGER[Trigger<br/>Build Triggers]
        REALM[SecurityRealm<br/>Authentication]
        NODEPRP[NodeProperty<br/>Node Properties]
    end

    EXT -->|marks| BUILDER
    EXT -->|marks| PUBLISHER
    EXT -->|marks| SCM
    EXT -->|marks| TRIGGER
    EXT -->|marks| REALM
    EXT -->|marks| NODEPRP

    BUILDER -->|implements| EP
    PUBLISHER -->|implements| EP
    SCM -->|implements| EP
    TRIGGER -->|implements| EP
    REALM -->|implements| EP
    NODEPRP -->|implements| EP

    EF -->|discovers| EXT
    EF -->|uses| GUICE
    EF -->|populates| EL
```

## リクエスト処理フロー

```mermaid
sequenceDiagram
    participant Client
    participant Winstone
    participant HudsonFilter
    participant Stapler
    participant Jenkins
    participant Jelly

    Client->>Winstone: HTTP Request
    Winstone->>HudsonFilter: Filter Chain
    HudsonFilter->>HudsonFilter: Authentication
    HudsonFilter->>HudsonFilter: CSRF Check
    HudsonFilter->>Stapler: Dispatch
    Stapler->>Stapler: URL to Object Mapping
    Stapler->>Jenkins: Find Target Object
    Jenkins->>Jenkins: Execute Action
    Jenkins->>Jelly: Render View
    Jelly->>Stapler: HTML/JSON Response
    Stapler->>Winstone: Response
    Winstone->>Client: HTTP Response
```

## ビルド実行フロー

```mermaid
sequenceDiagram
    participant Trigger
    participant Queue
    participant Executor
    participant Builder
    participant Publisher
    participant XmlFile

    Trigger->>Queue: Schedule Build
    Queue->>Queue: Wait for Resources
    Queue->>Executor: Assign Build
    Executor->>Executor: Prepare Workspace
    loop Build Steps
        Executor->>Builder: Execute Step
        Builder->>Executor: Step Result
    end
    loop Post-Build Actions
        Executor->>Publisher: Execute Action
        Publisher->>Executor: Action Result
    end
    Executor->>XmlFile: Save Build Result
    Executor->>Queue: Build Complete
```

## 初期化シーケンス

```mermaid
sequenceDiagram
    participant Main
    participant Winstone
    participant WebAppMain
    participant Jenkins
    participant PluginManager
    participant ExtensionList

    Main->>Winstone: Start Server
    Winstone->>WebAppMain: contextInitialized
    WebAppMain->>Jenkins: new Jenkins()

    Note over Jenkins: STARTED

    Jenkins->>PluginManager: List Plugins
    Note over Jenkins: PLUGINS_LISTED

    Jenkins->>PluginManager: Prepare Plugins
    Note over Jenkins: PLUGINS_PREPARED

    Jenkins->>PluginManager: Start Plugins
    Note over Jenkins: PLUGINS_STARTED

    Jenkins->>ExtensionList: Augment Extensions
    Note over Jenkins: EXTENSIONS_AUGMENTED

    Jenkins->>Jenkins: Load System Config
    Note over Jenkins: SYSTEM_CONFIG_LOADED

    Jenkins->>Jenkins: Adapt System Config
    Note over Jenkins: SYSTEM_CONFIG_ADAPTED

    Jenkins->>Jenkins: Load Jobs
    Note over Jenkins: JOB_LOADED

    Jenkins->>Jenkins: Adapt Job Config
    Note over Jenkins: JOB_CONFIG_ADAPTED

    Note over Jenkins: COMPLETED
```

## セキュリティアーキテクチャ

```mermaid
graph TB
    subgraph "Security Layer"
        subgraph "Authentication"
            SR[SecurityRealm]
            HPSR[HudsonPrivateSecurityRealm<br/>Jenkins User DB]
            LSR[LegacySecurityRealm<br/>Container Auth]
            PLUGIN_SR[Plugin SecurityRealms<br/>LDAP/AD/OAuth]
        end

        subgraph "Authorization"
            AS[AuthorizationStrategy]
            FULL[FullControlOnceLoggedIn]
            LEGACY[LegacyAuthorizationStrategy]
            PLUGIN_AS[Plugin Strategies<br/>Matrix/Role-based]
        end

        subgraph "Access Control"
            ACL[ACL]
            PERM[Permission]
            PG[PermissionGroup]
        end

        subgraph "Protection"
            CSRF[CrumbIssuer<br/>CSRF Protection]
            FILTER[ChainedServletFilter<br/>Filter Chain]
        end
    end

    HPSR -->|implements| SR
    LSR -->|implements| SR
    PLUGIN_SR -->|implements| SR

    FULL -->|implements| AS
    LEGACY -->|implements| AS
    PLUGIN_AS -->|implements| AS

    AS -->|uses| ACL
    ACL -->|checks| PERM
    PERM -->|belongs to| PG

    SR --> FILTER
    CSRF --> FILTER
```

## データ永続化構造

```mermaid
graph TB
    subgraph "JENKINS_HOME"
        CONFIG[config.xml<br/>Jenkins Config]
        USERS[users/<br/>User Data]
        JOBS[jobs/<br/>Job Definitions]
        PLUGINS[plugins/<br/>Installed Plugins]
        SECRETS[secrets/<br/>Encrypted Data]
        NODES[nodes/<br/>Agent Configs]
        LOGS[logs/<br/>System Logs]
        WAR_DIR[war/<br/>Exploded WAR]
    end

    subgraph "jobs/job-name/"
        JOB_CONFIG[config.xml<br/>Job Config]
        BUILDS[builds/<br/>Build History]
        WORKSPACE[workspace/<br/>Build Workspace]
    end

    subgraph "builds/build-number/"
        BUILD_XML[build.xml<br/>Build Data]
        BUILD_LOG[log<br/>Console Log]
        CHANGELOG[changelog.xml<br/>SCM Changes]
        ARTIFACTS[archive/<br/>Artifacts]
    end

    JOBS --> JOB_CONFIG
    JOBS --> BUILDS
    JOBS --> WORKSPACE
    BUILDS --> BUILD_XML
    BUILDS --> BUILD_LOG
    BUILDS --> CHANGELOG
    BUILDS --> ARTIFACTS
```
