# アーキテクチャ設計書

## 概要

本ドキュメントは、Jenkins CI/CDオートメーションサーバーのアーキテクチャ設計を記述するものである。JenkinsはJavaで構築されたオープンソースの自動化サーバーであり、ビルド、テスト、デプロイメントのパイプラインを自動化するためのプラットフォームを提供する。本プロジェクトはマルチモジュールのMavenプロジェクトとして構成され、プラグインベースの拡張可能なアーキテクチャを採用している。

## システム全体構成

### アーキテクチャ概要図

システム全体のアーキテクチャ概要図は [アーキテクチャ構成図.md](./アーキテクチャ構成図.md) を参照。

### システム境界と外部連携

| 外部システム | 連携方式 | 用途 |
| --- | --- | --- |
| SCMシステム (Git, SVN等) | HTTP/SSH/各種SCMプロトコル | ソースコード取得、変更検知 |
| ビルドツール (Maven, Gradle等) | CLIプロセス実行 | ビルド実行 |
| エージェントノード | JNLP/SSH/WebSocket | 分散ビルド実行 |
| プラグインリポジトリ | HTTPS REST API | プラグインダウンロード・更新 |
| 外部認証システム (LDAP, AD等) | LDAP/OAuth/SAML | ユーザー認証 |
| 通知システム (メール, Slack等) | SMTP/Webhook | ビルド結果通知 |

## レイヤー構成

### アーキテクチャスタイル

Jenkinsは**プラグインベースのモジュラーアーキテクチャ**を採用している。核となるアーキテクチャパターンは以下の通り：

1. **拡張ポイント (Extension Point) パターン**: ExtensionPointインターフェースとExtensionアノテーションによる動的なプラグイン拡張機構
2. **Staplerによるモデル-ビュー結合**: URLとJavaオブジェクトの自動マッピング
3. **依存性注入 (DI)**: Google Guiceによるコンポーネント管理
4. **イベント駆動**: リスナーパターンによる疎結合なイベント処理

### レイヤー定義

| レイヤー | 責務 | 主なコンポーネント |
| --- | --- | --- |
| Presentation | UI描画、HTTPリクエスト処理 | Jelly/Groovyテンプレート、Stapler、JsBundles |
| Application | ビジネスロジック、ジョブ実行制御 | Jenkins.java、Queue、Executor |
| Domain | ドメインモデル、データ構造 | hudson.model (Job, Build, Node等) |
| Infrastructure | 永続化、外部連携、プラグイン管理 | XmlFile、PluginManager、Remoting |

### レイヤー間の依存関係ルール

- Presentationレイヤーは下位すべてのレイヤーを参照可能
- ApplicationレイヤーはDomain、Infrastructureを参照可能
- DomainレイヤーはInfrastructureの一部（永続化）のみ参照可能
- InfrastructureレイヤーはDomainを参照可能（プラグイン管理等）
- 循環依存は禁止（プラグインを除く）

## モジュール構成

### ドメイン分割

| ドメイン | 責務 | 関連モジュール |
| --- | --- | --- |
| Core | Jenkinsコア機能、モデル、拡張基盤 | jenkins-core |
| War | WARパッケージング、起動処理 | war |
| CLI | コマンドラインインターフェース | cli |
| WebSocket | リアルタイム通信 | websocket/spi, websocket/jetty12-ee9 |
| Test | テスト基盤 | test |
| BOM | 依存関係管理 | bom |
| Coverage | コードカバレッジ | coverage |

### パッケージ構造

```
jenkins-master/
├── core/                           # Jenkinsコアモジュール
│   └── src/main/java/
│       ├── hudson/                 # 旧名前空間（後方互換性）
│       │   ├── model/             # ドメインモデル (Job, Build, Computer等)
│       │   ├── security/          # セキュリティ (認証, 認可, ACL)
│       │   ├── tasks/             # ビルドステップ (Builder, Publisher)
│       │   ├── tools/             # ツールインストール管理
│       │   ├── slaves/            # エージェント管理
│       │   ├── util/              # ユーティリティ
│       │   ├── cli/               # CLIコマンド実装
│       │   ├── scm/               # SCM統合
│       │   ├── triggers/          # トリガー
│       │   ├── init/              # 初期化処理
│       │   └── lifecycle/         # ライフサイクル管理
│       ├── jenkins/               # 新名前空間
│       │   ├── model/            # 新しいドメインモデル (Jenkins.java)
│       │   ├── security/         # セキュリティ拡張
│       │   ├── util/             # ユーティリティ拡張
│       │   └── install/          # インストールウィザード
│       └── org/                   # 外部ライブラリ統合
├── war/                           # WARパッケージングモジュール
│   └── src/main/
│       ├── java/executable/       # スタンドアロン起動処理
│       └── webapp/                # Webリソース
├── cli/                           # CLIクライアントモジュール
├── websocket/                     # WebSocketモジュール
│   ├── spi/                      # SPI定義
│   └── jetty12-ee9/              # Jetty実装
└── test/                          # テストモジュール
```

### コンポーネント依存関係

主要コンポーネント間の依存関係は以下の通り：

1. **Jenkins (jenkins.model.Jenkins)**: システムのルートオブジェクト、全コンポーネントのハブ
2. **PluginManager**: プラグインのライフサイクル管理
3. **ExtensionList**: 拡張ポイント実装の管理
4. **Queue**: ビルドキュー管理
5. **Computer/Node**: ビルドエージェント管理
6. **SecurityRealm/AuthorizationStrategy**: セキュリティ基盤

## ミドルウェア構成

### データベース

| 種類 | ミドルウェア | バージョン | 用途 |
| --- | --- | --- | --- |
| ファイルシステム | XML永続化 (XStream) | 1.4.x | 設定、ジョブ、ビルド履歴の永続化 |

Jenkinsは標準ではRDBMSを使用せず、XMLファイルベースの永続化を採用している。これにより、設定のバージョン管理やバックアップが容易になっている。

### キャッシュ

| ミドルウェア | バージョン | 用途 | TTL |
| --- | --- | --- | --- |
| インメモリキャッシュ | N/A | ジョブ/ビルド情報のメモリキャッシュ | JVMライフサイクル |
| Fingerprint | N/A | ビルド成果物のフィンガープリント | 永続 |

### メッセージキュー

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| 内部Queue | N/A | ビルドジョブのキューイング |
| 内部Executor | N/A | ビルド実行のスケジューリング |

外部メッセージキューシステムは標準では使用しないが、プラグインによる拡張が可能。

### 検索エンジン

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| 内部検索 | N/A | ジョブ、ビルド、ユーザーの検索 |

外部検索エンジンは標準では使用しない。

### その他ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Winstone (Jetty) | 8.1029.vd3071f6b_5988 | 組み込みサーブレットコンテナ |
| Remoting | 3355.v388858a_47b_33 | エージェント通信 |
| Stapler | N/A | URL-オブジェクトマッピング |
| Jelly | N/A | ビューテンプレートエンジン |
| Groovy | N/A | スクリプト実行、テンプレート |
| XStream | N/A | XML永続化 |
| Spring Security | N/A | 認証・認可フレームワーク |
| Google Guice | N/A | 依存性注入 |
| ANTLR | 4.13.2 | パーサー生成（ラベル式、スケジューラ） |

## データフロー

### リクエスト処理の流れ

HTTPリクエストの処理フローは以下の通り：

1. **Winstoneサーブレットコンテナ**: HTTPリクエストを受信
2. **HudsonFilter**: セキュリティフィルタチェーンを実行（認証、CSRF検証等）
3. **Stapler**: URLからJavaオブジェクトへのマッピング
4. **ターゲットオブジェクト**: ビジネスロジック実行
5. **Jellyビュー**: レスポンス生成（HTML/JSON/XML）
6. **レスポンス**: クライアントへ返却

### 非同期処理の流れ

ビルドジョブの非同期実行フローは以下の通り：

1. **トリガー発火**: SCMポーリング、Webhook、スケジュール等
2. **Queueへの投入**: BuildableItemとしてキューに追加
3. **リソース確保**: 適切なノード/エグゼキュータの選択
4. **ビルド実行**: Executorによる実行開始
5. **ステップ実行**: Builder、Publisher等の順次実行
6. **結果永続化**: ビルド結果のXML保存
7. **通知**: リスナーへの完了通知

### データ永続化の流れ

設定・ビルドデータの永続化フローは以下の通り：

1. **オブジェクト変更**: Jenkinsオブジェクトの状態変更
2. **save()呼び出し**: 永続化トリガー
3. **XStream変換**: JavaオブジェクトからXMLへの変換
4. **XmlFile書き込み**: ファイルシステムへの書き出し
5. **SaveableListener通知**: 保存完了通知

## 横断的関心事

### 認証・認可

| 方式 | 実装箇所 | 対象 |
| --- | --- | --- |
| SecurityRealm | hudson.security.SecurityRealm | ユーザー認証 |
| AuthorizationStrategy | hudson.security.AuthorizationStrategy | 権限管理 |
| ACL | hudson.security.ACL | アクセス制御リスト |
| Permission | hudson.security.Permission | 権限定義 |
| CSRF保護 | hudson.security.csrf.CrumbIssuer | フォーム保護 |

標準で提供される認証方式：
- HudsonPrivateSecurityRealm: Jenkins独自のユーザーDB
- LegacySecurityRealm: サーブレットコンテナ委任
- プラグインによる拡張: LDAP, Active Directory, OAuth等

### ロギング・監査

| 種類 | 実装方式 | 保存先 |
| --- | --- | --- |
| アプリケーションログ | java.util.logging | コンソール/ファイル |
| 監査ログ | 各種Listenerによるイベント記録 | Jenkins設定 |
| ビルドログ | Console出力のストリーム記録 | $JENKINS_HOME/jobs/*/builds/*/log |

### エラーハンドリング

エラーハンドリングの方針と実装箇所：

| エラー種別 | ハンドリング方式 | レスポンス |
| --- | --- | --- |
| 認証エラー | HudsonAuthenticationEntryPoint | 401/ログインページリダイレクト |
| 認可エラー | AccessDeniedHandlerImpl | 403エラーページ |
| バリデーションエラー | FormValidation | JSONレスポンス |
| システムエラー | 例外ハンドラ | エラーページ |
| ビルドエラー | Build結果として記録 | コンソールログ |

### トランザクション管理

| 範囲 | 管理方式 | 分離レベル |
| --- | --- | --- |
| オブジェクト単位 | BulkChange | N/A |
| ファイル書き込み | アトミック書き込み | ファイルシステム依存 |

JenkinsはRDBMSを使用しないため、従来のトランザクション管理は適用されない。代わりに、BulkChangeパターンによる一括変更とアトミックなファイル書き込みで整合性を担保する。

## 設計原則・コーディング規約

### 適用している設計原則

| 原則 | 適用箇所 | 実装例 |
| --- | --- | --- |
| 拡張ポイントパターン | 全てのプラグイン拡張 | ExtensionPoint, @Extension |
| 依存性逆転の原則 (DIP) | コア-プラグイン間 | Descriptor/Describable |
| 開放閉鎖の原則 (OCP) | 拡張機構 | ExtensionList動的追加 |
| 単一責任の原則 (SRP) | パッケージ分割 | hudson.model, hudson.security等 |
| リスナーパターン | イベント処理 | ItemListener, SCMListener等 |

### コーディング規約

主要なコーディング規約：

- **コードフォーマット**: Spotless (Java), Prettier (JS/CSS)
- **静的解析**: SpotBugs, Checkstyle
- **テスト**: JUnit 5, Mockito
- **ドキュメント**: Javadoc
- **アクセス修飾子**: @Restricted, access-modifier-annotation
- **非推奨マーク**: @Deprecated, @RestrictedSince
- **ビルド**: Maven 3.x

## 備考

### バージョン情報

- Jenkins バージョン: 2.548
- Java サポートバージョン: 21, 25
- ビルドツール: Maven 3.x
- フロントエンド: Yarn/Webpack (Node.js 24.13.0)

### 初期化シーケンス

Jenkinsの初期化は以下のマイルストーンで管理される（InitMilestone）：

1. STARTED - 初期化開始
2. PLUGINS_LISTED - プラグインメタデータ読み込み
3. PLUGINS_PREPARED - プラグインクラスローダー設定
4. PLUGINS_STARTED - プラグイン起動、拡張ポイント読み込み
5. EXTENSIONS_AUGMENTED - 拡張ポイント追加完了
6. SYSTEM_CONFIG_LOADED - システム設定読み込み
7. SYSTEM_CONFIG_ADAPTED - システム設定適用
8. JOB_LOADED - ジョブ読み込み
9. JOB_CONFIG_ADAPTED - ジョブ設定適用
10. COMPLETED - 初期化完了

### プラグインアーキテクチャ

プラグインは以下の仕組みで拡張を提供する：

1. **ExtensionPoint実装**: 拡張ポイントインターフェースを実装
2. **@Extensionアノテーション**: 自動発見用のマーカー
3. **SezPoz**: コンパイル時のアノテーション処理
4. **ExtensionFinder**: 実行時のクラス発見
5. **ExtensionList**: 拡張実装の管理

### マルチノードアーキテクチャ

Jenkinsはマスター/エージェントアーキテクチャを採用：

- **マスター**: Jenkins.java インスタンス、UI、スケジューリング
- **エージェント**: リモートビルド実行、Remoting経由で通信
- **通信方式**: SSH、JNLP、WebSocket (Jetty)
